WeaponLevelTables = {}
WeaponLevelTables.DefaultWeaponExperienceLevels = {0, 50, 150, 300, 500, 750, 1050, 1400, 1800, 2250, 2750, 3300, 3900, 4550, 5250, 6000, 6800, 7650, 8550, 9500, 10500, 11550, 12650, 13800, 15000, 16250, 17550, 18900, 20300, 21750, 23250, 24800, 26400, 28050, 29750, 31500, 33300, 35150, 37050, 39000, 41000, 43050, 45150, 47300, 49500, 51750, 54050, 56400, 58800, 61250, 63750, 66300, 68900, 71550, 74250, 77000, 79800, 82650, 85550, 88500, 91500, 94550, 97650, 100800, 104000, 107250, 110550, 113900, 117300, 120750, 124250, 127800, 131400, 135050, 138750, 142500, 146300, 150150, 154050, 158000, 162000, 166050, 170150, 174300, 178500, 182750, 187050, 191400, 195800, 200250, 204750, 209300, 213900, 218550, 223250, 228000, 232800, 237650, 242550, 247500, 252500}
WeaponLevelTables.DefaultStepWeaponExperienceLevels = {0, 550, 2500, 12500, 30000, 50000}

WeaponLevelTables.DefaultBaseWeaponDamageBonus = {0, 5, 13, 20, 44, 66}

WeaponLevelTables.DefaultSwordDamageBonus = {0, 5, 10, 17, 39, 60}
WeaponLevelTables.UncommonSwordDamageBonus = {0, 8, 17, 25, 50, 73}
WeaponLevelTables.RareSwordDamageBonus = {0, 11, 21, 31, 57, 81}
WeaponLevelTables.RelicSwordDamageBonus = {0, 15, 27, 35, 63, 88}
WeaponLevelTables.LivingSwordDamageBonus = {0, 5, 17, 31, 63, 100}

WeaponLevelTables.DefaultHammerDamageBonus = {0, 6, 16, 26, 57, 86}
WeaponLevelTables.UncommonHammerDamageBonus = {0, 9, 21, 33, 66, 97}
WeaponLevelTables.RareHammerDamageBonus = {0, 12, 26, 40, 75, 108}
WeaponLevelTables.RelicHammerDamageBonus = {0, 15, 31, 47, 84, 119}
WeaponLevelTables.LivingHammerDamageBonus = {0, 6, 21, 40, 84, 150}

WeaponLevelTables.DefaultPistolDamageBonus = {0, 5, 12, 18, 39, 59}
WeaponLevelTables.UncommonPistolDamageBonus = {0, 8, 17, 25, 48, 70}
WeaponLevelTables.RarePistolDamageBonus = {0, 10, 20, 29, 53, 76}
WeaponLevelTables.RelicPistolDamageBonus = {0, 13, 25, 36, 72, 87}
WeaponLevelTables.LivingPistolDamageBonus = {0, 5, 17, 29, 72, 100}

WeaponLevelTables.DefaultRifleDamageBonus = {0, 3, 10, 18, 41, 62}
WeaponLevelTables.UncommonRifleDamageBonus = {0, 6, 15, 25, 50, 73}
WeaponLevelTables.RareRifleDamageBonus = {0, 9, 20, 32, 59, 84}
WeaponLevelTables.RelicRifleDamageBonus = {0, 12, 25, 39, 68, 95}
WeaponLevelTables.LivingRifleDamageBonus = {0, 3, 15, 32, 68, 120}

WeaponLevelTables.DefaultBaseSpellDamageBonus = {0, 4, 10, 16, 35, 64}
WeaponLevelTables.ChargeTimes = {}
WeaponLevelTables.ChargeTimes[1] = {}
WeaponLevelTables.ChargeTimes[2] = {}
WeaponLevelTables.ChargeTimes[3] = {}
WeaponLevelTables.ChargeTimes[4] = {}
WeaponLevelTables.ChargeTimes[5] = {}
WeaponLevelTables.ChargeTimes[6] = {}

WeaponLevelTables.ChargeTimes[1][0] = 0.250000000
WeaponLevelTables.ChargeTimes[1][1] = 2.800000000
WeaponLevelTables.ChargeTimes[1][2] = 8.400000000
WeaponLevelTables.ChargeTimes[1][3] = 14.930000000
WeaponLevelTables.ChargeTimes[1][4] = 28

WeaponLevelTables.ChargeTimes[2][0] = 0.250000000
WeaponLevelTables.ChargeTimes[2][1] = 0.300000000
WeaponLevelTables.ChargeTimes[2][2] = 5.500000000
WeaponLevelTables.ChargeTimes[2][3] = 9.800000000
WeaponLevelTables.ChargeTimes[2][4] = 18.500000000

WeaponLevelTables.ChargeTimes[3][0] = 0.250000000
WeaponLevelTables.ChargeTimes[3][1] = 0.300000000
WeaponLevelTables.ChargeTimes[3][2] = 0.900000000
WeaponLevelTables.ChargeTimes[3][3] = 6.500000000
WeaponLevelTables.ChargeTimes[3][4] = 12.200000000

WeaponLevelTables.ChargeTimes[4][0] = 0.250000000
WeaponLevelTables.ChargeTimes[4][1] = 0.300000000
WeaponLevelTables.ChargeTimes[4][2] = 0.900000000
WeaponLevelTables.ChargeTimes[4][3] = 1.600000000
WeaponLevelTables.ChargeTimes[4][4] = 8

WeaponLevelTables.ChargeTimes[5][0] = 0.250000000
WeaponLevelTables.ChargeTimes[5][1] = 0.300000000
WeaponLevelTables.ChargeTimes[5][2] = 0.900000000
WeaponLevelTables.ChargeTimes[5][3] = 1.600000000
WeaponLevelTables.ChargeTimes[5][4] = 3

WeaponLevelTables.ChargeTimes[6][0] = 0.250000000
WeaponLevelTables.ChargeTimes[6][1] = 0.300000000
WeaponLevelTables.ChargeTimes[6][2] = 0.900000000
WeaponLevelTables.ChargeTimes[6][3] = 1.600000000
WeaponLevelTables.ChargeTimes[6][4] = 3

WeaponLevelTables.BaseWeaponLevelScripts = {}
WeaponLevelTables.LegendaryWeaponLevelScripts = {}
WeaponLevelTables.LivingWeaponLevelScripts = {}
WeaponLevelTables.BaseGauntletLevelScripts = {}

WeaponLevelTables.BaseWeaponLevelScripts.__index = WeaponLevelTables.BaseWeaponLevelScripts

setmetatable(WeaponLevelTables.LegendaryWeaponLevelScripts, WeaponLevelTables.BaseWeaponLevelScripts)
WeaponLevelTables.LegendaryWeaponLevelScripts.__index = WeaponLevelTables.LegendaryWeaponLevelScripts

setmetatable(WeaponLevelTables.LivingWeaponLevelScripts, WeaponLevelTables.BaseWeaponLevelScripts)
WeaponLevelTables.LivingWeaponLevelScripts.__index = WeaponLevelTables.LivingWeaponLevelScripts

setmetatable(WeaponLevelTables.BaseGauntletLevelScripts, WeaponLevelTables.BaseWeaponLevelScripts)
WeaponLevelTables.BaseGauntletLevelScripts.__index = WeaponLevelTables.BaseGauntletLevelScripts

WeaponLevelTables.LegendarySwordLevelScripts = {}
WeaponLevelTables.UncommonLegendarySwordLevelScripts = {}
WeaponLevelTables.RareLegendarySwordLevelScripts = {}
WeaponLevelTables.RelicLegendarySwordLevelScripts = {}

WeaponLevelTables.LegendaryHammerLevelScripts = {}
WeaponLevelTables.UncommonLegendaryHammerLevelScripts = {}
WeaponLevelTables.RareLegendaryHammerLevelScripts = {}
WeaponLevelTables.RelicLegendaryHammerLevelScripts = {}

WeaponLevelTables.LegendaryPistolLevelScripts = {}
WeaponLevelTables.UncommonLegendaryPistolLevelScripts = {}
WeaponLevelTables.RareLegendaryPistolLevelScripts = {}
WeaponLevelTables.RelicLegendaryPistolLevelScripts = {}

WeaponLevelTables.LegendaryRifleLevelScripts = {}
WeaponLevelTables.UncommonLegendaryRifleLevelScripts = {}
WeaponLevelTables.RareLegendaryRifleLevelScripts = {}
WeaponLevelTables.RelicLegendaryRifleLevelScripts = {}

WeaponLevelTables.EnflameGauntletLevelScripts = {}
WeaponLevelTables.LightningGauntletLevelScripts = {}
WeaponLevelTables.IceStormGauntletLevelScripts = {}
WeaponLevelTables.ForcePushGauntletLevelScripts = {}
WeaponLevelTables.VortexGauntletLevelScripts = {}
WeaponLevelTables.SwordsGauntletLevelScripts = {}

setmetatable(WeaponLevelTables.LegendarySwordLevelScripts, WeaponLevelTables.LegendaryWeaponLevelScripts)
WeaponLevelTables.LegendarySwordLevelScripts.__index = WeaponLevelTables.LegendarySwordLevelScripts
setmetatable(WeaponLevelTables.UncommonLegendarySwordLevelScripts, WeaponLevelTables.LegendarySwordLevelScripts)
setmetatable(WeaponLevelTables.RareLegendarySwordLevelScripts, WeaponLevelTables.LegendarySwordLevelScripts)
setmetatable(WeaponLevelTables.RelicLegendarySwordLevelScripts, WeaponLevelTables.LegendarySwordLevelScripts)

setmetatable(WeaponLevelTables.LegendaryHammerLevelScripts, WeaponLevelTables.LegendaryWeaponLevelScripts)
WeaponLevelTables.LegendaryHammerLevelScripts.__index = WeaponLevelTables.LegendaryHammerLevelScripts
setmetatable(WeaponLevelTables.UncommonLegendaryHammerLevelScripts, WeaponLevelTables.LegendaryHammerLevelScripts)
setmetatable(WeaponLevelTables.RareLegendaryHammerLevelScripts, WeaponLevelTables.LegendaryHammerLevelScripts)
setmetatable(WeaponLevelTables.RelicLegendaryHammerLevelScripts, WeaponLevelTables.LegendaryHammerLevelScripts)

setmetatable(WeaponLevelTables.LegendaryPistolLevelScripts, WeaponLevelTables.LegendaryWeaponLevelScripts)
WeaponLevelTables.LegendaryPistolLevelScripts.__index = WeaponLevelTables.LegendaryPistolLevelScripts
setmetatable(WeaponLevelTables.UncommonLegendaryPistolLevelScripts, WeaponLevelTables.LegendaryPistolLevelScripts)
setmetatable(WeaponLevelTables.RareLegendaryPistolLevelScripts, WeaponLevelTables.LegendaryPistolLevelScripts)
setmetatable(WeaponLevelTables.RelicLegendaryPistolLevelScripts, WeaponLevelTables.LegendaryPistolLevelScripts)

setmetatable(WeaponLevelTables.LegendaryRifleLevelScripts, WeaponLevelTables.LegendaryWeaponLevelScripts)
WeaponLevelTables.LegendaryRifleLevelScripts.__index = WeaponLevelTables.LegendaryRifleLevelScripts
setmetatable(WeaponLevelTables.UncommonLegendaryRifleLevelScripts, WeaponLevelTables.LegendaryRifleLevelScripts)
setmetatable(WeaponLevelTables.RareLegendaryRifleLevelScripts, WeaponLevelTables.LegendaryRifleLevelScripts)
setmetatable(WeaponLevelTables.RelicLegendaryRifleLevelScripts, WeaponLevelTables.LegendaryRifleLevelScripts)

setmetatable(WeaponLevelTables.EnflameGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)
setmetatable(WeaponLevelTables.LightningGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)
setmetatable(WeaponLevelTables.IceStormGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)
setmetatable(WeaponLevelTables.ForcePushGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)
setmetatable(WeaponLevelTables.VortexGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)
setmetatable(WeaponLevelTables.SwordsGauntletLevelScripts, WeaponLevelTables.BaseGauntletLevelScripts)

WeaponLevelTables.LivingSwordLevelScripts = {}
WeaponLevelTables.LivingHammerLevelScripts = {}
WeaponLevelTables.LivingPistolLevelScripts = {}
WeaponLevelTables.LivingRifleLevelScripts = {}

setmetatable(WeaponLevelTables.LivingSwordLevelScripts, WeaponLevelTables.LivingWeaponLevelScripts)
setmetatable(WeaponLevelTables.LivingHammerLevelScripts, WeaponLevelTables.LivingWeaponLevelScripts)
setmetatable(WeaponLevelTables.LivingPistolLevelScripts, WeaponLevelTables.LivingWeaponLevelScripts)
setmetatable(WeaponLevelTables.LivingRifleLevelScripts, WeaponLevelTables.LivingWeaponLevelScripts)

function WeaponLevelTables.BaseWeaponLevelScripts.GetExperienceForLevel(level)
	if level < 6 then
		return WeaponLevelTables.DefaultStepWeaponExperienceLevels[level]
	else
		return (WeaponLevelTables.DefaultStepWeaponExperienceLevels[6] + (100000 * (level - 6)))
	end
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetExperienceForPreLevel(level)
	if 2 <= level then
		prev_level = WeaponLevelTables.BaseWeaponLevelScripts.GetExperienceForLevel((level - 1))
		this_level = WeaponLevelTables.BaseWeaponLevelScripts.GetExperienceForLevel(level)
		return (prev_level + ((this_level - prev_level) * 0.950000000))
	else
		return 0
	end
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultBaseWeaponDamageBonus[level]
end

function WeaponLevelTables.LivingSwordLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.LivingSwordDamageBonus[level]
end
function WeaponLevelTables.LivingPistolLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.LivingPistolDamageBonus[level]
end
function WeaponLevelTables.LivingHammerLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.LivingHammerDamageBonus[level]
end
function WeaponLevelTables.LivingRifleLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.LivingRifleDamageBonus[level]
end

function WeaponLevelTables.LegendaryPistolLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultPistolDamageBonus[level]
end
function WeaponLevelTables.UncommonLegendaryPistolLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.UncommonPistolDamageBonus[level]
end
function WeaponLevelTables.RareLegendaryPistolLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RarePistolDamageBonus[level]
end
function WeaponLevelTables.RelicLegendaryPistolLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RelicPistolDamageBonus[level]
end

function WeaponLevelTables.LegendaryHammerLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultHammerDamageBonus[level]
end
function WeaponLevelTables.UncommonLegendaryHammerLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.UncommonHammerDamageBonus[level]
end
function WeaponLevelTables.RareLegendaryHammerLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RareHammerDamageBonus[level]
end
function WeaponLevelTables.RelicLegendaryHammerLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RelicHammerDamageBonus[level]
end

function WeaponLevelTables.LegendaryRifleLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultRifleDamageBonus[level]
end
function WeaponLevelTables.UncommonLegendaryRifleLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.UncommonRifleDamageBonus[level]
end
function WeaponLevelTables.RareLegendaryRifleLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RareRifleDamageBonus[level]
end
function WeaponLevelTables.RelicLegendaryRifleLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RelicRifleDamageBonus[level]
end
function WeaponLevelTables.LegendarySwordLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultSwordDamageBonus[level]
end
function WeaponLevelTables.UncommonLegendarySwordLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.UncommonSwordDamageBonus[level]
end
function WeaponLevelTables.RareLegendarySwordLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RareSwordDamageBonus[level]
end
function WeaponLevelTables.RelicLegendarySwordLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.RelicSwordDamageBonus[level]
end
function WeaponLevelTables.BaseGauntletLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultBaseSpellDamageBonus[level]
end
function WeaponLevelTables.EnflameGauntletLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultBaseSpellDamageBonus[level]
end
function WeaponLevelTables.LightningGauntletLevelScripts.GetExtraDamageForLevel(level)
	return (0.700000000 * WeaponLevelTables.DefaultBaseSpellDamageBonus[level])
end
function WeaponLevelTables.SwordsGauntletLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultBaseSpellDamageBonus[level]
end
function WeaponLevelTables.VortexGauntletLevelScripts.GetExtraDamageForLevel(level)
	return (0.250000000 * WeaponLevelTables.DefaultBaseSpellDamageBonus[level])
end
function WeaponLevelTables.ForcePushGauntletLevelScripts.GetExtraDamageForLevel(level)
	return (0.250000000 * WeaponLevelTables.DefaultBaseSpellDamageBonus[level])
end
function WeaponLevelTables.IceStormGauntletLevelScripts.GetExtraDamageForLevel(level)
	return WeaponLevelTables.DefaultBaseSpellDamageBonus[level]
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetRagdollImpulseUpForLevel(level)
	return (1 + ((level - 1) * 0.001000000))
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetRagdollImpulseMagnitudeForLevel(level)
	return (level / 0.200000000)
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetIlluminationBrightnessForLevel(level)
	if level == 0 then
		return 0
	elseif level == 1 then
		return 0
	elseif level == 2 then
		return 0.1
	elseif level == 3 then
		return 0.2
	elseif level == 4 then
		return 0.3
	elseif level == 5 then
		return 0.4
	elseif level == 6 then
		return 0.5
	end
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetSpellChargeTimeForLevel(level, charge_index)
	return WeaponLevelTables.ChargeTimes[level][charge_index]
end

function WeaponLevelTables.BaseWeaponLevelScripts.IsSpecialLevel(level)
	if level ~= 3 and level == 5 or level == 9 then
		return true
	else
		return false
	end
end
function WeaponLevelTables.LegendaryWeaponLevelScripts.IsSpecialLevel(level)
	if level ~= 2 and level ~= 4 and level == 6 or level > 7 then
		return true
	else
		return false
	end
end
function WeaponLevelTables.BaseGauntletLevelScripts.IsSpecialLevel(level)
	return true
end

function WeaponLevelTables.BaseWeaponLevelScripts.IsMiniSpecialLevel(level)
	return false
end
function WeaponLevelTables.BaseWeaponLevelScripts.GetExtraMoneyValue(level)
	if level < 6 then
		return ((WeaponLevelTables.DefaultStepWeaponExperienceLevels[level] / WeaponLevelTables.DefaultStepWeaponExperienceLevels[6]) * 100000)
	else
		return 100000
	end
end

function WeaponLevelTables.BaseGauntletLevelScripts.GetExtraMoneyValue(level)
	if level < 6 then
		return ((WeaponLevelTables.DefaultStepWeaponExperienceLevels[level] / WeaponLevelTables.DefaultStepWeaponExperienceLevels[6]) * 100000)
	else
		return 100000
	end
end
function WeaponLevelTables.LegendaryWeaponLevelScripts.GetExtraMoneyValue(level)
	return 0
end
function WeaponLevelTables.BaseWeaponLevelScripts.OnLevelUp(weapon_entity)
end
function WeaponLevelTables.LivingWeaponLevelScripts.OnLevelUp(weapon_entity)
end
function WeaponLevelTables.BaseGauntletLevelScripts.OnLevelUp(weapon_entity)
	local level = CustomisableWeapon.GetLevel(weapon_entity)
	local textures_path = "Art\\Characters\\Heros\\gauntlets\\Pictures\\_SharedTextures\\Hero_GauntletFire_"
	
	if level == 3 then
		SpellGauntlet.OverrideModels(weapon_entity, "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_male_r_fireV2\Hero_Gauntlet_Male_R_FireV2.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_male_l_fireV2\Hero_Gauntlet_Male_L_FireV2.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_female_r_fireV2\Hero_Gauntlet_Female_R_FireV2.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_female_l_fireV2\Hero_Gauntlet_Female_L_FireV2.mdl")
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_LIGHTNING, (textures_path .. "LightningV2_DIFF.tex"), (textures_path .. "LightningV2_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_FIREBALL, (textures_path .. "EnflameV2_DIFF.tex"), (textures_path .. "EnflameV2_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_SWORDS, (textures_path .. "DamoclesV2_DIFF.tex"), (textures_path .. "DamoclesV2_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_VORTEX, (textures_path .. "VortexV2_DIFF.tex"), (textures_path .. "VortexV2_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_FORCE_PUSH, (textures_path .. "ForcepushV2_DIFF.tex"), (textures_path .. "ForcepushV2_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_ICE_STORM, (textures_path .. "Ice stormV2_DIFF.tex"), (textures_path .. "Ice stormV2_Spec.tex"))
		SpellGauntlet.PostOverrideModelsAndTexturesUpdate(weapon_entity)
	elseif level == 6 then
		SpellGauntlet.OverrideModels(weapon_entity, "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_male_r_fireV3\Hero_Gauntlet_Male_R_FireV3.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_male_l_fireV3\Hero_Gauntlet_Male_L_FireV3.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_female_r_fireV3\Hero_Gauntlet_Female_R_FireV3.mdl", "Art\Characters\Heros\gauntlets\dotxsi\hero_gauntlet_female_l_fireV3\Hero_Gauntlet_Female_L_FireV3.mdl")
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_LIGHTNING, (textures_path .. "LightningV3_DIFF.tex"), (textures_path .. "LightningV3_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_FIREBALL, (textures_path .. "EnflameV3_DIFF.tex"), (textures_path .. "EnflameV3_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_SWORDS, (textures_path .. "DamoclesV3_DIFF.tex"), (textures_path .. "DamoclesV3_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_VORTEX, (textures_path .. "VortexV3_DIFF.tex"), (textures_path .. "VortexV3_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_FORCE_PUSH, (textures_path .. "ForcepushV3_DIFF.tex"), (textures_path .. "ForcepushV3_Spec.tex"))
		SpellGauntlet.OverrideSpellTypeTextures(weapon_entity, ESpellType.SPELL_ICE_STORM, (textures_path .. "Ice stormV3_DIFF.tex"), (textures_path .. "Ice stormV3_Spec.tex"))
		SpellGauntlet.PostOverrideModelsAndTexturesUpdate(weapon_entity)
	end
end

FollowerBalancing = {}
function FollowerBalancing.GetFollowersForGuildSealLevel(level)

	local Multiplier = 0
	for i = 0, (level - 1), 1 do
		Multiplier = Multiplier + i
	end
	return ((15 * level)+(Multiplier * 1))
end

ExperienceBalancing = {}
ExperienceBalancing.HeroStageExperienceValues = {4200, 17000, 45000, 72000, 125000, 185000, 250000, 330000, 410000, 1000000000}
ExperienceBalancing.WeaponBonus = {0, 2000, 6000, 15000, 30000, 45000}
function ExperienceBalancing.GetHeroStageForExperience(total_xp)
	local melee = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_MELEE)
	local ranged = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_RANGED)
	local spell = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_SPELL)
	weapon_xp = ((ExperienceBalancing.WeaponBonus[(melee + 1)] + ExperienceBalancing.WeaponBonus[(ranged + 1)]) + ExperienceBalancing.WeaponBonus[(spell + 1)])
	for i=1, 9, 1 do
		if (total_xp + weapon_xp) < ExperienceBalancing.HeroStageExperienceValues[i] then
			return i
		end
	end
	return 10
end
function ExperienceBalancing.DebugGetHeroStageBaseValueForExperience(total_xp)
	local melee = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_MELEE)
	local ranged = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_RANGED)
	local spell = Stats.GetHeroAbilityLevel(GetLocalHero(), EHeroAbilityType.HERO_ABILITY_WEAPON_LEVEL_SPELL)
	weapon_xp = ((ExperienceBalancing.WeaponBonus[(melee + 1)] + ExperienceBalancing.WeaponBonus[(ranged + 1)]) + ExperienceBalancing.WeaponBonus[(spell + 1)])
	return (total_xp + weapon_xp)
end