// gdbdumper.cpp : parse/dump Fable 3 GDB files

#ifdef WIN32
#include "stdafx.h"
#endif

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "fcntl.h"
#ifdef WIN32
#include "io.h"
#endif
#include "memory.h"
#include <map>
#include <algorithm>
#ifdef WIN32
#include <hash_map>
#else
#include <ext/hash_map>
namespace std { using namespace __gnu_cxx; }
#define stricmp strcasecmp
#endif


#define endian32_swap(value) \
	((((unsigned int)((value) & 0x000000FF)) << 24) | \
	(((unsigned int)((value) & 0x0000FF00)) << 8) | \
	(((unsigned int)((value) & 0x00FF0000)) >> 8) | \
	(((unsigned int)((value) & 0xFF000000)) >> 24))	



typedef struct DTYPE
{
	unsigned short arraynumber ;
	unsigned short datatype ;
	//0000 = boolean
	//0100 = dword
	//0200 = dword lots of GroupIndex
	//0300 = float
	//0400 = string hash
	//0500 = numeric indicating an enumerated type
	//0600 = object hash
	//0700 = object hash
} dtype ;

typedef struct GDBTEMPLATE
{
	unsigned char no_components ;
	unsigned int num_parts ;
	unsigned int *hashes ;
	unsigned int *hash_offsets ;
	unsigned int *datatype_offsets ;
	dtype *dtypes ;
} gdbtemplate ;

typedef struct OBJECT
{
	unsigned int templatepointer ;
	unsigned int templatepointer_offset ;
	unsigned int *template_data ;
	unsigned int *data_offsets ;
	unsigned int unknown_word ;
	unsigned int object_number ;
	unsigned int object_hash ;
} object ;

typedef struct UNKNOWNHASH
{
	float value ;
	unsigned int offset ;
} unknownobject ;

int main(int argc, char* argv[])
{
	unsigned char *buf ;
	unsigned char *bufptr ;
	unsigned char *templatestart ;

	unsigned int templatepointer ;
	unsigned int templatesize ;
	unsigned int labelcount ;
	unsigned int stringlen ;
	unsigned int labelindexsize ;
	unsigned int offset ;
	unsigned int num_templates ;
	unsigned int num_objects ;
	unsigned int template_data_offset;
	unsigned int index_data_offset;
	unsigned int unknown_count ;
	unsigned int maxstrlen = 0 ;
	unsigned int filesize ;
	unsigned int dolabels = 0 ;
	unsigned int dounknown = 0 ;
	unsigned int doall = 1 ;
	unsigned int dofloat = 0 ;
	unsigned int currarg ;

	object *objects ;
	object *objectptr ;

#ifdef WIN32
	typedef stdext::hash_map<unsigned int, gdbtemplate*> map_templates;
	typedef stdext::hash_map<unsigned int, unknownobject*> map_unknownhash;
	typedef stdext::hash_map<unsigned int, object*> map_object;
	typedef stdext::hash_map<unsigned int, char*> map_hashlabel;
#else
	typedef std::hash_map<unsigned int, gdbtemplate*> map_templates;
	typedef std::hash_map<unsigned int, unknownobject*> map_unknownhash;
	typedef std::hash_map<unsigned int, object*> map_object;
	typedef std::hash_map<unsigned int, char*> map_hashlabel;
#endif

	map_unknownhash unknownhash ;
	map_templates templates ;
	map_object object_mapping ;
	map_hashlabel labels ;


	if ( argc < 2 )
	{
		printf( "usage:\r\n%s [-l] [-u] [-f] filename.gdb\r\n", argv[0] ) ;
		printf( "  -l : dump labels\r\n" ) ;
		printf( "  -u : dump unknown hash table\r\n" ) ;
		printf( "  -f : print float values for float types instead of hex\r\n" ) ;
		printf( "  no options specified will dump entire gdb, for example:\r\n" ) ;
		printf( "     %s globals_globals.gdb > globals.txt\r\n", argv[0] ) ;
		printf( "     %s -l globals_globals.gdb > globals_labels.txt\r\n", argv[0] ) ;
		printf( "     %s -u globals_globals.gdb > globals_unknown.txt\r\n", argv[0] ) ;
		printf( "\r\n" ) ;
		printf( "O#  : Object number\r\n" ) ;
		printf( "OH  : Object hash\r\n" ) ;
		printf( "TP  : Template pointer\r\n" ) ;
		printf( "TO  : Template pointer file offset\r\n" ) ;
		printf( "UW  : Unknown object word\r\n" ) ;
		printf( "NO  : No components?\r\n" ) ;
		printf( "\r\n") ;
		printf( "T#  : Template part number\r\n" ) ;
		printf( "HO  : Template hash file offset\r\n" ) ;
		printf( "HV  : Template hash value \r\n" ) ;
		printf( "DTO : Data type file offset\r\n" ) ;
		printf( "DT  : Data type\r\n" ) ;
		printf( "DO  : Data file offset\r\n" ) ;
		printf( "D   : Data\r\n" ) ;
		return 1 ;
	}

	currarg = 1 ;

	while ( ( currarg < argc ) && ( argv[currarg][0] == '-' ) )
	{
		if ( strlen(argv[currarg]) > 1 )
		{
			switch ( argv[currarg][1] )
			{
			case 'f' :
			case 'F' :
				{
					dofloat = 1 ;
					break ;
				}
			case 'l' :
			case 'L' :
				{
					dolabels = 1 ;
					doall = 0 ;
					break ;
				}
			case 'u' :
			case 'U' :
				{
					dounknown = 1 ;
					doall = 0 ;
					break ;
				}
			default : break ;
			}
		}
		currarg++ ;
	}

	if ( currarg == argc )
	{
		printf( "usage:\r\n%s [-l] [-u] filename.gdb\r\n", argv[0] ) ;
		return 1 ;
	}

	FILE *f = fopen( argv[currarg], "rb" ) ;

	if ( f == NULL )
	{
		printf( "Could not open %s for reading\r\n", argv[currarg] ) ;
		return 1 ;
	}

	fseek( f, 0, SEEK_END ) ;

	filesize = ftell(f) ;

	buf = (unsigned char*)malloc( filesize ) ;

	fseek( f, 0, SEEK_SET ) ;

	fread( buf, 1, filesize, f ) ;

	fclose( f ) ;

	num_objects = *((unsigned int*)(buf+4)) ;
	template_data_offset = *((unsigned int*)(buf+8)) ;
	index_data_offset = *((unsigned int*)(buf+12)) ;
	unknown_count = *((unsigned int*)(buf+16)) ;

	bufptr = buf + 0x18 ;

	//num objects 0x0001ba79 

	objects = (object*)malloc( sizeof(OBJECT)* num_objects ) ;

	// 0x18

	for ( int i = 0 ; i < num_objects ; i++ )
	{
		(objects+i)->templatepointer = *((unsigned int*)(bufptr)) ;
		(objects+i)->templatepointer_offset = bufptr - buf ; 

		offset = (template_data_offset + 0x18 + ((objects+i)->templatepointer) ) ;
		templatesize = (*(buf+offset)) + (*(buf+offset+1)) + ((*(buf+offset+2))*256) ; 

		(objects+i)->template_data = (unsigned int*)malloc( sizeof(unsigned int)*templatesize ) ;
		(objects+i)->data_offsets = (unsigned int*)malloc( sizeof(unsigned int)*templatesize ) ;

		bufptr +=4 ;

		unsigned int *tptr = (objects+i)->template_data ;
		unsigned int *optr = (objects+i)->data_offsets ;

		for ( int j = 0 ; j < templatesize ; j++ )
		{
			*tptr = *((unsigned int*)(bufptr)) ;
			*optr = bufptr - buf ;
			bufptr += 4 ;
			tptr++ ;
			optr++ ;
		}
	}

	templatestart = bufptr ;
	num_templates = 0 ;

	//0x20e948

	while ( (bufptr - templatestart) < index_data_offset )
	{
		//printf( "%08.8X\r\n", bufptr-templatestart ) ;
		templatesize = (*(bufptr)) + (*(bufptr+1)) + ((*(bufptr+2))*256) ; 
		bufptr += 4 + ( 8 * templatesize ) ;
		num_templates++ ;
	}

	bufptr = templatestart ;

	//0x20e948 rewind

	while ( (bufptr - templatestart) < index_data_offset )
	{
		gdbtemplate* tmp = (gdbtemplate*)malloc( sizeof(gdbtemplate) ) ;
		unsigned int templateptr = (bufptr - templatestart) ;

		//printf( "%08.8X\r\n", bufptr-templatestart ) ;
		tmp->no_components = *(bufptr) ;
		tmp->num_parts = ((*(bufptr+1))) + ((*(bufptr+2))*256) ;


		tmp->hashes = (unsigned int*)malloc( sizeof(unsigned int) * tmp->num_parts ) ;
		tmp->dtypes = (dtype*)malloc( sizeof(dtype)*tmp->num_parts) ;
		tmp->hash_offsets = (unsigned int*)malloc( sizeof(unsigned int) * tmp->num_parts ) ;
		tmp->datatype_offsets = (unsigned int*)malloc( sizeof(unsigned int) * tmp->num_parts ) ;

		bufptr+=4 ;

		for ( int i = 0 ; i < tmp->num_parts ; i++ )
		{
			*(tmp->hashes+i) = *((unsigned int*)(bufptr)) ;
			*(tmp->hash_offsets+i) = bufptr-buf ;
			bufptr += 4 ;
		}

		for ( int i = 0 ; i < tmp->num_parts ; i++ )
		{
			(tmp->dtypes+i)->arraynumber = ((*(bufptr))) + ((*(bufptr+1))) ;
			(tmp->dtypes+i)->datatype = ((*(bufptr+2))) + ((*(bufptr+3))) ;
			*(tmp->datatype_offsets+i) = bufptr-buf ;
			bufptr += 4 ;
		}

		templates.insert(std::pair<unsigned int, gdbtemplate*>(templateptr, tmp));

	}

	//0x2afbd8

	for ( int i = 0 ; i < num_objects ; i++ )
	{
		//listing of all the hashes for all objects sorted by hash value
		object_mapping.insert(std::pair<unsigned int, object*>(*((unsigned int*)(bufptr)), objects+i ));
		(objects+i)->object_hash = *((unsigned int*)(bufptr)) ;
		(objects+i)->object_number = i ;
		bufptr += 4 ;
	}

	//0x31E5BC

	for ( int i = 0 ; i < num_objects ; i++ )
	{
		//???
		(objects+i)->unknown_word = ((*(bufptr))) + ((*(bufptr+1))) ;
		bufptr += 2 ;
	}

	// 0x355AAE

	if ( (bufptr-buf)%4 > 0 )
		bufptr += 2 ;  // 00 00  ??? - possibly pad to 4-byte boundary or just double-null terminator

	// 0x355AB0

	for ( int i = 0 ; i < unknown_count ; i++ )
	{
		unsigned int val = *((unsigned int*)(bufptr)) ;

		unknownobject *o = (unknownobject*)malloc( sizeof(UNKNOWNHASH) ) ;
		o->offset = bufptr - buf ;
		o->value = *((float*)(&val)) ;
		//unknowncount = 55d9

		unknownhash.insert(std::pair<unsigned int, unknownobject*>(*((unsigned int*)(bufptr+4)), o ));
		bufptr += 8 ;
	}

	bufptr = bufptr ;

	//0x00380978 beginning of labels structures

	//header
	bufptr += 4  ; 

	labelindexsize = *((unsigned int*)(bufptr)) ;
	bufptr += 4  ; 

	labelcount = *((unsigned int*)(bufptr)) ;
	bufptr += 4  ; 

	//0x380984

	for ( int i = 0  ; i < labelcount ; i++ )
	{
		labels.insert(std::pair<unsigned int, char*>(*((unsigned int*)(bufptr)), (char*)bufptr+4));
		stringlen = strlen((char*)bufptr+4) ;
		if ( stringlen > maxstrlen )
			maxstrlen = stringlen ;

		bufptr += 4 + stringlen + 1 ;
	}

	//bufptr += labelindexsize ;

	for ( int i = 0  ; i < labelcount ; i++ )
	{
		//offsets from start of dword+0-terminated strings
		offset = *((unsigned int*)(bufptr)) ;
		//printf( "%08.8X\r\n", offset ) ;
		bufptr += 4 ;
	}

	//0x46CFC3

	if ( doall )
	{
		objectptr = objects ;

		for ( int i = 0 ; i < num_objects ; i++ )
		{
			gdbtemplate *t = templates[(objectptr)->templatepointer] ;

			if ( t == NULL )
			{
				printf ("invalid template on object #d\r\n", i ) ;
			}

			printf( "O# %08.8X OH %08.8X TP %08.8X TO %08.8X UW %04.4X NO %02.2X\r\n", 
				endian32_swap(i), 
				endian32_swap(objectptr->object_hash), 
				endian32_swap(objectptr->templatepointer), 
				endian32_swap(objectptr->templatepointer_offset), 
				endian32_swap(objectptr->unknown_word), 
				t->no_components ) ;

			for ( int j = 0 ; j < t->num_parts ; j++ )
			{
				char *vlabel = labels[*(t->hashes+j)] ;
				char *nlabel ;

				if ( vlabel == NULL)
				{
					vlabel = "NULL" ;
				}

				if ( (t->dtypes+j)->datatype == 0x0004 )
				{
					nlabel = labels[*(objectptr->template_data+j)] ;

					if ( nlabel == NULL)
					{
						nlabel = "" ;
					}

					if (endian32_swap(*(objectptr->template_data+j)) == 0xC59D1C81 )
					{
						nlabel = "NULL" ;
					}


					printf( "  T# %08.8X HO %08.8X HV %08.8X DTO %08.8X DT %04.4X DO %08.8X D %08.8X %s | %s\r\n", 
						endian32_swap(j), 
						endian32_swap(*(t->hash_offsets+j)), 
						endian32_swap(*(t->hashes+j)), 
						endian32_swap(*(t->datatype_offsets+j)), 
						(t->dtypes+j)->datatype, 
						endian32_swap(*(objectptr->data_offsets+j)),
						endian32_swap(*(objectptr->template_data+j)), 
						vlabel, nlabel ) ;
				}
				/*
				else if ( (t->dtypes+j)->datatype == 0x0600 )
				{
				object *o = objects[*(objectptr->template_data+j)] ;
				if ( o != NULL )
				{
				nlabel = 
				}

				if ( nlabel == NULL)
				{
				nlabel = "NULL" ;
				}

				printf( "  Tpart %08.8X thash %08.8X dtype %04.4X ofs %08.8X objdata %08.8X %s | %s\r\n", 
				j, *(t->hashes+j), (t->dtypes+j)->datatype, *(objectptr->data_offsets+j),
				*(objectptr->template_data+j), vlabel, nlabel ) ;
				}*/
				else if ( ( (t->dtypes+j)->datatype == 0x0003 ) && ( dofloat ) )
				{
					unsigned int *p = objectptr->template_data+j ;
					float *f = (float*)(p) ;
					float ff = *f ;

					printf( "  T# %08.8X HO %08.8X HV %08.8X DTO %08.8X DT %04.4X DO %08.8X D %-14.3f %s\r\n", 
						endian32_swap(j), 
						endian32_swap(*(t->hash_offsets+j)), 
						endian32_swap(*(t->hashes+j)), 
						endian32_swap(*(t->datatype_offsets+j)), 
						(t->dtypes+j)->datatype, 
						endian32_swap(*(objectptr->data_offsets+j)),
						*((float*)(p)), 
						vlabel ) ;
				}
				else
				{
					printf( "  T# %08.8X HO %08.8X HV %08.8X DTO %08.8X DT %04.4X DO %08.8X D %08.8X %s\r\n", 
						endian32_swap(j), 
						endian32_swap(*(t->hash_offsets+j)), 
						endian32_swap(*(t->hashes+j)), 
						endian32_swap(*(t->datatype_offsets+j)), 
						(t->dtypes+j)->datatype, 
						endian32_swap(*(objectptr->data_offsets+j)),
						endian32_swap(*(objectptr->template_data+j)), 
						vlabel ) ;
				}
			}
			objectptr++ ;
		}
	}
	else if ( dolabels )
	{
		map_hashlabel::iterator it, itr, max;
		int i = labels.size();
		while ( i > 0 ) {
			itr = labels.begin(), max = labels.begin(), it = labels.begin();
			int j = labels.size();
			while ( j > 0 ) {
				if ( stricmp( itr->second, it->second) < 0 ) {
					max = itr;
					it = itr;
				}
				++itr;
				--j;
			}
			printf( "%08.8X %s\r\n", max->first, max->second ) ;
			labels.erase(max);
			--i;
		}

		/*
		map_hashlabel::iterator it = labels.begin(); 
		for (; it != labels.end(); ++it) 
		{
		printf( "%08.8X %s\r\n", it->first, it->second ) ;
		}
		*/
	}
	else if ( dounknown )
	{
		map_unknownhash::iterator it = unknownhash.begin() ;
		for (; it != unknownhash.end(); ++it) 
		{
			printf( "hash %08.8X offset %08.8X value %08.8X\r\n", it->first, it->second->offset, *((unsigned int*)(&it->second->value)) ) ;
		}

	}

	free(buf) ;

	return 0 ;

}

