
-- BeckAttackLeftRightCombo --
CombatSequences.BeckAttackLeftRightCombo = {}
CombatSequences.BeckAttackLeftRightCombo.Priority = SequencePriorities.Attack
CombatSequences.BeckAttackLeftRightCombo.IsCombo = true
CombatSequences.BeckAttackLeftRightCombo.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackLeftRightCombo.Zones = {}
CombatSequences.BeckAttackLeftRightCombo.Zones[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightCombo.Zones[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightCombo.ZonesWhilePlaying = {}
CombatSequences.BeckAttackLeftRightCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true
	}
}

-- BeckAttackLeftRightShotCombo --
CombatSequences.BeckAttackLeftRightShotCombo = {}
CombatSequences.BeckAttackLeftRightShotCombo.Priority = SequencePriorities.Attack
CombatSequences.BeckAttackLeftRightShotCombo.IsCombo = true
CombatSequences.BeckAttackLeftRightShotCombo.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackLeftRightShotCombo.Zones = {}
CombatSequences.BeckAttackLeftRightShotCombo.Zones[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightShotCombo.Zones[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightShotCombo.ZonesWhilePlaying = {}
CombatSequences.BeckAttackLeftRightShotCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightShotCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightShotCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckAttackLeftRightTwiceCombo --
CombatSequences.BeckAttackLeftRightTwiceCombo = {}
CombatSequences.BeckAttackLeftRightTwiceCombo.Priority = SequencePriorities.Attack
CombatSequences.BeckAttackLeftRightTwiceCombo.IsCombo = true
CombatSequences.BeckAttackLeftRightTwiceCombo.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackLeftRightTwiceCombo.Zones = {}
CombatSequences.BeckAttackLeftRightTwiceCombo.Zones[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightTwiceCombo.ZonesWhilePlaying = {}
CombatSequences.BeckAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightTwiceCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		FaceTargetAtStart = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	}
}

-- BeckSpin --
CombatSequences.BeckSpin = {}
CombatSequences.BeckSpin.Priority = SequencePriorities.Attack
CombatSequences.BeckSpin.IsCombo = true
CombatSequences.BeckSpin.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckSpin.Zones = {}
CombatSequences.BeckSpin.Zones[CombatZones.Near] = true
CombatSequences.BeckSpin.Zones[CombatZones.Middle] = true
CombatSequences.BeckSpin.ZonesWhilePlaying = {}
CombatSequences.BeckSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- BeckSpinAndQuickShot --
CombatSequences.BeckSpinAndQuickShot = {}
CombatSequences.BeckSpinAndQuickShot.Priority = SequencePriorities.Attack
CombatSequences.BeckSpinAndQuickShot.IsCombo = true
CombatSequences.BeckSpinAndQuickShot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckSpinAndQuickShot.Zones = {}
CombatSequences.BeckSpinAndQuickShot.Zones[CombatZones.Near] = true
CombatSequences.BeckSpinAndQuickShot.Zones[CombatZones.Middle] = true
CombatSequences.BeckSpinAndQuickShot.ZonesWhilePlaying = {}
CombatSequences.BeckSpinAndQuickShot.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckSpinAndQuickShot.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckSpinAndQuickShot.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckAttackLeftRightSpin --
CombatSequences.BeckAttackLeftRightSpin = {}
CombatSequences.BeckAttackLeftRightSpin.Priority = SequencePriorities.Attack
CombatSequences.BeckAttackLeftRightSpin.IsCombo = true
CombatSequences.BeckAttackLeftRightSpin.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackLeftRightSpin.Zones = {}
CombatSequences.BeckAttackLeftRightSpin.Zones[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightSpin.ZonesWhilePlaying = {}
CombatSequences.BeckAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckAttackLeftRightSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		PushBackStrike = 1.7,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckLowStabMid --
CombatSequences.BeckLowStabMid = {}
CombatSequences.BeckLowStabMid.IsValid = Predicate.OR(
	{
		Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_HOBBE),
		Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_WOLF)
	}
)
CombatSequences.BeckLowStabMid.Priority = SequencePriorities.Attack
CombatSequences.BeckLowStabMid.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckLowStabMid.Zones = {}
CombatSequences.BeckLowStabMid.Zones[CombatZones.Middle] = true
CombatSequences.BeckLowStabMid.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "LowFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	}
}

-- BeckStabMid --
CombatSequences.BeckStabMid = {}
CombatSequences.BeckStabMid.Priority = SequencePriorities.Attack
CombatSequences.BeckStabMid.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckStabMid.Zones = {}
CombatSequences.BeckStabMid.Zones[CombatZones.Middle] = true
CombatSequences.BeckStabMid.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	}
}

-- BeckLowStabMidAndShot --
CombatSequences.BeckLowStabMidAndShot = {}
CombatSequences.BeckLowStabMidAndShot.IsValid = Predicate.OR(
	{
		Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_HOBBE),
		Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_WOLF)
	}
)
CombatSequences.BeckLowStabMidAndShot.Priority = SequencePriorities.Attack
CombatSequences.BeckLowStabMidAndShot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckLowStabMidAndShot.Zones = {}
CombatSequences.BeckLowStabMidAndShot.Zones[CombatZones.Middle] = true
CombatSequences.BeckLowStabMidAndShot.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "LowFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckStabMidAndShot --
CombatSequences.BeckStabMidAndShot = {}
CombatSequences.BeckStabMidAndShot.Priority = SequencePriorities.Attack
CombatSequences.BeckStabMidAndShot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckStabMidAndShot.Zones = {}
CombatSequences.BeckStabMidAndShot.Zones[CombatZones.Middle] = true
CombatSequences.BeckStabMidAndShot.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckStabNear --
CombatSequences.BeckStabNear = {}
CombatSequences.BeckStabNear.Priority = SequencePriorities.Attack
CombatSequences.BeckStabNear.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckStabNear.Zones = {}
CombatSequences.BeckStabNear.Zones[CombatZones.Near] = true
CombatSequences.BeckStabNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- BeckFlourishLeftBackToIdle --
CombatSequences.BeckFlourishLeftBackToIdle = {}
CombatSequences.BeckFlourishLeftBackToIdle.Priority = SequencePriorities.Attack
CombatSequences.BeckFlourishLeftBackToIdle.IsCombo = true
CombatSequences.BeckFlourishLeftBackToIdle.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckFlourishLeftBackToIdle.Zones = {}
CombatSequences.BeckFlourishLeftBackToIdle.Zones[CombatZones.Near] = true
CombatSequences.BeckFlourishLeftBackToIdle.Zones[CombatZones.Middle] = true
CombatSequences.BeckFlourishLeftBackToIdle.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "ToCombatPoseFromStrikeLeft"
	}
}

-- WalterBeckAttackOutOfBlock --
CombatSequences.WalterBeckAttackOutOfBlock = {}
CombatSequences.WalterBeckAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.WalterBeckAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.WalterBeckAttackOutOfBlock.CounterAttack = true
CombatSequences.WalterBeckAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.WalterBeckAttackOutOfBlock.Zones = {}
CombatSequences.WalterBeckAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.WalterBeckAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.WalterBeckAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Counter",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "ToCombatPoseFromStrikeLeft"
	}
}

-- BeckPunch --
CombatSequences.BeckPunch = {}
CombatSequences.BeckPunch.Priority = SequencePriorities.Attack
CombatSequences.BeckPunch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckPunch.Zones = {}
CombatSequences.BeckPunch.Zones[CombatZones.Near] = true
CombatSequences.BeckPunch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Punch",
		PushBackStrike = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckPunchAndShot --
CombatSequences.BeckPunchAndShot = {}
CombatSequences.BeckPunchAndShot.Priority = SequencePriorities.Attack
CombatSequences.BeckPunchAndShot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckPunchAndShot.Zones = {}
CombatSequences.BeckPunchAndShot.Zones[CombatZones.Near] = true
CombatSequences.BeckPunchAndShot.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Punch",
		PushBackStrike = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckSpecialAttackSpinAround --
CombatSequences.BeckSpecialAttackSpinAround = {}
CombatSequences.BeckSpecialAttackSpinAround.IsValid = Predicate.IsSurrounded
CombatSequences.BeckSpecialAttackSpinAround.Priority = SequencePriorities.PreferredAttack
CombatSequences.BeckSpecialAttackSpinAround.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckSpecialAttackSpinAround.Zones = {}
CombatSequences.BeckSpecialAttackSpinAround.Zones[CombatZones.Near] = true
CombatSequences.BeckSpecialAttackSpinAround.Zones[CombatZones.Middle] = true
CombatSequences.BeckSpecialAttackSpinAround.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ClearanceAttack",
		IsKnockdown = true,
		Unblockable = true,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		OverrideLooking = true,
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		MinDistToTarget = 1.5
	}
}

-- BeckSpecialAttackShoulderCharge --
CombatSequences.BeckSpecialAttackShoulderCharge = {}
CombatSequences.BeckSpecialAttackShoulderCharge.Priority = SequencePriorities.Attack
CombatSequences.BeckSpecialAttackShoulderCharge.IsCombo = true
CombatSequences.BeckSpecialAttackShoulderCharge.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckSpecialAttackShoulderCharge.Zones = {}
CombatSequences.BeckSpecialAttackShoulderCharge.Zones[CombatZones.Near] = true
CombatSequences.BeckSpecialAttackShoulderCharge.Zones[CombatZones.Middle] = true
CombatSequences.BeckSpecialAttackShoulderCharge.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		OverrideLooking = true,
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		MinDistToTarget = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackInto",
		FaceTargetAtStart = true,
		Unblockable = true,
		PushBackStrike = 0.8
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackLoop",
		FaceTargetAtStart = true,
		Unblockable = true,
		PushBackStrike = 0.8
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackOutOf",
		FaceTargetAtStart = true,
		Unblockable = true,
		IsKnockdown = true
	}
}

-- BeckSpinAndShoot --
CombatSequences.BeckSpinAndShoot = {}
CombatSequences.BeckSpinAndShoot.Priority = SequencePriorities.Attack
CombatSequences.BeckSpinAndShoot.IsCombo = true
CombatSequences.BeckSpinAndShoot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckSpinAndShoot.Zones = {}
CombatSequences.BeckSpinAndShoot.Zones[CombatZones.Middle] = true
CombatSequences.BeckSpinAndShoot.ZonesWhilePlaying = {}
CombatSequences.BeckSpinAndShoot.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckSpinAndShoot.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinIntoKneeling",
		Unblockable = true,
		BlockBreaker = true,
		PushBackStrike = 1.7,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "KneelingToStand",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckDoubleShot --
CombatSequences.BeckDoubleShot = {}
CombatSequences.BeckDoubleShot.Priority = SequencePriorities.Attack
CombatSequences.BeckDoubleShot.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckDoubleShot.Zones = {}
CombatSequences.BeckDoubleShot.Zones[CombatZones.Middle] = true
CombatSequences.BeckDoubleShot.Zones[CombatZones.Far] = true
CombatSequences.BeckDoubleShot.Actions = {
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	}
}

-- BeckGoad --
CombatSequences.BeckGoad = {}
CombatSequences.BeckGoad.Priority = SequencePriorities.Idle
CombatSequences.BeckGoad.Zones = {}
CombatSequences.BeckGoad.Zones[CombatZones.Middle] = true
CombatSequences.BeckGoad.Zones[CombatZones.Far] = true
CombatSequences.BeckGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		OverrideLooking = true,
		SpeedMultiplier = 1
	}
}

-- BeckAttackWithTorch --
CombatSequences.BeckAttackWithTorch = {}
CombatSequences.BeckAttackWithTorch.Priority = SequencePriorities.PreferredAttack
CombatSequences.BeckAttackWithTorch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackWithTorch.Zones = {}
CombatSequences.BeckAttackWithTorch.Zones[CombatZones.Near] = true
CombatSequences.BeckAttackWithTorch.Zones[CombatZones.Middle] = true
CombatSequences.BeckAttackWithTorch.Zones[CombatZones.Far] = true
CombatSequences.BeckAttackWithTorch.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TorchStrike",
		Unblockable = true,
		HitOutsideAttackArc = true
	}
}

-- BeckStrafeLeft --
CombatSequences.BeckStrafeLeft = {}
CombatSequences.BeckStrafeLeft.Priority = SequencePriorities.PreferredAttack
CombatSequences.BeckStrafeLeft.Zones = {}
CombatSequences.BeckStrafeLeft.Zones[CombatZones.Near] = true
CombatSequences.BeckStrafeLeft.Zones[CombatZones.Middle] = true
CombatSequences.BeckStrafeLeft.Zones[CombatZones.Far] = true
CombatSequences.BeckStrafeLeft.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatStrafeLeft",
		SpeedMultiplier = 1
	}
}

-- BeckStrafeRight --
CombatSequences.BeckStrafeRight = {}
CombatSequences.BeckStrafeRight.Priority = SequencePriorities.PreferredAttack
CombatSequences.BeckStrafeRight.Zones = {}
CombatSequences.BeckStrafeRight.Zones[CombatZones.Near] = true
CombatSequences.BeckStrafeRight.Zones[CombatZones.Middle] = true
CombatSequences.BeckStrafeRight.Zones[CombatZones.Far] = true
CombatSequences.BeckStrafeRight.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatStrafeRight",
		SpeedMultiplier = 1
	}
}

-- BeckStrafeForwards --
CombatSequences.BeckStrafeForwards = {}
CombatSequences.BeckStrafeForwards.Priority = SequencePriorities.Attack
CombatSequences.BeckStrafeForwards.Zones = {}
CombatSequences.BeckStrafeForwards.Zones[CombatZones.Near] = true
CombatSequences.BeckStrafeForwards.Zones[CombatZones.Middle] = true
CombatSequences.BeckStrafeForwards.Zones[CombatZones.Far] = true
CombatSequences.BeckStrafeForwards.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatStrafeForwards",
		SpeedMultiplier = 1
	}
}

-- BeckStrafeBackwards --
CombatSequences.BeckStrafeBackwards = {}
CombatSequences.BeckStrafeBackwards.Priority = SequencePriorities.Attack
CombatSequences.BeckStrafeBackwards.Zones = {}
CombatSequences.BeckStrafeBackwards.Zones[CombatZones.Near] = true
CombatSequences.BeckStrafeBackwards.Zones[CombatZones.Middle] = true
CombatSequences.BeckStrafeBackwards.Zones[CombatZones.Far] = true
CombatSequences.BeckStrafeBackwards.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatStrafeBackwards",
		SpeedMultiplier = 1
	}
}

-- BeckEncourage --
CombatSequences.BeckEncourage = {}
CombatSequences.BeckEncourage.Priority = SequencePriorities.Attack
CombatSequences.BeckEncourage.Zones = {}
CombatSequences.BeckEncourage.Zones[CombatZones.Near] = true
CombatSequences.BeckEncourage.Zones[CombatZones.Middle] = true
CombatSequences.BeckEncourage.Zones[CombatZones.Far] = true
CombatSequences.BeckEncourage.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Encourage",
		SpeedMultiplier = 1
	}
}

-- BeckOpeningAttackLeftRightSpin --
CombatSequences.BeckOpeningAttackLeftRightSpin = {}
CombatSequences.BeckOpeningAttackLeftRightSpin.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningAttackLeftRightSpin.IsCombo = true
CombatSequences.BeckOpeningAttackLeftRightSpin.Zones = {}
CombatSequences.BeckOpeningAttackLeftRightSpin.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightSpin.Zones[CombatZones.Far] = true
CombatSequences.BeckOpeningAttackLeftRightSpin.ZonesWhilePlaying = {}
CombatSequences.BeckOpeningAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckOpeningAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BeckOpeningAttackLeftRightSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		PushBackStrike = 1.7
	}
}

-- BeckOpeningAttackLeftRightCombo --
CombatSequences.BeckOpeningAttackLeftRightCombo = {}
CombatSequences.BeckOpeningAttackLeftRightCombo.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningAttackLeftRightCombo.IsCombo = true
CombatSequences.BeckOpeningAttackLeftRightCombo.Zones = {}
CombatSequences.BeckOpeningAttackLeftRightCombo.Zones[CombatZones.Near] = true
CombatSequences.BeckOpeningAttackLeftRightCombo.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightCombo.ZonesWhilePlaying = {}
CombatSequences.BeckOpeningAttackLeftRightCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckOpeningAttackLeftRightCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true
	}
}

-- BeckOpeningStabNear --
CombatSequences.BeckOpeningStabNear = {}
CombatSequences.BeckOpeningStabNear.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningStabNear.Zones = {}
CombatSequences.BeckOpeningStabNear.Zones[CombatZones.Near] = true
CombatSequences.BeckOpeningStabNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- BeckOpeningSpin --
CombatSequences.BeckOpeningSpin = {}
CombatSequences.BeckOpeningSpin.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningSpin.IsCombo = true
CombatSequences.BeckOpeningSpin.Zones = {}
CombatSequences.BeckOpeningSpin.Zones[CombatZones.Near] = true
CombatSequences.BeckOpeningSpin.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningSpin.ZonesWhilePlaying = {}
CombatSequences.BeckOpeningSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckOpeningSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckOpeningSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- BeckOpeningStabMid --
CombatSequences.BeckOpeningStabMid = {}
CombatSequences.BeckOpeningStabMid.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningStabMid.Zones = {}
CombatSequences.BeckOpeningStabMid.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningStabMid.Zones[CombatZones.Far] = true
CombatSequences.BeckOpeningStabMid.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	}
}

-- BeckOpeningAttackLeftRightTwiceCombo --
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo = {}
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.IsCombo = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.Zones = {}
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.Zones[CombatZones.Far] = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.ZonesWhilePlaying = {}
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BeckOpeningAttackLeftRightTwiceCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	}
}

-- BeckOpeningFlourishLeftBackToIdle --
CombatSequences.BeckOpeningFlourishLeftBackToIdle = {}
CombatSequences.BeckOpeningFlourishLeftBackToIdle.Priority = SequencePriorities.Attack
CombatSequences.BeckOpeningFlourishLeftBackToIdle.IsCombo = true
CombatSequences.BeckOpeningFlourishLeftBackToIdle.Zones = {}
CombatSequences.BeckOpeningFlourishLeftBackToIdle.Zones[CombatZones.Near] = true
CombatSequences.BeckOpeningFlourishLeftBackToIdle.Zones[CombatZones.Middle] = true
CombatSequences.BeckOpeningFlourishLeftBackToIdle.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "ToCombatPoseFromStrikeLeft"
	}
}

-- ShadowBeckSpecialAttackShoulderCharge --
CombatSequences.ShadowBeckSpecialAttackShoulderCharge = {}
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.IsCombo = true
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.Zones = {}
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.ZonesWhilePlaying = {}
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.ShadowBeckSpecialAttackShoulderCharge.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		OverrideLooking = true,
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		MinDistToTarget = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackInto",
		FaceTargetAtStart = true,
		Unblockable = true,
		PushBackStrike = 0.8
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackLoop",
		FaceTargetAtStart = true,
		Unblockable = true,
		PushBackStrike = 0.8
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackOutOf",
		FaceTargetAtStart = true,
		Unblockable = true,
		PushBackStrike = 1.5
	}
}

-- ShadowBeckAttackLeftRightSpin --
CombatSequences.ShadowBeckAttackLeftRightSpin = {}
CombatSequences.ShadowBeckAttackLeftRightSpin.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckAttackLeftRightSpin.IsCombo = true
CombatSequences.ShadowBeckAttackLeftRightSpin.Zones = {}
CombatSequences.ShadowBeckAttackLeftRightSpin.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckAttackLeftRightSpin.ZonesWhilePlaying = {}
CombatSequences.ShadowBeckAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.ShadowBeckAttackLeftRightSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.ShadowBeckAttackLeftRightSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		PushBackStrike = 1.7,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- ShadowBeckSpin --
CombatSequences.ShadowBeckSpin = {}
CombatSequences.ShadowBeckSpin.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckSpin.IsCombo = true
CombatSequences.ShadowBeckSpin.Zones = {}
CombatSequences.ShadowBeckSpin.Zones[CombatZones.Near] = true
CombatSequences.ShadowBeckSpin.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckSpin.ZonesWhilePlaying = {}
CombatSequences.ShadowBeckSpin.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.ShadowBeckSpin.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.ShadowBeckSpin.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- ShadowBeckStabNear --
CombatSequences.ShadowBeckStabNear = {}
CombatSequences.ShadowBeckStabNear.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckStabNear.Zones = {}
CombatSequences.ShadowBeckStabNear.Zones[CombatZones.Near] = true
CombatSequences.ShadowBeckStabNear.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckStabNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CloseFrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- ShadowBeckStabMid --
CombatSequences.ShadowBeckStabMid = {}
CombatSequences.ShadowBeckStabMid.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckStabMid.Zones = {}
CombatSequences.ShadowBeckStabMid.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckStabMid.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		OverrideLooking = true
	}
}

-- ShadowBeckSpecialAttackSpinAround --
CombatSequences.ShadowBeckSpecialAttackSpinAround = {}
CombatSequences.ShadowBeckSpecialAttackSpinAround.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowBeckSpecialAttackSpinAround.Zones = {}
CombatSequences.ShadowBeckSpecialAttackSpinAround.Zones[CombatZones.Near] = true
CombatSequences.ShadowBeckSpecialAttackSpinAround.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckSpecialAttackSpinAround.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ClearanceAttack",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		OverrideLooking = true,
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		MinDistToTarget = 1.5
	}
}

-- ShadowBeckAttackLeftRightTwiceCombo --
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo = {}
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.Priority = SequencePriorities.Attack
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.IsCombo = true
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.Zones = {}
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.Zones[CombatZones.Middle] = true
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.ZonesWhilePlaying = {}
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.ShadowBeckAttackLeftRightTwiceCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.3,
		FaceTargetAtStart = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTargetAtStart = true,
		IsComboBreak = true
	}
}

-- ShadowWalterBeckAttackOutOfBlock --
CombatSequences.ShadowWalterBeckAttackOutOfBlock = {}
CombatSequences.ShadowWalterBeckAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.ShadowWalterBeckAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.ShadowWalterBeckAttackOutOfBlock.CounterAttack = true
CombatSequences.ShadowWalterBeckAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterBeckAttackOutOfBlock.Zones = {}
CombatSequences.ShadowWalterBeckAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.ShadowWalterBeckAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterBeckAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Counter",
		PushBackStrike = 2.5,
		SpeedMultiplier = 1.75,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "ToCombatPoseFromStrikeLeft",
		SpeedMultiplier = 2
	}
}

-- ShadowWalterAntiSpamKickAttack --
CombatSequences.ShadowWalterAntiSpamKickAttack = {}
CombatSequences.ShadowWalterAntiSpamKickAttack.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(3),
		Predicate.TargetIsFurtherAwayThan(4)
	}
)
CombatSequences.ShadowWalterAntiSpamKickAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterAntiSpamKickAttack.CounterAttack = true
CombatSequences.ShadowWalterAntiSpamKickAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterAntiSpamKickAttack.Zones = {}
CombatSequences.ShadowWalterAntiSpamKickAttack.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterAntiSpamKickAttack.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterAntiSpamKickAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "LowHealthInto",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "LowHealthOutOf",
		SpeedMultiplier = 1.7
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Kick",
		SpeedMultiplier = 1.2,
		PushBackStrike = 2
	}
}

-- ShadowWalterAntiSpamPunchAttack --
CombatSequences.ShadowWalterAntiSpamPunchAttack = {}
CombatSequences.ShadowWalterAntiSpamPunchAttack.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(3),
		Predicate.TargetIsFurtherAwayThan(4)
	}
)
CombatSequences.ShadowWalterAntiSpamPunchAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterAntiSpamPunchAttack.CounterAttack = true
CombatSequences.ShadowWalterAntiSpamPunchAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterAntiSpamPunchAttack.Zones = {}
CombatSequences.ShadowWalterAntiSpamPunchAttack.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterAntiSpamPunchAttack.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterAntiSpamPunchAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "LowHealthInto",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "LowHealthOutOf",
		SpeedMultiplier = 1.7
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Punch",
		SpeedMultiplier = 1.2,
		PushBackStrike = 2
	}
}

-- ShadowWalterAntiSpamClearanceAttack --
CombatSequences.ShadowWalterAntiSpamClearanceAttack = {}
CombatSequences.ShadowWalterAntiSpamClearanceAttack.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.ShadowWalterAntiSpamClearanceAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterAntiSpamClearanceAttack.CounterAttack = true
CombatSequences.ShadowWalterAntiSpamClearanceAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterAntiSpamClearanceAttack.Zones = {}
CombatSequences.ShadowWalterAntiSpamClearanceAttack.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterAntiSpamClearanceAttack.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterAntiSpamClearanceAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "LowHealthInto",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "LowHealthOutOf",
		SpeedMultiplier = 1.7
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Punch",
		SpeedMultiplier = 1.2,
		PushBackStrike = 2
	}
}

-- ShadowWalterAntiSpamCloseStabAttack --
CombatSequences.ShadowWalterAntiSpamCloseStabAttack = {}
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.CounterAttack = true
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.Zones = {}
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterAntiSpamCloseStabAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "LowHealthInto",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "LowHealthOutOf",
		SpeedMultiplier = 1.7
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Punch",
		SpeedMultiplier = 1.2,
		PushBackStrike = 2
	}
}

-- ShadowWalterAntiSpamQuickShotTeleport --
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport = {}
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(4)
	}
)
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.CounterAttack = true
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.Zones = {}
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterAntiSpamQuickShotTeleport.Actions = {
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ClearanceAttack",
		SpeedMultiplier = 1.2,
		PushBackStrike = 2
	}
}

-- ShadowWalterShotTooMuch --
CombatSequences.ShadowWalterShotTooMuch = {}
CombatSequences.ShadowWalterShotTooMuch.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(4)
	}
)
CombatSequences.ShadowWalterShotTooMuch.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShadowWalterShotTooMuch.CounterAttack = true
CombatSequences.ShadowWalterShotTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ShadowWalterShotTooMuch.Zones = {}
CombatSequences.ShadowWalterShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.ShadowWalterShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterShotTooMuch.Actions = {
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	}
}

-- ShadowWalterMagicedTooMuch --
CombatSequences.ShadowWalterMagicedTooMuch = {}
CombatSequences.ShadowWalterMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(2, EAttackType.ATTACK_SPELL, 6)
CombatSequences.ShadowWalterMagicedTooMuch.Priority = SequencePriorities.Attack
CombatSequences.ShadowWalterMagicedTooMuch.CounterAttack = true
CombatSequences.ShadowWalterMagicedTooMuch.Zones = {}
CombatSequences.ShadowWalterMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.ShadowWalterMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.ShadowWalterMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.ShadowWalterMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.SHOOT,
		Anim = "QuickShot",
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	}
}

-- FinnSpecial --
CombatSequences.FinnSpecial = {}
CombatSequences.FinnSpecial.Priority = SequencePriorities.Attack
CombatSequences.FinnSpecial.IsCombo = true
CombatSequences.FinnSpecial.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.FinnSpecial.Zones = {}
CombatSequences.FinnSpecial.Zones[CombatZones.Near] = true
CombatSequences.FinnSpecial.Zones[CombatZones.Middle] = true
CombatSequences.FinnSpecial.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpecialStrike",
		SpeedMultiplier = 1.3,
		IsKnockdown = true,
		FaceTargetAtStart = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- FinnBackAttack --
CombatSequences.FinnBackAttack = {}
CombatSequences.FinnBackAttack.Priority = SequencePriorities.Attack
CombatSequences.FinnBackAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.FinnBackAttack.Zones = {}
CombatSequences.FinnBackAttack.Zones[CombatZones.Rear] = true
CombatSequences.FinnBackAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "BackStrike",
		FaceTargetAtStart = true,
		HitOutsideAttackArc = true
	}
}

-- Finn4AttackCombo --
CombatSequences.Finn4AttackCombo = {}
CombatSequences.Finn4AttackCombo.Priority = SequencePriorities.Attack
CombatSequences.Finn4AttackCombo.IsCombo = true
CombatSequences.Finn4AttackCombo.Zones = {}
CombatSequences.Finn4AttackCombo.Zones[CombatZones.Near] = true
CombatSequences.Finn4AttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.Finn4AttackCombo.ZonesWhilePlaying = {}
CombatSequences.Finn4AttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.Finn4AttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.Finn4AttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 0.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 1
	}
}

-- FinnAttackOutOfBlock --
CombatSequences.FinnAttackOutOfBlock = {}
CombatSequences.FinnAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.FinnAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.FinnAttackOutOfBlock.CounterAttack = true
CombatSequences.FinnAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.FinnAttackOutOfBlock.Zones = {}
CombatSequences.FinnAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.FinnAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.FinnAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CounterStrike",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	}
}

-- BeckKick --
CombatSequences.BeckKick = {}
CombatSequences.BeckKick.Priority = SequencePriorities.Attack
CombatSequences.BeckKick.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckKick.Zones = {}
CombatSequences.BeckKick.Zones[CombatZones.Near] = true
CombatSequences.BeckKick.Zones[CombatZones.Middle] = true
CombatSequences.BeckKick.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Kick",
		PushBackStrike = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BeckAttackLeftRightRear --
CombatSequences.BeckAttackLeftRightRear = {}
CombatSequences.BeckAttackLeftRightRear.Priority = SequencePriorities.Attack
CombatSequences.BeckAttackLeftRightRear.IsCombo = true
CombatSequences.BeckAttackLeftRightRear.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckAttackLeftRightRear.Zones = {}
CombatSequences.BeckAttackLeftRightRear.Zones[CombatZones.Rear] = true
CombatSequences.BeckAttackLeftRightRear.Zones[CombatZones.Left] = true
CombatSequences.BeckAttackLeftRightRear.Zones[CombatZones.Right] = true
CombatSequences.BeckAttackLeftRightRear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ClearanceAttack",
		IsKnockdown = true,
		Unblockable = true,
		HitOutsideAttackArc = true
	}
}

-- BeckStabFar --
CombatSequences.BeckStabFar = {}
CombatSequences.BeckStabFar.Priority = SequencePriorities.Attack
CombatSequences.BeckStabFar.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BeckStabFar.Zones = {}
CombatSequences.BeckStabFar.Zones[CombatZones.Far] = true
CombatSequences.BeckStabFar.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FrontStab",
		SpeedMultiplier = 1.5,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- ShadowSpellChargeResponse --
CombatSequences.ShadowSpellChargeResponse = {}
CombatSequences.ShadowSpellChargeResponse.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(0)
CombatSequences.ShadowSpellChargeResponse.Priority = SequencePriorities.Attack
CombatSequences.ShadowSpellChargeResponse.Zones = {}
CombatSequences.ShadowSpellChargeResponse.Zones[CombatZones.Near] = true
CombatSequences.ShadowSpellChargeResponse.Zones[CombatZones.Middle] = true
CombatSequences.ShadowSpellChargeResponse.Zones[CombatZones.Far] = true
CombatSequences.ShadowSpellChargeResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatStrafeBackwards",
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellResponse",
		SpeedMultiplier = 1
	}
}

-- HollowWolfCloseCast --
CombatSequences.HollowWolfCloseCast = {}
CombatSequences.HollowWolfCloseCast.IsValid = Predicate.TargetIsCloserThan(3)
CombatSequences.HollowWolfCloseCast.Priority = SequencePriorities.Attack
CombatSequences.HollowWolfCloseCast.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HollowWolfCloseCast.Zones = {}
CombatSequences.HollowWolfCloseCast.Zones[CombatZones.Near] = true
CombatSequences.HollowWolfCloseCast.Zones[CombatZones.Middle] = true
CombatSequences.HollowWolfCloseCast.Zones[CombatZones.Rear] = true
CombatSequences.HollowWolfCloseCast.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_CHARGE,
		Anim = "HollowWolfAreaCast",
		SecondsToCharge = 0.5,
		SpellType = ESpellType.SPELL_LIGHTNING,
		Dummy = "Character.Carry.Mouth",
		ParticleScale = 0.75,
		ParticleAlpha = 1,
		StartParticle = true,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_MELEE_STRIKE,
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "HollowWolfAreaCast",
		SpeedMultiplier = 1.3,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		Dummy = "Character.Carry.Mouth",
		PowerLevel = 0,
		StopParticle = true,
		Priority = EActionPriority.PRIORITY_COMBAT_MELEE_STRIKE
	}
}

-- HollowWolfFarCast --
CombatSequences.HollowWolfFarCast = {}
CombatSequences.HollowWolfFarCast.IsValid = Predicate.TargetIsFurtherAwayThan(3)
CombatSequences.HollowWolfFarCast.Priority = SequencePriorities.Attack
CombatSequences.HollowWolfFarCast.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HollowWolfFarCast.Zones = {}
CombatSequences.HollowWolfFarCast.Zones[CombatZones.Far] = true
CombatSequences.HollowWolfFarCast.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_CHARGE,
		Anim = "HollowWolfAreaCast",
		SecondsToCharge = 0.5,
		SpellType = ESpellType.SPELL_LIGHTNING,
		Dummy = "Character.Carry.Mouth",
		ParticleScale = 0.75,
		ParticleAlpha = 1,
		StartParticle = true,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_MELEE_STRIKE,
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "HollowWolfAreaCast",
		SpeedMultiplier = 1.3,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Mouth",
		PowerLevel = 0,
		StopParticle = true,
		Priority = EActionPriority.PRIORITY_COMBAT_MELEE_STRIKE,
		FaceTargetThroughout = true
	}
}

-- DLC2InventorLeftAttack --
CombatSequences.DLC2InventorLeftAttack = {}
CombatSequences.DLC2InventorLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorLeftAttack.Zones = {}
CombatSequences.DLC2InventorLeftAttack.Zones[CombatZones.Near] = true
CombatSequences.DLC2InventorLeftAttack.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1
	}
}

-- DLC2InventorRightAttack --
CombatSequences.DLC2InventorRightAttack = {}
CombatSequences.DLC2InventorRightAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorRightAttack.Zones = {}
CombatSequences.DLC2InventorRightAttack.Zones[CombatZones.Near] = true
CombatSequences.DLC2InventorRightAttack.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- DLC2InventorRightLeftCombo --
CombatSequences.DLC2InventorRightLeftCombo = {}
CombatSequences.DLC2InventorRightLeftCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorRightLeftCombo.Zones = {}
CombatSequences.DLC2InventorRightLeftCombo.Zones[CombatZones.Near] = true
CombatSequences.DLC2InventorRightLeftCombo.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorRightLeftCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2
	}
}

-- DLC2InventorSpellLightningAttack --
CombatSequences.DLC2InventorSpellLightningAttack = {}
CombatSequences.DLC2InventorSpellLightningAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorSpellLightningAttack.Zones = {}
CombatSequences.DLC2InventorSpellLightningAttack.Zones[CombatZones.Far] = true
CombatSequences.DLC2InventorSpellLightningAttack.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorSpellLightningAttack.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackInto"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackOutOf"
	}
}

-- DLC2InventorSpellFireballAttack --
CombatSequences.DLC2InventorSpellFireballAttack = {}
CombatSequences.DLC2InventorSpellFireballAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorSpellFireballAttack.Zones = {}
CombatSequences.DLC2InventorSpellFireballAttack.Zones[CombatZones.Far] = true
CombatSequences.DLC2InventorSpellFireballAttack.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorSpellFireballAttack.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackInto"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackOutOf"
	}
}

-- DLC2InventorSpellFireballLightningJumpResponse --
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse = {}
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.IsValid = Predicate.HasInventorJustJumped
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.CounterAttack = true
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.Zones = {}
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.Zones[CombatZones.Far] = true
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorSpellFireballLightningJumpResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackInto",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackOutOf",
		SpeedMultiplier = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2InventorSpellFireballLightningResponse --
CombatSequences.DLC2InventorSpellFireballLightningResponse = {}
CombatSequences.DLC2InventorSpellFireballLightningResponse.IsValid = Predicate.OR(
	{
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5),
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
	}
)
CombatSequences.DLC2InventorSpellFireballLightningResponse.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorSpellFireballLightningResponse.CounterAttack = true
CombatSequences.DLC2InventorSpellFireballLightningResponse.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2InventorSpellFireballLightningResponse.Zones = {}
CombatSequences.DLC2InventorSpellFireballLightningResponse.Zones[CombatZones.Far] = true
CombatSequences.DLC2InventorSpellFireballLightningResponse.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorSpellFireballLightningResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackInto",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackLeft",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Right",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RangedAttackRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "RangedAttackOutOf",
		SpeedMultiplier = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2InventorJumpAttack --
CombatSequences.DLC2InventorJumpAttack = {}
CombatSequences.DLC2InventorJumpAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorJumpAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2InventorJumpAttack.Zones = {}
CombatSequences.DLC2InventorJumpAttack.Zones[CombatZones.Near] = true
CombatSequences.DLC2InventorJumpAttack.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorJumpAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AreaAttack",
		HasPound = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2InventorBackAttack --
CombatSequences.DLC2InventorBackAttack = {}
CombatSequences.DLC2InventorBackAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorBackAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2InventorBackAttack.Zones = {}
CombatSequences.DLC2InventorBackAttack.Zones[CombatZones.Rear] = true
CombatSequences.DLC2InventorBackAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AreaAttack",
		HasPound = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2InventorOutOfBlock --
CombatSequences.DLC2InventorOutOfBlock = {}
CombatSequences.DLC2InventorOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2InventorOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.DLC2InventorOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2InventorOutOfBlock.CounterAttack = true
CombatSequences.DLC2InventorOutOfBlock.Zones = {}
CombatSequences.DLC2InventorOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.DLC2InventorOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.DLC2InventorOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AreaAttack",
		HasPound = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossShotTooMuch --
CombatSequences.DLC2BossShotTooMuch = {}
CombatSequences.DLC2BossShotTooMuch.IsValid = Predicate.OR(
	{
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5),
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
	}
)
CombatSequences.DLC2BossShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossShotTooMuch.CounterAttack = true
CombatSequences.DLC2BossShotTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossShotTooMuch.Zones = {}
CombatSequences.DLC2BossShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.DLC2BossShotTooMuch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- DLC2BossBackSpellCast --
CombatSequences.DLC2BossBackSpellCast = {}
CombatSequences.DLC2BossBackSpellCast.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossBackSpellCast.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossBackSpellCast.CounterAttack = true
CombatSequences.DLC2BossBackSpellCast.Zones = {}
CombatSequences.DLC2BossBackSpellCast.Zones[CombatZones.Rear] = true
CombatSequences.DLC2BossBackSpellCast.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastArea",
		SpeedMultiplier = 1,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SecondSpellType = ESpellType.FORCE_PUSSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		Dummy = "Character.Focal.Chest",
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	}
}

-- DLC2BossBackSwordAttack --
CombatSequences.DLC2BossBackSwordAttack = {}
CombatSequences.DLC2BossBackSwordAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossBackSwordAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossBackSwordAttack.CounterAttack = true
CombatSequences.DLC2BossBackSwordAttack.Zones = {}
CombatSequences.DLC2BossBackSwordAttack.Zones[CombatZones.Rear] = true
CombatSequences.DLC2BossBackSwordAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "BackAttack",
		SpeedMultiplier = 1.2,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossBackSpellCastTargeted --
CombatSequences.DLC2BossBackSpellCastTargeted = {}
CombatSequences.DLC2BossBackSpellCastTargeted.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossBackSpellCastTargeted.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossBackSpellCastTargeted.CounterAttack = true
CombatSequences.DLC2BossBackSpellCastTargeted.Zones = {}
CombatSequences.DLC2BossBackSpellCastTargeted.Zones[CombatZones.Rear] = true
CombatSequences.DLC2BossBackSpellCastTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastBack",
		SpeedMultiplier = 1,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.FORCE_PUSSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	}
}

-- DLC2BossLeftSpellCastTargeted --
CombatSequences.DLC2BossLeftSpellCastTargeted = {}
CombatSequences.DLC2BossLeftSpellCastTargeted.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossLeftSpellCastTargeted.Zones = {}
CombatSequences.DLC2BossLeftSpellCastTargeted.Zones[CombatZones.Left] = true
CombatSequences.DLC2BossLeftSpellCastTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastLeft",
		SpeedMultiplier = 1,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.FORCE_PUSSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	}
}

-- DLC2BossRightSpellCastTargeted --
CombatSequences.DLC2BossRightSpellCastTargeted = {}
CombatSequences.DLC2BossRightSpellCastTargeted.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossRightSpellCastTargeted.Zones = {}
CombatSequences.DLC2BossRightSpellCastTargeted.Zones[CombatZones.Right] = true
CombatSequences.DLC2BossRightSpellCastTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastRight",
		SpeedMultiplier = 1,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.FORCE_PUSSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	}
}

-- DLC2BossSpellCast --
CombatSequences.DLC2BossSpellCast = {}
CombatSequences.DLC2BossSpellCast.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossSpellCast.Zones = {}
CombatSequences.DLC2BossSpellCast.Zones[CombatZones.Far] = true
CombatSequences.DLC2BossSpellCast.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Mouth"
	}
}

-- DLC2BossCloseSpellCast --
CombatSequences.DLC2BossCloseSpellCast = {}
CombatSequences.DLC2BossCloseSpellCast.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossCloseSpellCast.Zones = {}
CombatSequences.DLC2BossCloseSpellCast.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossCloseSpellCast.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossCloseSpellCast.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeBack"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_ICE_STORM,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 0,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- DLC2BossCloseInCombo --
CombatSequences.DLC2BossCloseInCombo = {}
CombatSequences.DLC2BossCloseInCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossCloseInCombo.IsCombo = true
CombatSequences.DLC2BossCloseInCombo.Zones = {}
CombatSequences.DLC2BossCloseInCombo.Zones[CombatZones.Far] = true
CombatSequences.DLC2BossCloseInCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2BossCloseInCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.DLC2BossCloseInCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2BossCloseInCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossCloseInCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollForwards",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeBack",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- DLC2BossCloseInComboNoMagic --
CombatSequences.DLC2BossCloseInComboNoMagic = {}
CombatSequences.DLC2BossCloseInComboNoMagic.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossCloseInComboNoMagic.IsCombo = true
CombatSequences.DLC2BossCloseInComboNoMagic.Zones = {}
CombatSequences.DLC2BossCloseInComboNoMagic.Zones[CombatZones.Far] = true
CombatSequences.DLC2BossCloseInComboNoMagic.ZonesWhilePlaying = {}
CombatSequences.DLC2BossCloseInComboNoMagic.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.DLC2BossCloseInComboNoMagic.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2BossCloseInComboNoMagic.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossCloseInComboNoMagic.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollForwards",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- DLC2BossCombo --
CombatSequences.DLC2BossCombo = {}
CombatSequences.DLC2BossCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossCombo.IsCombo = true
CombatSequences.DLC2BossCombo.Zones = {}
CombatSequences.DLC2BossCombo.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2BossCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2BossCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- DLC2BossCloseCombo --
CombatSequences.DLC2BossCloseCombo = {}
CombatSequences.DLC2BossCloseCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossCloseCombo.IsCombo = true
CombatSequences.DLC2BossCloseCombo.Zones = {}
CombatSequences.DLC2BossCloseCombo.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossCloseCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2BossCloseCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossCloseCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- DLC2BossStrikeRightRollCombo --
CombatSequences.DLC2BossStrikeRightRollCombo = {}
CombatSequences.DLC2BossStrikeRightRollCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossStrikeRightRollCombo.IsCombo = true
CombatSequences.DLC2BossStrikeRightRollCombo.Zones = {}
CombatSequences.DLC2BossStrikeRightRollCombo.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossStrikeRightRollCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2BossStrikeRightRollCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2BossStrikeRightRollCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossStrikeRightRollCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeBack",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- DLC2BossStrikeLeftRollCombo --
CombatSequences.DLC2BossStrikeLeftRollCombo = {}
CombatSequences.DLC2BossStrikeLeftRollCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossStrikeLeftRollCombo.IsCombo = true
CombatSequences.DLC2BossStrikeLeftRollCombo.Zones = {}
CombatSequences.DLC2BossStrikeLeftRollCombo.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossStrikeLeftRollCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2BossStrikeLeftRollCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2BossStrikeLeftRollCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2BossStrikeLeftRollCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeBack",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTargetAtStart = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- DLC2BossFlourish --
CombatSequences.DLC2BossFlourish = {}
CombatSequences.DLC2BossFlourish.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossFlourish.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossFlourish.Zones = {}
CombatSequences.DLC2BossFlourish.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossFlourish.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "FlourishWindUp",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "FlourishLoop",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishStrike",
		PushBackStrike = 1.5,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossFlourishRF --
CombatSequences.DLC2BossFlourishRF = {}
CombatSequences.DLC2BossFlourishRF.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossFlourishRF.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossFlourishRF.Zones = {}
CombatSequences.DLC2BossFlourishRF.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossFlourishRF.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeRight",
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "FlourishWindUpRF",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "FlourishLoopRF",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishStrikeRF",
		PushBackStrike = 1.5,
		FaceTargetThroughout = true,
		SpeedMultiplier = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossFlourishOutOfBlock --
CombatSequences.DLC2BossFlourishOutOfBlock = {}
CombatSequences.DLC2BossFlourishOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2BossFlourishOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossFlourishOutOfBlock.CounterAttack = true
CombatSequences.DLC2BossFlourishOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossFlourishOutOfBlock.Zones = {}
CombatSequences.DLC2BossFlourishOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossFlourishOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishStrike",
		SpeedMultiplier = 1.5,
		PushBackStrike = 3,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossFlourishOutOfBlockRF --
CombatSequences.DLC2BossFlourishOutOfBlockRF = {}
CombatSequences.DLC2BossFlourishOutOfBlockRF.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2BossFlourishOutOfBlockRF.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossFlourishOutOfBlockRF.CounterAttack = true
CombatSequences.DLC2BossFlourishOutOfBlockRF.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossFlourishOutOfBlockRF.Zones = {}
CombatSequences.DLC2BossFlourishOutOfBlockRF.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossFlourishOutOfBlockRF.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishStrikeRF",
		SpeedMultiplier = 1.5,
		PushBackStrike = 3,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossSpellCastOutOfBlock --
CombatSequences.DLC2BossSpellCastOutOfBlock = {}
CombatSequences.DLC2BossSpellCastOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2BossSpellCastOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossSpellCastOutOfBlock.CounterAttack = true
CombatSequences.DLC2BossSpellCastOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossSpellCastOutOfBlock.Zones = {}
CombatSequences.DLC2BossSpellCastOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossSpellCastOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossSpellCastOutOfBlock.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeLeft",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1.2,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossSpellCastOutOfBlockRF --
CombatSequences.DLC2BossSpellCastOutOfBlockRF = {}
CombatSequences.DLC2BossSpellCastOutOfBlockRF.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2BossSpellCastOutOfBlockRF.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossSpellCastOutOfBlockRF.CounterAttack = true
CombatSequences.DLC2BossSpellCastOutOfBlockRF.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossSpellCastOutOfBlockRF.Zones = {}
CombatSequences.DLC2BossSpellCastOutOfBlockRF.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossSpellCastOutOfBlockRF.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossSpellCastOutOfBlockRF.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DodgeRight",
		SpeedMultiplier = 1.5,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastRF",
		SpeedMultiplier = 1.2,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2BossAoESpellOutOfBlock --
CombatSequences.DLC2BossAoESpellOutOfBlock = {}
CombatSequences.DLC2BossAoESpellOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.DLC2BossAoESpellOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.DLC2BossAoESpellOutOfBlock.CounterAttack = true
CombatSequences.DLC2BossAoESpellOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2BossAoESpellOutOfBlock.Zones = {}
CombatSequences.DLC2BossAoESpellOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.DLC2BossAoESpellOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.DLC2BossAoESpellOutOfBlock.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCastArea",
		SpeedMultiplier = 1.2,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		Dummy = "Character.Focal.Chest",
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "MagicQuickCast",
		SpeedMultiplier = 1.2,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Carry.Hand.Left",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2CaptainSpecial --
CombatSequences.DLC2CaptainSpecial = {}
CombatSequences.DLC2CaptainSpecial.Priority = SequencePriorities.Attack
CombatSequences.DLC2CaptainSpecial.IsCombo = true
CombatSequences.DLC2CaptainSpecial.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2CaptainSpecial.Zones = {}
CombatSequences.DLC2CaptainSpecial.Zones[CombatZones.Near] = true
CombatSequences.DLC2CaptainSpecial.Zones[CombatZones.Middle] = true
CombatSequences.DLC2CaptainSpecial.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpecialStrike",
		SpeedMultiplier = 1.3,
		PushBackStrike = 1.5,
		FaceTargetAtStart = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}


-- uncomment for debug
-- GUI.DisplayMessageBox("UniqueSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end