
-- Renegade Melee Easy --
CombatStyles.RenegadeMeleeEasy = {}
CombatStyles.RenegadeMeleeEasy.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeMeleeEasy.CanStrafe = true
CombatStyles.RenegadeMeleeEasy.DesiredRange = 4
CombatStyles.RenegadeMeleeEasy.StrafeActionSpeed = 1
CombatStyles.RenegadeMeleeEasy.EnterRangedStrafeDist = 10
CombatStyles.RenegadeMeleeEasy.CanSheatheWeapon = true
CombatStyles.RenegadeMeleeEasy.Limits = {}
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeMeleeEasy.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeMeleeEasy.CanFlee = false
CombatStyles.RenegadeMeleeEasy.FleeAnim = "Flee"
CombatStyles.RenegadeMeleeEasy.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeMeleeEasy.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeMeleeEasy.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeMeleeEasy.Sequences = {}
CombatStyles.RenegadeMeleeEasy.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
    "BanditHeroFlourishResponse",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.RenegadeMeleeEasy.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.RenegadeMeleeEasy.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeMeleeEasy.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeMeleeEasy.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.RenegadeMeleeEasy.MinSecondsBetweenRangedAttacks = 7
CombatStyles.RenegadeMeleeEasy.CanBlock = true
CombatStyles.RenegadeMeleeEasy.BlockData = {}
CombatStyles.RenegadeMeleeEasy.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.RenegadeMeleeEasy.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeMeleeEasy.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.RenegadeMeleeEasy.BlockData.MaxHitsToBlock = 1
CombatStyles.RenegadeMeleeEasy.BlockData.SecondsToBlockFor = 0.7
CombatStyles.RenegadeMeleeEasy.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeMeleeEasy.AntiSpamData = {}
CombatStyles.RenegadeMeleeEasy.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeMeleeEasy.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeMeleeEasy.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeMeleeEasy.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeMeleeEasy.ValidStates = {}
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeEasy.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Melee --
CombatStyles.RenegadeMelee = {}
CombatStyles.RenegadeMelee.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeMelee.CanStrafe = true
CombatStyles.RenegadeMelee.DesiredRange = 4
CombatStyles.RenegadeMelee.StrafeActionSpeed = 1
CombatStyles.RenegadeMelee.EnterRangedStrafeDist = 10
CombatStyles.RenegadeMelee.CanSheatheWeapon = true
CombatStyles.RenegadeMelee.Limits = {}
CombatStyles.RenegadeMelee.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeMelee.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeMelee.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeMelee.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeMelee.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeMelee.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeMelee.CanFlee = false
CombatStyles.RenegadeMelee.FleeAnim = "Flee"
CombatStyles.RenegadeMelee.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeMelee.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeMelee.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeMelee.Sequences = {}
CombatStyles.RenegadeMelee.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
    "BanditHeroFlourishResponse",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.RenegadeMelee.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.RenegadeMelee.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeMelee.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeMelee.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.RenegadeMelee.MinSecondsBetweenRangedAttacks = 7
CombatStyles.RenegadeMelee.CanBlock = true
CombatStyles.RenegadeMelee.BlockData = {}
CombatStyles.RenegadeMelee.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.RenegadeMelee.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeMelee.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeMelee.BlockData.MaxHitsToBlock = 2
CombatStyles.RenegadeMelee.BlockData.SecondsToBlockFor = 1
CombatStyles.RenegadeMelee.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeMelee.AntiSpamData = {}
CombatStyles.RenegadeMelee.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeMelee.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeMelee.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeMelee.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeMelee.ValidStates = {}
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMelee.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Melee and Ranged --
CombatStyles.RenegadeMeleeAndRanged = {}
CombatStyles.RenegadeMeleeAndRanged.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeMeleeAndRanged.CanStrafe = true
CombatStyles.RenegadeMeleeAndRanged.DesiredRange = 4
CombatStyles.RenegadeMeleeAndRanged.StrafeActionSpeed = 1
CombatStyles.RenegadeMeleeAndRanged.EnterRangedStrafeDist = 10
CombatStyles.RenegadeMeleeAndRanged.CanSheatheWeapon = true
CombatStyles.RenegadeMeleeAndRanged.Limits = {}
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeMeleeAndRanged.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeMeleeAndRanged.CanFlee = false
CombatStyles.RenegadeMeleeAndRanged.FleeAnim = "Flee"
CombatStyles.RenegadeMeleeAndRanged.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeMeleeAndRanged.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeMeleeAndRanged.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeMeleeAndRanged.Sequences = {}
CombatStyles.RenegadeMeleeAndRanged.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
    "BanditHeroFlourishResponse",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.RenegadeMeleeAndRanged.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.RenegadeMeleeAndRanged.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeMeleeAndRanged.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeMeleeAndRanged.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.RenegadeMeleeAndRanged.MinSecondsBetweenRangedAttacks = 7
CombatStyles.RenegadeMeleeAndRanged.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeMeleeAndRanged.CanBlock = true
CombatStyles.RenegadeMeleeAndRanged.BlockData = {}
CombatStyles.RenegadeMeleeAndRanged.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.RenegadeMeleeAndRanged.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeMeleeAndRanged.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeMeleeAndRanged.BlockData.MaxHitsToBlock = 2
CombatStyles.RenegadeMeleeAndRanged.BlockData.SecondsToBlockFor = 1
CombatStyles.RenegadeMeleeAndRanged.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeMeleeAndRanged.AntiSpamData = {}
CombatStyles.RenegadeMeleeAndRanged.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeMeleeAndRanged.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeMeleeAndRanged.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeMeleeAndRanged.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeMeleeAndRanged.ValidStates = {}
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeMeleeAndRanged.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData = {}
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeMeleeAndRanged.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.15


-- Renegade Ranged Easy --
CombatStyles.RenegadeRangedEasy = {}
CombatStyles.RenegadeRangedEasy.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeRangedEasy.CanStrafe = true
CombatStyles.RenegadeRangedEasy.DesiredRange = 4
CombatStyles.RenegadeRangedEasy.StrafeActionSpeed = 1
CombatStyles.RenegadeRangedEasy.EnterRangedStrafeDist = 10
CombatStyles.RenegadeRangedEasy.CanSheatheWeapon = true
CombatStyles.RenegadeRangedEasy.Limits = {}
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeRangedEasy.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeRangedEasy.CanFlee = false
CombatStyles.RenegadeRangedEasy.FleeAnim = "Flee"
CombatStyles.RenegadeRangedEasy.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeRangedEasy.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeRangedEasy.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeRangedEasy.Sequences = {}
CombatStyles.RenegadeRangedEasy.Sequences[CombatSituations.Melee] = {
	"BanditGoad",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.RenegadeRangedEasy.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.RenegadeRangedEasy.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeRangedEasy.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeRangedEasy.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeRangedEasy.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.RenegadeRangedEasy.MinSecondsBetweenRangedAttacks = 6
CombatStyles.RenegadeRangedEasy.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeRangedEasy.CanBlock = true
CombatStyles.RenegadeRangedEasy.BlockData = {}
CombatStyles.RenegadeRangedEasy.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeRangedEasy.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeRangedEasy.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.RenegadeRangedEasy.BlockData.MaxHitsToBlock = 1
CombatStyles.RenegadeRangedEasy.BlockData.SecondsToBlockFor = 0.5
CombatStyles.RenegadeRangedEasy.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeRangedEasy.AntiSpamData = {}
CombatStyles.RenegadeRangedEasy.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeRangedEasy.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeRangedEasy.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeRangedEasy.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeRangedEasy.ValidStates = {}
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedEasy.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeRangedEasy.ShootingBalanceData = {}
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeRangedEasy.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.15


-- Renegade Ranged --
CombatStyles.RenegadeRanged = {}
CombatStyles.RenegadeRanged.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeRanged.CanStrafe = true
CombatStyles.RenegadeRanged.DesiredRange = 4
CombatStyles.RenegadeRanged.StrafeActionSpeed = 1
CombatStyles.RenegadeRanged.EnterRangedStrafeDist = 10
CombatStyles.RenegadeRanged.CanSheatheWeapon = true
CombatStyles.RenegadeRanged.Limits = {}
CombatStyles.RenegadeRanged.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeRanged.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeRanged.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeRanged.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeRanged.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeRanged.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeRanged.CanFlee = false
CombatStyles.RenegadeRanged.FleeAnim = "Flee"
CombatStyles.RenegadeRanged.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeRanged.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeRanged.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeRanged.Sequences = {}
CombatStyles.RenegadeRanged.Sequences[CombatSituations.Melee] = {
	"BanditGoad",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.RenegadeRanged.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.RenegadeRanged.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeRanged.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeRanged.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeRanged.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.RenegadeRanged.MinSecondsBetweenRangedAttacks = 6
CombatStyles.RenegadeRanged.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeRanged.CanBlock = true
CombatStyles.RenegadeRanged.BlockData = {}
CombatStyles.RenegadeRanged.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeRanged.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeRanged.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.RenegadeRanged.BlockData.MaxHitsToBlock = 1
CombatStyles.RenegadeRanged.BlockData.SecondsToBlockFor = 1
CombatStyles.RenegadeRanged.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeRanged.AntiSpamData = {}
CombatStyles.RenegadeRanged.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeRanged.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeRanged.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeRanged.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeRanged.ValidStates = {}
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRanged.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeRanged.ShootingBalanceData = {}
CombatStyles.RenegadeRanged.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeRanged.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeRanged.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.15


-- Renegade Turret --
CombatStyles.RenegadeTurret = {}
CombatStyles.RenegadeTurret.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeTurret.CanStrafe = true
CombatStyles.RenegadeTurret.NonFormation = true
CombatStyles.RenegadeTurret.StrafeActionSpeed = 1
CombatStyles.RenegadeTurret.EnterRangedStrafeDist = 10
CombatStyles.RenegadeTurret.MinTimeToReturnToFiringPos = 20
CombatStyles.RenegadeTurret.CanSheatheWeapon = true
CombatStyles.RenegadeTurret.TurretBalanceData = {}
CombatStyles.RenegadeTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.RenegadeTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.RenegadeTurret.TurretBalanceData.NonTurretCombatStyle = "RenegadeRanged"
CombatStyles.RenegadeTurret.Limits = {}
CombatStyles.RenegadeTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeTurret.Limits[CombatZones.Far] = 5.5
CombatStyles.RenegadeTurret.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeTurret.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeTurret.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeTurret.CanFlee = false
CombatStyles.RenegadeTurret.FleeAnim = "Flee"
CombatStyles.RenegadeTurret.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeTurret.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeTurret.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeTurret.Sequences = {}
CombatStyles.RenegadeTurret.Sequences[CombatSituations.Melee] = {
	"AttackComboLeftRightFastStep",
	"CloseAttackLeftRight",
	"BanditGoadAfterAttack",
	"BanditGoad",
	"BanditOuterGoad",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.RenegadeTurret.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"Idle",
	"FarIdle"
}
CombatStyles.RenegadeTurret.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeTurret.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.RenegadeTurret.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.RenegadeTurret.MinSecondsBetweenRangedAttacks = 5
CombatStyles.RenegadeTurret.CanStandOffAndShoot = "Turret"
CombatStyles.RenegadeTurret.CanBlock = true
CombatStyles.RenegadeTurret.BlockData = {}
CombatStyles.RenegadeTurret.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.RenegadeTurret.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeTurret.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.RenegadeTurret.BlockData.SecondsToBlockFor = 0.9
CombatStyles.RenegadeTurret.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeTurret.AntiSpamData = {}
CombatStyles.RenegadeTurret.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeTurret.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeTurret.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeTurret.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeTurret.ValidStates = {}
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"PlayCombatSequence",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeTurret.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeTurret.ShootingBalanceData = {}
CombatStyles.RenegadeTurret.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeTurret.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeTurret.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Renegade Elite --
CombatStyles.RenegadeElite = {}
CombatStyles.RenegadeElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeElite.CanStrafe = true
CombatStyles.RenegadeElite.DesiredRange = 4
CombatStyles.RenegadeElite.StrafeActionSpeed = 1
CombatStyles.RenegadeElite.EnterRangedStrafeDist = 10
CombatStyles.RenegadeElite.CanSheatheWeapon = true
CombatStyles.RenegadeElite.Limits = {}
CombatStyles.RenegadeElite.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.RenegadeElite.Limits[CombatZones.Far] = 4.5
CombatStyles.RenegadeElite.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeElite.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeElite.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeElite.CanFlee = false
CombatStyles.RenegadeElite.FleeAnim = "Flee"
CombatStyles.RenegadeElite.FleeIntoAnim = "FleeInto"
CombatStyles.RenegadeElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.RenegadeElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeElite.Sequences = {}
CombatStyles.RenegadeElite.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
    "BanditEliteFastBackOff",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.RenegadeElite.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.RenegadeElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeElite.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderAttackOutOfBlockShort"
}
CombatStyles.RenegadeElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon",
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeElite.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.RenegadeElite.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.RenegadeElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.RenegadeElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeElite.CanBlock = true
CombatStyles.RenegadeElite.BlockData = {}
CombatStyles.RenegadeElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.RenegadeElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeElite.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeElite.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeElite.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.RenegadeElite.BlockData.NumberOfHitsToForceSecondaryBlock = 1
CombatStyles.RenegadeElite.BlockData.SecondsToBlockFor = 1.8
CombatStyles.RenegadeElite.CanEvadeShots = false
CombatStyles.RenegadeElite.EvadeShotsData = {}
CombatStyles.RenegadeElite.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.RenegadeElite.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.RenegadeElite.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.RenegadeElite.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.RenegadeElite.AntiSpamData = {}
CombatStyles.RenegadeElite.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeElite.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeElite.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeElite.ValidStates = {}
CombatStyles.RenegadeElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"RangedWeaponGoading",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeElite.ShootingBalanceData = {}
CombatStyles.RenegadeElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.12
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.15


-- Renegade SuperElite --
CombatStyles.RenegadeSuperElite = {}
CombatStyles.RenegadeSuperElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeSuperElite.CanStrafe = true
CombatStyles.RenegadeSuperElite.DesiredRange = 4
CombatStyles.RenegadeSuperElite.EnterStrafeDist = 3
CombatStyles.RenegadeSuperElite.StrafeActionSpeed = 1
CombatStyles.RenegadeSuperElite.PreferOuterRing = true
CombatStyles.RenegadeSuperElite.EnterRangedStrafeDist = 10
CombatStyles.RenegadeSuperElite.CanSheatheWeapon = true
CombatStyles.RenegadeSuperElite.Limits = {}
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Middle] = 3.5
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Far] = 8.5
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeSuperElite.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeSuperElite.CanFlee = false
CombatStyles.RenegadeSuperElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeSuperElite.Sequences = {}
CombatStyles.RenegadeSuperElite.Sequences[CombatSituations.Melee] = {
	{"LoganSoldierSwordGrenadeThrow", 10},
	"LoganSoldierAntiSpamSwordGrenadeThrow",
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"LoganSoldierTwoStrikesAttackCombo",
	"LoganSoldierAttackComboVar01",
	"LoganSoldierAttackCombo",
	"LoganSoldierEliteClosePushBackAttack",
    "BanditEliteAttackCombo",
    "BanditEliteCloseAttackCombo",
    "BanditEliteFastBackOff",
    "BanditLeftAttack",
    "BanditRightAttack",
    "LoganSoldierRearAttack",
    "Idle"
}
CombatStyles.RenegadeSuperElite.Sequences[CombatSituations.Ranged] = {
	{"LoganSoldierPistolGrenadeThrow", 10},
	"LoganSoldierAntiSpamPistolGrenadeThrow",
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditLeaderInteruptSpellRanged",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.RenegadeSuperElite.Sequences[CombatSituations.HardBlocking] = {
	"LoganSoldierAttackOutOfBlock"
}
CombatStyles.RenegadeSuperElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.RenegadeSuperElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeSuperElite.MinSecondsBetweenMeleeAttacks = 0.6
CombatStyles.RenegadeSuperElite.SecondsToWaitAfterTargetIsHit = 1.1
CombatStyles.RenegadeSuperElite.MinSecondsBetweenRangedAttacks = 2.5
CombatStyles.RenegadeSuperElite.MinSecondsBetweenSpecialRangedAttacks = 15
CombatStyles.RenegadeSuperElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeSuperElite.CanBlock = true
CombatStyles.RenegadeSuperElite.BlockData = {}
CombatStyles.RenegadeSuperElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeSuperElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 8
CombatStyles.RenegadeSuperElite.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.RenegadeSuperElite.BlockData.SecondsToBlockFor = 1.8
CombatStyles.RenegadeSuperElite.DodgeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.RenegadeSuperElite.CanEvadeShots = false
CombatStyles.RenegadeSuperElite.AntiSpamData = {}
CombatStyles.RenegadeSuperElite.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeSuperElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeSuperElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeSuperElite.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeSuperElite.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeSuperElite.ValidStates = {}
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"GetTargetInSights",
	"PlayCombatSequence",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeSuperElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeSuperElite.ShootingBalanceData = {}
CombatStyles.RenegadeSuperElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeSuperElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.15
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.5
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.RenegadeSuperElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.15


-- Renegade Turret Easy --
CombatStyles.RenegadeTurretEasy = DeepCopyTable(CombatStyles.RenegadeTurret)


-- Renegade Turret Elite --
CombatStyles.RenegadeTurretElite = DeepCopyTable(CombatStyles.RenegadeTurret)
CombatStyles.RenegadeTurretElite.TurretBalanceData = {}
CombatStyles.RenegadeTurretElite.TurretBalanceData.NonTurretCombatStyle = "RenegadeElite"


-- Renegade Turret Easy AlwaysMiss --
CombatStyles.RenegadeTurretEasyAlwaysMiss = DeepCopyTable(CombatStyles.RenegadeTurretEasy)
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData = {}
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModSegmentLength = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 100
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0
CombatStyles.RenegadeTurretEasyAlwaysMiss.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0


-- Renegade Turret SuperElite --
CombatStyles.RenegadeSuperEliteTurret = DeepCopyTable(CombatStyles.RenegadeSuperElite)
CombatStyles.RenegadeSuperEliteTurret.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeSuperEliteTurret.CanStandOffAndShoot = "Turret"
CombatStyles.RenegadeSuperEliteTurret.MinTimeToReturnToFiringPos = 20
CombatStyles.RenegadeSuperEliteTurret.NonFormation = true
CombatStyles.RenegadeSuperEliteTurret.TurretBalanceData = {}
CombatStyles.RenegadeSuperEliteTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.RenegadeSuperEliteTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.RenegadeSuperEliteTurret.TurretBalanceData.NonTurretCombatStyle = "RenegadeRanged"
CombatStyles.RenegadeSuperEliteTurret.Limits = {}
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Middle] = 3
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Far] = 8
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Left] = 1
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Right] = 1
CombatStyles.RenegadeSuperEliteTurret.Limits[CombatZones.Rear] = 1
CombatStyles.RenegadeSuperEliteTurret.Sequences = {}
CombatStyles.RenegadeSuperEliteTurret.Sequences[CombatSituations.Melee] = {
	{"LoganSoldierPistolGrenadeThrow", 10},
	"Advance",
	"GuardCloseAttack",
	"GuardAttack",
	"FastBackOff",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.RenegadeSuperEliteTurret.Sequences[CombatSituations.Ranged] = {
	{"LoganSoldierPistolGrenadeThrow", 10},
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"Idle",
	"FarIdle"
}
CombatStyles.RenegadeSuperEliteTurret.ValidStates = {}
CombatStyles.RenegadeSuperEliteTurret.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"ThrowGrenadeAtDistantTarget",
	"FireRangedWeapon",
	"PlayCombatSequence",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.RenegadeSuperEliteTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}


-- Renegade Turret NoWait --
CombatStyles.RenegadeTurretNoWait = DeepCopyTable(CombatStyles.RenegadeTurret)
CombatStyles.RenegadeTurretNoWait.MoveToFiringPosNoWait = true


-- Renegade Turret Easy NoWait --
CombatStyles.RenegadeTurretEasyNoWait = DeepCopyTable(CombatStyles.RenegadeTurretEasy)
CombatStyles.RenegadeTurretEasyNoWait.MoveToFiringPosNoWait = true


-- Renegade Turret Elite NoWait --
CombatStyles.RenegadeTurretEliteNoWait = DeepCopyTable(CombatStyles.RenegadeTurretElite)
CombatStyles.RenegadeTurretEliteNoWait.MoveToFiringPosNoWait = true


-- Renegade Turret SuperElite NoWait --
CombatStyles.RenegadeSuperEliteTurretNoWait = DeepCopyTable(CombatStyles.RenegadeSuperEliteTurret)
CombatStyles.RenegadeSuperEliteTurretNoWait.MoveToFiringPosNoWait = true


-- Renegade Leader --
CombatStyles.RenegadeLeader = {}
CombatStyles.RenegadeLeader.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeLeader.CanStrafe = true
CombatStyles.RenegadeLeader.DesiredRange = 2.25
CombatStyles.RenegadeLeader.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.RenegadeLeader.EnterRangedStrafeDist = 3
CombatStyles.RenegadeLeader.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.RenegadeLeader.PercentageOfHealthRemainingToTriggerCombatStyleSwitch = 0.56
CombatStyles.RenegadeLeader.CanSheatheWeapon = true
CombatStyles.RenegadeLeader.Limits = {}
CombatStyles.RenegadeLeader.Limits[CombatZones.Near] = 2.15
CombatStyles.RenegadeLeader.Limits[CombatZones.Middle] = 3.8
CombatStyles.RenegadeLeader.Limits[CombatZones.Far] = 10
CombatStyles.RenegadeLeader.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeLeader.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeLeader.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeLeader.CanFlee = false
CombatStyles.RenegadeLeader.Sequences = {}
CombatStyles.RenegadeLeader.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRearAttack",
	{"RenegadeLeaderStepBackPound", 10},
	"RenegadeLeaderLeftStrike",
	"RenegadeLeaderRightStrike",
	"RenegadeLeaderCloseCombo",
	"RenegadeLeaderLeftHookUppercut",
	{"RenegadeLeaderStepInFlourish", 5},
	{"RenegadeLeaderPunchCombo", 10},
    "RenegadeLeaderStepInHit",
    "RenegadeLeaderStepInUppercut",
	{"RenegadeLeaderThrowGrenade", 5},
    "RenegadeLeaderSpamResponseNear",
    "RenegadeLeaderSpamResponse",
    "Pace",
    "RenegadeLeaderIdle"
}
CombatStyles.RenegadeLeader.Sequences[CombatSituations.SoftBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeader.Sequences[CombatSituations.HardBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeader.ShootsInMelee = true
CombatStyles.RenegadeLeader.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.RenegadeLeader.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.RenegadeLeader.MinSecondsBetweenRangedAttacks = 6
CombatStyles.RenegadeLeader.CanStandOffAndShoot = "Aggressive"
CombatStyles.RenegadeLeader.CanBlock = true
CombatStyles.RenegadeLeader.BlockData = {}
CombatStyles.RenegadeLeader.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeLeader.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeLeader.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeLeader.BlockData.SecondsToBlockFor = 1.6
CombatStyles.RenegadeLeader.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeLeader.AntiSpamData = {}
CombatStyles.RenegadeLeader.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeLeader.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeLeader.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeLeader.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeLeader.ValidStates = {}
CombatStyles.RenegadeLeader.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"RenegadeLeaderLowHealthStyleSwitch",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"RenegadeLeaderTauntOnGround",
	"OuterRingSpreadOut",
	"ThrowGrenadeAtDistantTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeLeader.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeader.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeader.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeader.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Leader LowHealth --
CombatStyles.RenegadeLeaderLowHealth = {}
CombatStyles.RenegadeLeaderLowHealth.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeLeaderLowHealth.CanStrafe = false
CombatStyles.RenegadeLeaderLowHealth.DesiredRange = 2
CombatStyles.RenegadeLeaderLowHealth.DamageMultiplier = 20
CombatStyles.RenegadeLeaderLowHealth.EnterStrafeDist = 3
CombatStyles.RenegadeLeaderLowHealth.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.RenegadeLeaderLowHealth.EnterRangedStrafeDist = 3
CombatStyles.RenegadeLeaderLowHealth.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.RenegadeLeaderLowHealth.CanSheatheWeapon = true
CombatStyles.RenegadeLeaderLowHealth.Limits = {}
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Near] = 2.15
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Middle] = 3.25
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Far] = 10
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeLeaderLowHealth.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeLeaderLowHealth.CanFlee = false
CombatStyles.RenegadeLeaderLowHealth.Sequences = {}
CombatStyles.RenegadeLeaderLowHealth.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRageSpamResponseNear",
	"RenegadeLeaderFireballSpamResponse",
	{"RenegadeLeaderFireballThrow", 2.5},
	"RenegadeLeaderRageRearAttack",
	{"RenegadeLeaderRageStepBackPound", 5},
	"RenegadeLeaderStepInRageAttackUppercut",
	"RenegadeLeaderStepInRageAttackSlap",
	"RenegadeLeaderRageAttackSlap",
	"RenegadeLeaderRageAttackUppercut",
	{"RenegadeLeaderPunchCombo", 10},
	{"RenegadeLeaderStepInFlourish", 5},
    "RenegadeLeaderCloseCombo",
    "RenegadeLeaderIdle"
}
CombatStyles.RenegadeLeaderLowHealth.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.RenegadeLeaderLowHealth.SecondsToWaitAfterTargetIsHit = 0.15
CombatStyles.RenegadeLeaderLowHealth.MinSecondsBetweenRangedAttacks = 1
CombatStyles.RenegadeLeaderLowHealth.CanBlock = false
CombatStyles.RenegadeLeaderLowHealth.AntiSpamData = {}
CombatStyles.RenegadeLeaderLowHealth.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeLeaderLowHealth.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeLeaderLowHealth.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeLeaderLowHealth.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeLeaderLowHealth.ValidStates = {}
CombatStyles.RenegadeLeaderLowHealth.ValidStates[CombatSituations.Melee] = {
	"RenegadeLeaderLightHands",
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"RenegadeLeaderTauntOnGround",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeLeaderLowHealth.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderLowHealth.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderLowHealth.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderLowHealth.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- Renegade Leader Boss --
CombatStyles.RenegadeLeaderBoss = {}
CombatStyles.RenegadeLeaderBoss.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeLeaderBoss.CanStrafe = false
CombatStyles.RenegadeLeaderBoss.DesiredRange = 1
CombatStyles.RenegadeLeaderBoss.DamageMultiplier = 10
CombatStyles.RenegadeLeaderBoss.EnterRangedStrafeDist = 10
CombatStyles.RenegadeLeaderBoss.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.RenegadeLeaderBoss.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.RenegadeLeaderBoss.CanSheatheWeapon = true
CombatStyles.RenegadeLeaderBoss.Limits = {}
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Near] = 2.15
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Middle] = 3.25
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Far] = 10
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeLeaderBoss.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeLeaderBoss.CanFlee = false
CombatStyles.RenegadeLeaderBoss.Sequences = {}
CombatStyles.RenegadeLeaderBoss.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRageSpamResponseNear",
	"EliteRenegadeLeaderFireballSpamResponse",
	{"EliteRenegadeLeaderFireballThrow", 4.5},
	"RenegadeLeaderRageRearAttack",
	{"RenegadeLeaderRageStepBackPound", 2},
	"RenegadeLeaderStepInRageAttackUppercut",
	"RenegadeLeaderStepInRageAttackSlap",
	"RenegadeLeaderRageAttackSlap",
	"RenegadeLeaderRageAttackUppercut",
	{"RenegadeLeaderPunchCombo", 10},
	{"RenegadeLeaderStepInFlourish", 5},
    "RenegadeLeaderCloseCombo",
    "RenegadeLeaderIdle"
}
CombatStyles.RenegadeLeaderBoss.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.RenegadeLeaderBoss.SecondsToWaitAfterTargetIsHit = 0.2
CombatStyles.RenegadeLeaderBoss.MinSecondsBetweenRangedAttacks = 5
CombatStyles.RenegadeLeaderBoss.CanBlock = false
CombatStyles.RenegadeLeaderBoss.AntiSpamData = {}
CombatStyles.RenegadeLeaderBoss.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeLeaderBoss.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeLeaderBoss.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeLeaderBoss.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeLeaderBoss.ValidStates = {}
CombatStyles.RenegadeLeaderBoss.ValidStates[CombatSituations.Melee] = {
	"RenegadeLeaderLightHands",
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"RenegadeLeaderTauntOnGround",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeLeaderBoss.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderBoss.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderBoss.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderBoss.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- SakerStyle --
CombatStyles.SakerStyle = {}
CombatStyles.SakerStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.SakerStyle.CanStrafe = true
CombatStyles.SakerStyle.UseStrafeActions = true
CombatStyles.SakerStyle.NonFormation = true
CombatStyles.SakerStyle.DesiredRange = 2.25
CombatStyles.SakerStyle.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.SakerStyle.EnterStrafeDist = 4
CombatStyles.SakerStyle.CanSheatheWeapon = true
CombatStyles.SakerStyle.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.SakerStyle.Limits = {}
CombatStyles.SakerStyle.Limits[CombatZones.Near] = 2.15
CombatStyles.SakerStyle.Limits[CombatZones.Middle] = 3.8
CombatStyles.SakerStyle.Limits[CombatZones.Far] = 10
CombatStyles.SakerStyle.Limits[CombatZones.Left] = 2
CombatStyles.SakerStyle.Limits[CombatZones.Right] = 2
CombatStyles.SakerStyle.Limits[CombatZones.Rear] = 3
CombatStyles.SakerStyle.CanFlee = false
CombatStyles.SakerStyle.Sequences = {}
CombatStyles.SakerStyle.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRearAttack",
	"EliteRenegadeLeaderFireballSpamResponse",
	{"RenegadeLeaderStepBackPound", 10},
	"RenegadeLeaderLeftStrike",
	"RenegadeLeaderRightStrike",
	"RenegadeLeaderCloseCombo",
	"RenegadeLeaderLeftHookUppercut",
	{"RenegadeLeaderStepInFlourish", 10},
	{"RenegadeLeaderPunchCombo", 10},
	"RenegadeLeaderStepInHit",
	"RenegadeLeaderStepInUppercut",
	{"RenegadeLeaderThrowGrenade", 5},
	"RenegadeLeaderSpamResponseNear",
	"RenegadeLeaderSpamResponse",
	"Pace",
    "RenegadeLeaderIdle"
}
CombatStyles.SakerStyle.Sequences[CombatSituations.SoftBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.SakerStyle.Sequences[CombatSituations.HardBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.SakerStyle.ShootsInMelee = true
CombatStyles.SakerStyle.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.SakerStyle.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.SakerStyle.MinSecondsBetweenRangedAttacks = 6
CombatStyles.SakerStyle.CanBlock = true
CombatStyles.SakerStyle.BlockData = {}
CombatStyles.SakerStyle.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.SakerStyle.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.SakerStyle.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.SakerStyle.BlockData.SecondsToBlockFor = 1.2
CombatStyles.SakerStyle.OuterRingPercentAsRanged = 0.5
CombatStyles.SakerStyle.AntiSpamData = {}
CombatStyles.SakerStyle.AntiSpamData.TimeToCheckFor = 4
CombatStyles.SakerStyle.AntiSpamData.ShotsToTrigger = 4
CombatStyles.SakerStyle.AntiSpamData.SpellsToTrigger = 4
CombatStyles.SakerStyle.AntiSpamData.TimeToAggroFor = 8
CombatStyles.SakerStyle.ValidStates = {}
CombatStyles.SakerStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"RenegadeLeaderTauntOnGround",
	"OuterRingSpreadOut",
	"ThrowGrenadeAtDistantTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.SakerStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- Saker Defesive GrenadesStyle --
CombatStyles.SakerDefesiveGrenadesStyle = {}
CombatStyles.SakerDefesiveGrenadesStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.SakerDefesiveGrenadesStyle.CanStrafe = true
CombatStyles.SakerDefesiveGrenadesStyle.UseStrafeActions = true
CombatStyles.SakerDefesiveGrenadesStyle.NonFormation = true
CombatStyles.SakerDefesiveGrenadesStyle.DesiredRange = 2.25
CombatStyles.SakerDefesiveGrenadesStyle.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.SakerDefesiveGrenadesStyle.EnterStrafeDist = 4
CombatStyles.SakerDefesiveGrenadesStyle.CanSheatheWeapon = true
CombatStyles.SakerDefesiveGrenadesStyle.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.SakerDefesiveGrenadesStyle.Limits = {}
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Near] = 2.15
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Middle] = 3.8
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Far] = 10
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Left] = 2
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Right] = 2
CombatStyles.SakerDefesiveGrenadesStyle.Limits[CombatZones.Rear] = 3
CombatStyles.SakerDefesiveGrenadesStyle.CanFlee = false
CombatStyles.SakerDefesiveGrenadesStyle.Sequences = {}
CombatStyles.SakerDefesiveGrenadesStyle.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRearAttack",
	{"RenegadeLeaderStepBackPound", 10},
	"RenegadeLeaderLeftStrike",
	"RenegadeLeaderRightStrike",
	"RenegadeLeaderCloseCombo",
	"RenegadeLeaderLeftHookUppercut",
	{"RenegadeLeaderStepInFlourish", 10},
	{"RenegadeLeaderPunchCombo", 10},
	"RenegadeLeaderStepInHit",
	"RenegadeLeaderStepInUppercut",
	"RenegadeLeaderSpamResponseNear",
	"SakerSpamResponse",
	"Pace",
	"RenegadeLeaderIdle"
}
CombatStyles.SakerDefesiveGrenadesStyle.Sequences[CombatSituations.SoftBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.SakerDefesiveGrenadesStyle.Sequences[CombatSituations.HardBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.SakerDefesiveGrenadesStyle.ShootsInMelee = true
CombatStyles.SakerDefesiveGrenadesStyle.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.SakerDefesiveGrenadesStyle.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.SakerDefesiveGrenadesStyle.MinSecondsBetweenRangedAttacks = 6
CombatStyles.SakerDefesiveGrenadesStyle.CanBlock = true
CombatStyles.SakerDefesiveGrenadesStyle.BlockData = {}
CombatStyles.SakerDefesiveGrenadesStyle.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.SakerDefesiveGrenadesStyle.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.SakerDefesiveGrenadesStyle.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.SakerDefesiveGrenadesStyle.BlockData.SecondsToBlockFor = 1.2
CombatStyles.SakerDefesiveGrenadesStyle.OuterRingPercentAsRanged = 0.5
CombatStyles.SakerDefesiveGrenadesStyle.AntiSpamData = {}
CombatStyles.SakerDefesiveGrenadesStyle.AntiSpamData.TimeToCheckFor = 4
CombatStyles.SakerDefesiveGrenadesStyle.AntiSpamData.ShotsToTrigger = 4
CombatStyles.SakerDefesiveGrenadesStyle.AntiSpamData.SpellsToTrigger = 4
CombatStyles.SakerDefesiveGrenadesStyle.AntiSpamData.TimeToAggroFor = 8
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates = {}
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"RenegadeLeaderTauntOnGround",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SakerDefesiveGrenadesStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- Renegade Leader Turret --
CombatStyles.RenegadeLeaderTurret = {}
CombatStyles.RenegadeLeaderTurret.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeLeaderTurret.CanStrafe = true
CombatStyles.RenegadeLeaderTurret.DesiredRange = 2.2
CombatStyles.RenegadeLeaderTurret.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.RenegadeLeaderTurret.NonFormation = true
CombatStyles.RenegadeLeaderTurret.EnterStrafeDist = 2.75
CombatStyles.RenegadeLeaderTurret.CanSheatheWeapon = true
CombatStyles.RenegadeLeaderTurret.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.RenegadeLeaderTurret.PercentageOfHealthRemainingToTriggerCombatStyleSwitch = 0.56
CombatStyles.RenegadeLeaderTurret.Limits = {}
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Near] = 2
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Middle] = 3
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Far] = 10
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeLeaderTurret.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeLeaderTurret.TurretBalanceData = {}
CombatStyles.RenegadeLeaderTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.RenegadeLeaderTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.RenegadeLeaderTurret.TurretBalanceData.NonTurretCombatStyle = "RenegadeLeader"
CombatStyles.RenegadeLeaderTurret.ShootsInMelee = true
CombatStyles.RenegadeLeaderTurret.CanFlee = false
CombatStyles.RenegadeLeaderTurret.Sequences = {}
CombatStyles.RenegadeLeaderTurret.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderLeftStrike",
	"RenegadeLeaderRightStrike",
	"RenegadeLeaderCloseCombo",
	"RenegadeLeaderLeftHookUppercut",
	{"RenegadeLeaderStepBackPound", 10},
	{"RenegadeLeaderStepInFlourish", 20},
	{"RenegadeLeaderPunchCombo", 20},
    "RenegadeLeaderStepInHit",
    "RenegadeLeaderStepInUppercut",
	{"RenegadeLeaderThrowGrenade", 5},
    "RenegadeLeaderSpamResponseNear",
    "RenegadeLeaderSpamResponse",
    "Pace",
    "RenegadeLeaderIdle"
}
CombatStyles.RenegadeLeaderTurret.Sequences[CombatSituations.SoftBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeaderTurret.Sequences[CombatSituations.HardBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeaderTurret.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.RenegadeLeaderTurret.MinSecondsBetweenRangedAttacks = 7
CombatStyles.RenegadeLeaderTurret.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.RenegadeLeaderTurret.CanBlock = true
CombatStyles.RenegadeLeaderTurret.BlockData = {}
CombatStyles.RenegadeLeaderTurret.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeLeaderTurret.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeLeaderTurret.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeLeaderTurret.BlockData.SecondsToBlockFor = 1.6
CombatStyles.RenegadeLeaderTurret.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeLeaderTurret.AntiSpamData = {}
CombatStyles.RenegadeLeaderTurret.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeLeaderTurret.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeLeaderTurret.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeLeaderTurret.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeLeaderTurret.ValidStates = {}
CombatStyles.RenegadeLeaderTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"ThrowGrenadeAtDistantTarget",
	"RenegadeLeaderTauntOnGround",
	"PlayCombatSequence",
	"FaceTarget"
}
CombatStyles.RenegadeLeaderTurret.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderTurret.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderTurret.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderTurret.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- Renegade Leader NoMolotovStyle --
CombatStyles.RenegadeLeaderNoMolotovStyle = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeLeaderNoMolotovStyle.CanStrafe = true
CombatStyles.RenegadeLeaderNoMolotovStyle.UseStrafeActions = true
CombatStyles.RenegadeLeaderNoMolotovStyle.NonFormation = true
CombatStyles.RenegadeLeaderNoMolotovStyle.DesiredRange = 2.25
CombatStyles.RenegadeLeaderNoMolotovStyle.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.RenegadeLeaderNoMolotovStyle.EnterStrafeDist = 4
CombatStyles.RenegadeLeaderNoMolotovStyle.CanSheatheWeapon = true
CombatStyles.RenegadeLeaderNoMolotovStyle.MinTimeBetweenTauntOnGroundAnims = 20
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Near] = 2.15
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Middle] = 3.8
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Far] = 10
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Left] = 2
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Right] = 2
CombatStyles.RenegadeLeaderNoMolotovStyle.Limits[CombatZones.Rear] = 3
CombatStyles.RenegadeLeaderNoMolotovStyle.CanFlee = false
CombatStyles.RenegadeLeaderNoMolotovStyle.Sequences = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.Sequences[CombatSituations.Melee] = {
	"RenegadeLeaderRearAttack",
	{"RenegadeLeaderStepBackPound", 10},
	"RenegadeLeaderLeftStrike",
	"RenegadeLeaderRightStrike",
	"RenegadeLeaderCloseCombo",
	"RenegadeLeaderLeftHookUppercut",
	{"RenegadeLeaderStepInFlourish", 10},
	{"RenegadeLeaderPunchCombo", 10},
    "RenegadeLeaderStepInHit",
    "RenegadeLeaderStepInUppercut",
	"RenegadeLeaderSpamResponseNear",
    "SakerSpamResponse",
    "Pace",
    "RenegadeLeaderIdle"
}
CombatStyles.RenegadeLeaderNoMolotovStyle.Sequences[CombatSituations.SoftBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeaderNoMolotovStyle.Sequences[CombatSituations.HardBlocking] = {
	"RenegadeLeaderAttackOutOfBlock"
}
CombatStyles.RenegadeLeaderNoMolotovStyle.ShootsInMelee = true
CombatStyles.RenegadeLeaderNoMolotovStyle.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.RenegadeLeaderNoMolotovStyle.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.RenegadeLeaderNoMolotovStyle.MinSecondsBetweenRangedAttacks = 6
CombatStyles.RenegadeLeaderNoMolotovStyle.CanBlock = true
CombatStyles.RenegadeLeaderNoMolotovStyle.BlockData = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.RenegadeLeaderNoMolotovStyle.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.RenegadeLeaderNoMolotovStyle.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeLeaderNoMolotovStyle.BlockData.SecondsToBlockFor = 1.2
CombatStyles.RenegadeLeaderNoMolotovStyle.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeLeaderNoMolotovStyle.AntiSpamData = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeLeaderNoMolotovStyle.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeLeaderNoMolotovStyle.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeLeaderNoMolotovStyle.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates = {}
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"RenegadeLeaderTauntOnGround",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeLeaderNoMolotovStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- DLC2Thug --
CombatStyles.DLC2Thug = {}
CombatStyles.DLC2Thug.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2Thug.CanStrafe = true
CombatStyles.DLC2Thug.DesiredRange = 4
CombatStyles.DLC2Thug.MovementTolerance = 0.5
CombatStyles.DLC2Thug.StrafeActionSpeed = 1
CombatStyles.DLC2Thug.EnterRangedStrafeDist = 10
CombatStyles.DLC2Thug.CanSheatheWeapon = true
CombatStyles.DLC2Thug.Limits = {}
CombatStyles.DLC2Thug.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2Thug.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2Thug.Limits[CombatZones.Far] = 4
CombatStyles.DLC2Thug.Limits[CombatZones.Left] = 2
CombatStyles.DLC2Thug.Limits[CombatZones.Right] = 2
CombatStyles.DLC2Thug.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2Thug.CanFlee = false
CombatStyles.DLC2Thug.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.DLC2Thug.Sequences = {}
CombatStyles.DLC2Thug.Sequences[CombatSituations.Melee] = {
	"DLC2ThugJumpAttack",
	"DLC2ThugShotTooMuch",
	"BanditInteruptSpellMelee",
	"DLC2ThugGoad",
	"BanditOuterGoad",
	"FarIdle",
	"BanditEliteCloseAttackCombo",
    "BanditEliteAttackCombo",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.DLC2Thug.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderAttackOutOfBlockShort"
}
CombatStyles.DLC2Thug.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon",
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.DLC2Thug.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.DLC2Thug.SecondsToWaitAfterTargetIsHit = 0.5
CombatStyles.DLC2Thug.CanBlock = true
CombatStyles.DLC2Thug.BlockData = {}
CombatStyles.DLC2Thug.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DLC2Thug.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 8
CombatStyles.DLC2Thug.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.DLC2Thug.BlockData.SecondsToBlockFor = 1.8
CombatStyles.DLC2Thug.CanEvadeShots = false
CombatStyles.DLC2Thug.AntiSpamData = {}
CombatStyles.DLC2Thug.AntiSpamData.TimeToCheckFor = 4
CombatStyles.DLC2Thug.AntiSpamData.ShotsToTrigger = 4
CombatStyles.DLC2Thug.AntiSpamData.SpellsToTrigger = 4
CombatStyles.DLC2Thug.AntiSpamData.TimeToAggroFor = 8
CombatStyles.DLC2Thug.OuterRingPercentAsRanged = 0.5
CombatStyles.DLC2Thug.ValidStates = {}
CombatStyles.DLC2Thug.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2Thug.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Thug.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Thug.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Thug.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- DLC2CrazyThug --
CombatStyles.DLC2CrazyThug = {}
CombatStyles.DLC2CrazyThug.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2CrazyThug.CanStrafe = true
CombatStyles.DLC2CrazyThug.DesiredRange = 4
CombatStyles.DLC2CrazyThug.MovementTolerance = 0.5
CombatStyles.DLC2CrazyThug.StrafeActionSpeed = 1
CombatStyles.DLC2CrazyThug.EnterRangedStrafeDist = 10
CombatStyles.DLC2CrazyThug.CanSheatheWeapon = true
CombatStyles.DLC2CrazyThug.Limits = {}
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Far] = 4
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Left] = 2
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Right] = 2
CombatStyles.DLC2CrazyThug.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2CrazyThug.CanFlee = false
CombatStyles.DLC2CrazyThug.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.DLC2CrazyThug.Sequences = {}
CombatStyles.DLC2CrazyThug.Sequences[CombatSituations.Melee] = {
	"DLC2ThugJumpAttack",
	"DLC2ThugShotTooMuch",
	"DLC2ThugAttackCombo",
	"BanditInteruptSpellMelee",
	"LoganSoldierTwoStrikesAttackCombo",
	"LoganSoldierAttackComboVar01",
	"LoganSoldierAttackCombo",
	"FarIdle",
	"DLC2ThugGoad",
    "BanditOuterGoad",
    "BanditEliteCloseAttackCombo",
    "BanditLeftAttack",
    "BanditRightAttack",
    "LoganSoldierRearAttack"
}
CombatStyles.DLC2CrazyThug.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderAttackOutOfBlockShort"
}
CombatStyles.DLC2CrazyThug.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon",
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.DLC2CrazyThug.MinSecondsBetweenMeleeAttacks = 0.25
CombatStyles.DLC2CrazyThug.SecondsToWaitAfterTargetIsHit = 0.5
CombatStyles.DLC2CrazyThug.CanBlock = true
CombatStyles.DLC2CrazyThug.BlockData = {}
CombatStyles.DLC2CrazyThug.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DLC2CrazyThug.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 8
CombatStyles.DLC2CrazyThug.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.DLC2CrazyThug.BlockData.SecondsToBlockFor = 1.8
CombatStyles.DLC2CrazyThug.CanEvadeShots = false
CombatStyles.DLC2CrazyThug.AntiSpamData = {}
CombatStyles.DLC2CrazyThug.AntiSpamData.TimeToCheckFor = 4
CombatStyles.DLC2CrazyThug.AntiSpamData.ShotsToTrigger = 4
CombatStyles.DLC2CrazyThug.AntiSpamData.SpellsToTrigger = 4
CombatStyles.DLC2CrazyThug.AntiSpamData.TimeToAggroFor = 8
CombatStyles.DLC2CrazyThug.OuterRingPercentAsRanged = 0.5
CombatStyles.DLC2CrazyThug.ValidStates = {}
CombatStyles.DLC2CrazyThug.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2CrazyThug.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2CrazyThug.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2CrazyThug.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2CrazyThug.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


--Renegade ShadowMayor --
CombatStyles.RenegadeShadowMayor = {}
CombatStyles.RenegadeShadowMayor.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.RenegadeShadowMayor.CanStrafe = true
CombatStyles.RenegadeShadowMayor.DesiredRange = 4
CombatStyles.RenegadeShadowMayor.StrafeActionSpeed = 1
CombatStyles.RenegadeShadowMayor.EnterRangedStrafeDist = 10
CombatStyles.RenegadeShadowMayor.CanSheatheWeapon = true
CombatStyles.RenegadeShadowMayor.Limits = {}
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Near] = 2
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Middle] = 3
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Far] = 8
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Left] = 1
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Right] = 1
CombatStyles.RenegadeShadowMayor.Limits[CombatZones.Rear] = 1
CombatStyles.RenegadeShadowMayor.CanFlee = false
CombatStyles.RenegadeShadowMayor.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.RenegadeShadowMayor.Sequences = {}
CombatStyles.RenegadeShadowMayor.Sequences[CombatSituations.Melee] = {
	"CastMayorSwordsTargeted",
	"CastMayorForcePushTargeted"
}
CombatStyles.RenegadeShadowMayor.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon",
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.RenegadeShadowMayor.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.RenegadeShadowMayor.SecondsToWaitAfterTargetIsHit = 2.5
CombatStyles.RenegadeShadowMayor.MinSecondsBetweenRangedAttacks = 4
CombatStyles.RenegadeShadowMayor.CanBlock = true
CombatStyles.RenegadeShadowMayor.BlockData = {}
CombatStyles.RenegadeShadowMayor.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.RenegadeShadowMayor.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 8
CombatStyles.RenegadeShadowMayor.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.RenegadeShadowMayor.BlockData.SecondsToBlockFor = 1
CombatStyles.RenegadeShadowMayor.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.RenegadeShadowMayor.CanEvadeShots = true
CombatStyles.RenegadeShadowMayor.EvadeShotsData = {}
CombatStyles.RenegadeShadowMayor.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.RenegadeShadowMayor.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.RenegadeShadowMayor.EvadeShotsData.HitsToStartEvading = 1
CombatStyles.RenegadeShadowMayor.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.RenegadeShadowMayor.AntiSpamData = {}
CombatStyles.RenegadeShadowMayor.AntiSpamData.TimeToCheckFor = 4
CombatStyles.RenegadeShadowMayor.AntiSpamData.ShotsToTrigger = 4
CombatStyles.RenegadeShadowMayor.AntiSpamData.SpellsToTrigger = 4
CombatStyles.RenegadeShadowMayor.AntiSpamData.TimeToAggroFor = 8
CombatStyles.RenegadeShadowMayor.OuterRingPercentAsRanged = 0.5
CombatStyles.RenegadeShadowMayor.ValidStates = {}
CombatStyles.RenegadeShadowMayor.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"HollowManSummonAllies",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeShadowMayor.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeShadowMayor.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeShadowMayor.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeShadowMayor.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.RenegadeShadowMayor.SummonerData = {}
CombatStyles.RenegadeShadowMayor.SummonerData.ChildrenToSpawn = 2
CombatStyles.RenegadeShadowMayor.SummonerData.ChildEntity = "CreatureShadowWolf"



-- uncomment for debug
-- GUI.DisplayMessageBox("renegadecombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end