
-- Guard --
CombatStyles.Guard = {}
CombatStyles.Guard.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.Guard.CanStrafe = true
CombatStyles.Guard.CanSheatheWeapon = true
CombatStyles.Guard.StrafeActionSpeed = 1
CombatStyles.Guard.Limits = {}
CombatStyles.Guard.Limits[CombatZones.Near] = 1.5
CombatStyles.Guard.Limits[CombatZones.Middle] = 2.5
CombatStyles.Guard.Limits[CombatZones.Far] = 4.5
CombatStyles.Guard.Limits[CombatZones.Left] = 2
CombatStyles.Guard.Limits[CombatZones.Right] = 2
CombatStyles.Guard.Limits[CombatZones.Rear] = 3
CombatStyles.Guard.FleeAnim = "Flee"
CombatStyles.Guard.FleeIntoAnim = "FleeInto"
CombatStyles.Guard.FleeOutOfAnim = "FleeOutOf"
CombatStyles.Guard.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.Guard.Sequences = {}
CombatStyles.Guard.Sequences[CombatSituations.Melee] = {
	"Advance",
	"GuardGettingShotResponse",
	"GuardOrbSuckingResponse",
	"GuardCloseAttack",
	"GuardAttack",
	"FastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.Guard.Sequences[CombatSituations.Ranged] = {
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.Guard.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack"
}
CombatStyles.Guard.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.Guard.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.Guard.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.Guard.MinSecondsBetweenRangedAttacks = 6
CombatStyles.Guard.CanStandOffAndShoot = "Aggressive"
CombatStyles.Guard.CanBlock = true
CombatStyles.Guard.BlockData = {}
CombatStyles.Guard.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.Guard.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Guard.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.Guard.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.Guard.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.Guard.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.Guard.BlockData.SecondsToBlockFor = 2
CombatStyles.Guard.CanEvadeShots = false
CombatStyles.Guard.EvadeShotsData = {}
CombatStyles.Guard.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.Guard.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.Guard.EvadeShotsData.HitsToStartEvading = 4
CombatStyles.Guard.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.Guard.AntiSpamData = {}
CombatStyles.Guard.AntiSpamData.TimeToCheckFor = 5
CombatStyles.Guard.AntiSpamData.ShotsToTrigger = 4
CombatStyles.Guard.AntiSpamData.SpellsToTrigger = 4
CombatStyles.Guard.AntiSpamData.TimeToAggroFor = 15
CombatStyles.Guard.OuterRingPercentAsRanged = 0.75
CombatStyles.Guard.ValidStates = {}
CombatStyles.Guard.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Guard.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.Guard.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Guard.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Guard.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Guard.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.Guard.ShootingBalanceData = {}
CombatStyles.Guard.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.Guard.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.Guard.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Guard Defensive --
CombatStyles.GuardDefensive = DeepCopyTable(CombatStyles.Guard)
CombatStyles.GuardDefensive.CanStandOffAndShoot = "Defensive"


-- Guard Turret --
CombatStyles.GuardTurret = DeepCopyTable(CombatStyles.Guard)
CombatStyles.GuardTurret.CanStandOffAndShoot = "Turret"
CombatStyles.GuardTurret.MinTimeToReturnToFiringPos = 20
CombatStyles.GuardTurret.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.GuardTurret.TurretBalanceData = {}
CombatStyles.GuardTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.GuardTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.GuardTurret.TurretBalanceData.NonTurretCombatStyle = "Guard"
CombatStyles.GuardTurret.Limits = {}
CombatStyles.GuardTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.GuardTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.GuardTurret.Limits[CombatZones.Far] = 4.5
CombatStyles.GuardTurret.Limits[CombatZones.Left] = 1
CombatStyles.GuardTurret.Limits[CombatZones.Right] = 1
CombatStyles.GuardTurret.Limits[CombatZones.Rear] = 1
CombatStyles.GuardTurret.Sequences = {}
CombatStyles.GuardTurret.Sequences[CombatSituations.Melee] = {
	"Advance",
	"GuardCloseAttack",
	"GuardAttack",
	"FastBackOff",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.GuardTurret.Sequences[CombatSituations.Ranged] = {
	"Idle",
	"FarIdle"
}
CombatStyles.GuardTurret.ValidStates = {}
CombatStyles.GuardTurret.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.GuardTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}


-- Guard Turret NoWait --
CombatStyles.GuardTurretNoWait = DeepCopyTable(CombatStyles.GuardTurret)
CombatStyles.GuardTurretNoWait.MoveToFiringPosNoWait = true


-- Guard Transient --
CombatStyles.GuardTransient = DeepCopyTable(CombatStyles.Guard)


-- Guard Elite --
CombatStyles.GuardElite = {}
CombatStyles.GuardElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.GuardElite.CanStrafe = true
CombatStyles.GuardElite.CanSheatheWeapon = true
CombatStyles.GuardElite.StrafeActionSpeed = 1
CombatStyles.GuardElite.Limits = {}
CombatStyles.GuardElite.Limits[CombatZones.Near] = 1.5
CombatStyles.GuardElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.GuardElite.Limits[CombatZones.Far] = 4.5
CombatStyles.GuardElite.Limits[CombatZones.Left] = 2
CombatStyles.GuardElite.Limits[CombatZones.Right] = 2
CombatStyles.GuardElite.Limits[CombatZones.Rear] = 3
CombatStyles.GuardElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.GuardElite.FleeAnim = "Flee"
CombatStyles.GuardElite.FleeIntoAnim = "FleeInto"
CombatStyles.GuardElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.GuardElite.Sequences = {}
CombatStyles.GuardElite.Sequences[CombatSituations.Melee] = {
	"Advance",
	"BanditInteruptSpellMelee",
	"GuardEliteOrbSuckingResponse",
	"GuardEliteCloseAttack",
	"GuardEliteAttack",
	"FastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.GuardElite.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.GuardElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack"
}
CombatStyles.GuardElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
    "SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.GuardElite.MinSecondsBetweenMeleeAttacks = 1.5
CombatStyles.GuardElite.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.GuardElite.MinSecondsBetweenRangedAttacks = 6
CombatStyles.GuardElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.GuardElite.CanBlock = true
CombatStyles.GuardElite.BlockData = {}
CombatStyles.GuardElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.GuardElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.GuardElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.GuardElite.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.GuardElite.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.GuardElite.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.GuardElite.BlockData.SecondsToBlockFor = 2
CombatStyles.GuardElite.CanEvadeShots = false
CombatStyles.GuardElite.EvadeShotsData = {}
CombatStyles.GuardElite.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.GuardElite.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.GuardElite.EvadeShotsData.HitsToStartEvading = 2
CombatStyles.GuardElite.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.GuardElite.AntiSpamData = {}
CombatStyles.GuardElite.AntiSpamData.TimeToCheckFor = 5
CombatStyles.GuardElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.GuardElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.GuardElite.AntiSpamData.TimeToAggroFor = 15
CombatStyles.GuardElite.OuterRingPercentAsRanged = 0.75
CombatStyles.GuardElite.ValidStates = {}
CombatStyles.GuardElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.GuardElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.GuardElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.GuardElite.ShootingBalanceData = {}
CombatStyles.GuardElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.GuardElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.GuardElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Guard Lieutenant --
CombatStyles.GuardLieutenant = {}
CombatStyles.GuardLieutenant.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.GuardLieutenant.CanStrafe = true
CombatStyles.GuardLieutenant.CanSheatheWeapon = true
CombatStyles.GuardLieutenant.PreferOuterRing = true
CombatStyles.GuardLieutenant.IsLeaderType = true
CombatStyles.GuardLieutenant.StrafeActionSpeed = 1
CombatStyles.GuardLieutenant.Limits = {}
CombatStyles.GuardLieutenant.Limits[CombatZones.Near] = 1.5
CombatStyles.GuardLieutenant.Limits[CombatZones.Middle] = 2.5
CombatStyles.GuardLieutenant.Limits[CombatZones.Far] = 4.5
CombatStyles.GuardLieutenant.Limits[CombatZones.Left] = 2
CombatStyles.GuardLieutenant.Limits[CombatZones.Right] = 2
CombatStyles.GuardLieutenant.Limits[CombatZones.Rear] = 3
CombatStyles.GuardLieutenant.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.GuardLieutenant.FleeAnim = "Flee"
CombatStyles.GuardLieutenant.FleeIntoAnim = "FleeInto"
CombatStyles.GuardLieutenant.FleeOutOfAnim = "FleeOutOf"
CombatStyles.GuardLieutenant.Sequences = {}
CombatStyles.GuardLieutenant.Sequences[CombatSituations.Melee] = {
	"Advance",
	"BanditLeaderInteruptSpellMelee",
	"GuardLieutenantCloseAttack",
	"GuardLieutenantAttack",
	"FastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.GuardLieutenant.Sequences[CombatSituations.Ranged] = {
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.GuardLieutenant.Sequences[CombatSituations.HardBlocking] = {
	"GuardLieutenantAttackOutOfBlockShort",
	"GuardLieutenantAttackOutOfBlock"
}
CombatStyles.GuardLieutenant.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
    "SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.GuardLieutenant.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.GuardLieutenant.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.GuardLieutenant.MinSecondsBetweenRangedAttacks = 5
CombatStyles.GuardLieutenant.CanStandOffAndShoot = "Aggressive"
CombatStyles.GuardLieutenant.CanBlock = true
CombatStyles.GuardLieutenant.BlockData = {}
CombatStyles.GuardLieutenant.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.GuardLieutenant.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.GuardLieutenant.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.GuardLieutenant.BlockData.SecondsToBlockFor = 2
CombatStyles.GuardLieutenant.CanEvadeShots = false
CombatStyles.GuardLieutenant.EvadeShotsData = {}
CombatStyles.GuardLieutenant.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.GuardLieutenant.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.GuardLieutenant.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.GuardLieutenant.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.GuardLieutenant.OuterRingPercentAsRanged = 0.75
CombatStyles.GuardLieutenant.AntiSpamData = {}
CombatStyles.GuardLieutenant.AntiSpamData.TimeToCheckFor = 5
CombatStyles.GuardLieutenant.AntiSpamData.ShotsToTrigger = 3
CombatStyles.GuardLieutenant.AntiSpamData.SpellsToTrigger = 3
CombatStyles.GuardLieutenant.AntiSpamData.TimeToAggroFor = 15
CombatStyles.GuardLieutenant.ValidStates = {}
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenant.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.GuardLieutenant.ShootingBalanceData = {}
CombatStyles.GuardLieutenant.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.GuardLieutenant.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.GuardLieutenant.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.GuardLieutenant.SecondsBetweenGroupActions = 30
CombatStyles.GuardLieutenant.PercentChanceThatGroupActionIsShoot = 25


-- Guard Lieutenant Elite --
CombatStyles.GuardLieutenantElite = {}
CombatStyles.GuardLieutenantElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.GuardLieutenantElite.CanStrafe = true
CombatStyles.GuardLieutenantElite.CanSheatheWeapon = true
CombatStyles.GuardLieutenantElite.PreferOuterRing = true
CombatStyles.GuardLieutenantElite.IsLeaderType = true
CombatStyles.GuardLieutenantElite.StrafeActionSpeed = 1
CombatStyles.GuardLieutenantElite.Limits = {}
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Near] = 1.5
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Far] = 4.5
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Left] = 2
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Right] = 2
CombatStyles.GuardLieutenantElite.Limits[CombatZones.Rear] = 3
CombatStyles.GuardLieutenantElite.FleeAnim = "Flee"
CombatStyles.GuardLieutenantElite.FleeIntoAnim = "FleeInto"
CombatStyles.GuardLieutenantElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.GuardLieutenantElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.GuardLieutenantElite.Sequences = {}
CombatStyles.GuardLieutenantElite.Sequences[CombatSituations.Melee] = {
	"Advance",
	"BanditLeaderInteruptSpellMelee",
	"BanditLeaderHeroFlourishResponse",
	"GuardLieutenantEliteOrbSuckingResponse",
	"GuardLieutenantEliteCloseAttack",
	"GuardLieutenantEliteAttack",
	"FastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.GuardLieutenantElite.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.GuardLieutenantElite.Sequences[CombatSituations.HardBlocking] = {
	"GuardLieutenantEliteAttackOutOfBlockShort",
	"GuardLieutenantEliteAttackOutOfBlock"
}
CombatStyles.GuardLieutenantElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.GuardLieutenantElite.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.GuardLieutenantElite.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.GuardLieutenantElite.MinSecondsBetweenRangedAttacks = 6
CombatStyles.GuardLieutenantElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.GuardLieutenantElite.CanBlock = true
CombatStyles.GuardLieutenantElite.BlockData = {}
CombatStyles.GuardLieutenantElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.GuardLieutenantElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.GuardLieutenantElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.GuardLieutenantElite.BlockData.SecondsToBlockFor = 2
CombatStyles.GuardLieutenantElite.CanEvadeShots = false
CombatStyles.GuardLieutenantElite.EvadeShotsData = {}
CombatStyles.GuardLieutenantElite.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.GuardLieutenantElite.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.GuardLieutenantElite.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.GuardLieutenantElite.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.GuardLieutenantElite.AntiSpamData = {}
CombatStyles.GuardLieutenantElite.AntiSpamData.TimeToCheckFor = 5
CombatStyles.GuardLieutenantElite.AntiSpamData.ShotsToTrigger = 3
CombatStyles.GuardLieutenantElite.AntiSpamData.SpellsToTrigger = 3
CombatStyles.GuardLieutenantElite.AntiSpamData.TimeToAggroFor = 15
CombatStyles.GuardLieutenantElite.OuterRingPercentAsRanged = 0.75
CombatStyles.GuardLieutenantElite.ValidStates = {}
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardLieutenantElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.GuardLieutenantElite.ShootingBalanceData = {}
CombatStyles.GuardLieutenantElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.GuardLieutenantElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.GuardLieutenantElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.GuardLieutenantElite.SecondsBetweenGroupActions = 30
CombatStyles.GuardLieutenantElite.PercentChanceThatGroupActionIsShoot = 25


-- Guard BodyGuard --
CombatStyles.GuardBodyGuard = {}
CombatStyles.GuardBodyGuard.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.GuardBodyGuard.CanStrafe = true
CombatStyles.GuardBodyGuard.CanSheatheWeapon = true
CombatStyles.GuardBodyGuard.PreferOuterRing = true
CombatStyles.GuardBodyGuard.IsLeaderType = true
CombatStyles.GuardBodyGuard.StrafeActionSpeed = 1
CombatStyles.GuardBodyGuard.Limits = {}
CombatStyles.GuardBodyGuard.Limits[CombatZones.Near] = 1.5
CombatStyles.GuardBodyGuard.Limits[CombatZones.Middle] = 2.5
CombatStyles.GuardBodyGuard.Limits[CombatZones.Far] = 4.5
CombatStyles.GuardBodyGuard.Limits[CombatZones.Left] = 2
CombatStyles.GuardBodyGuard.Limits[CombatZones.Right] = 2
CombatStyles.GuardBodyGuard.Limits[CombatZones.Rear] = 3
CombatStyles.GuardBodyGuard.FleeAnim = "Flee"
CombatStyles.GuardBodyGuard.FleeIntoAnim = "FleeInto"
CombatStyles.GuardBodyGuard.FleeOutOfAnim = "FleeOutOf"
CombatStyles.GuardBodyGuard.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.GuardBodyGuard.Sequences = {}
CombatStyles.GuardBodyGuard.Sequences[CombatSituations.Melee] = {
	"BanditLeaderInteruptSpellMelee",
	"BanditLeaderHeroFlourishResponse",
	"BanditLeaderOrbSuckingResponse",
	"GuardLieutenantEliteCloseAttack",
	"GuardLieutenantEliteAttack",
	"FastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.GuardBodyGuard.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.GuardBodyGuard.Sequences[CombatSituations.HardBlocking] = {
	"GuardLieutenantEliteAttackOutOfBlockShort",
	"GuardLieutenantEliteAttackOutOfBlock"
}
CombatStyles.GuardBodyGuard.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.GuardBodyGuard.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.GuardBodyGuard.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.GuardBodyGuard.MinSecondsBetweenRangedAttacks = 6
CombatStyles.GuardBodyGuard.CanStandOffAndShoot = "Aggressive"
CombatStyles.GuardBodyGuard.CanBlock = true
CombatStyles.GuardBodyGuard.BlockData = {}
CombatStyles.GuardBodyGuard.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.GuardBodyGuard.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.GuardBodyGuard.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.GuardBodyGuard.BlockData.SecondsToBlockFor = 3
CombatStyles.GuardBodyGuard.CanEvadeShots = false
CombatStyles.GuardBodyGuard.EvadeShotsData = {}
CombatStyles.GuardBodyGuard.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.GuardBodyGuard.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.GuardBodyGuard.EvadeShotsData.HitsToStartEvading = 2
CombatStyles.GuardBodyGuard.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.GuardBodyGuard.AntiSpamData = {}
CombatStyles.GuardBodyGuard.AntiSpamData.TimeToCheckFor = 5
CombatStyles.GuardBodyGuard.AntiSpamData.ShotsToTrigger = 3
CombatStyles.GuardBodyGuard.AntiSpamData.SpellsToTrigger = 2
CombatStyles.GuardBodyGuard.AntiSpamData.TimeToAggroFor = 15
CombatStyles.GuardBodyGuard.OuterRingPercentAsRanged = 0.75
CombatStyles.GuardBodyGuard.ValidStates = {}
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.GuardBodyGuard.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.GuardBodyGuard.ShootingBalanceData = {}
CombatStyles.GuardBodyGuard.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.GuardBodyGuard.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.GuardBodyGuard.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.GuardBodyGuard.SecondsBetweenGroupActions = 30
CombatStyles.GuardBodyGuard.PercentChanceThatGroupActionIsShoot = 25


-- Charles --
CombatStyles.Charles = DeepCopyTable(CombatStyles.GuardBodyGuard)
CombatStyles.Charles.RegroupWithHero = true
CombatStyles.Charles.RegroupWithHeroChaseRange = 15
CombatStyles.Charles.RegroupWithHeroPatrolRange = 15



-- uncomment for debug
-- GUI.DisplayMessageBox("guardcombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end

