
-- HobbeCloseAttackCombo --
CombatSequences.HobbeCloseAttackCombo = {}
CombatSequences.HobbeCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeCloseAttackCombo.IsCombo = true
CombatSequences.HobbeCloseAttackCombo.Zones = {}
CombatSequences.HobbeCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeAttackCombo --
CombatSequences.HobbeAttackCombo = {}
CombatSequences.HobbeAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeAttackCombo.IsCombo = true
CombatSequences.HobbeAttackCombo.Zones = {}
CombatSequences.HobbeAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatRoar",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeFarAttackCombo --
CombatSequences.HobbeFarAttackCombo = {}
CombatSequences.HobbeFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeFarAttackCombo.IsCombo = true
CombatSequences.HobbeFarAttackCombo.Zones = {}
CombatSequences.HobbeFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatJumpForward",
		FaceTarget = true,
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeLeftAttack --
CombatSequences.HobbeLeftAttack = {}
CombatSequences.HobbeLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeftAttack.Zones = {}
CombatSequences.HobbeLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.HobbeLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true
	}
}

-- HobbeRightAttack --
CombatSequences.HobbeRightAttack = {}
CombatSequences.HobbeRightAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeRightAttack.Zones = {}
CombatSequences.HobbeRightAttack.Zones[CombatZones.Right] = true
CombatSequences.HobbeRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendInTime = 0.3
	}
}

-- HobbeRearAttack --
CombatSequences.HobbeRearAttack = {}
CombatSequences.HobbeRearAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeRearAttack.Zones = {}
CombatSequences.HobbeRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.HobbeRearAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards",
		FaceTarget = false,
		AdditionalTurning = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight"
	}
}

-- HobbeHeroFlourishResponse --
CombatSequences.HobbeHeroFlourishResponse = {}
CombatSequences.HobbeHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.HobbeHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeHeroFlourishResponse.CounterAttack = true
CombatSequences.HobbeHeroFlourishResponse.Zones = {}
CombatSequences.HobbeHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeHeroFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatRoar",
		SpeedMultiplier = 1
	}
}

-- HobbeEliteCloseAttackCombo --
CombatSequences.HobbeEliteCloseAttackCombo = {}
CombatSequences.HobbeEliteCloseAttackCombo.IsCombo = true
CombatSequences.HobbeEliteCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeEliteCloseAttackCombo.Zones = {}
CombatSequences.HobbeEliteCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeEliteCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeEliteCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeEliteCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- HobbeEliteAttackCombo --
CombatSequences.HobbeEliteAttackCombo = {}
CombatSequences.HobbeEliteAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeEliteAttackCombo.IsCombo = true
CombatSequences.HobbeEliteAttackCombo.Zones = {}
CombatSequences.HobbeEliteAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeEliteAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeEliteAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeEliteAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeEliteAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatRoar",
		FaceTarget = true,
		SpeedMultiplier = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- HobbeEliteFarAttackCombo --
CombatSequences.HobbeEliteFarAttackCombo = {}
CombatSequences.HobbeEliteFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeEliteFarAttackCombo.IsCombo = true
CombatSequences.HobbeEliteFarAttackCombo.Zones = {}
CombatSequences.HobbeEliteFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeEliteFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeEliteFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatRoar",
		FaceTarget = true,
		SpeedMultiplier = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- HobbeEliteBerserk --
CombatSequences.HobbeEliteBerserk = {}
CombatSequences.HobbeEliteBerserk.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.HobbeEliteBerserk.Priority = SequencePriorities.Attack
CombatSequences.HobbeEliteBerserk.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeEliteBerserk.CounterAttack = true
CombatSequences.HobbeEliteBerserk.IsCombo = true
CombatSequences.HobbeEliteBerserk.Zones = {}
CombatSequences.HobbeEliteBerserk.Zones[CombatZones.Far] = true
CombatSequences.HobbeEliteBerserk.Zones[CombatZones.Middle] = true
CombatSequences.HobbeEliteBerserk.Zones[CombatZones.Near] = true
CombatSequences.HobbeEliteBerserk.ZonesWhilePlaying = {}
CombatSequences.HobbeEliteBerserk.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeEliteBerserk.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeEliteBerserk.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeEliteBerserk.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2
	}
}

-- EliteAdvance --
CombatSequences.EliteAdvance = {}
CombatSequences.EliteAdvance.Priority = SequencePriorities.Movement
CombatSequences.EliteAdvance.Zones = {}
CombatSequences.EliteAdvance.Zones[CombatZones.Far] = true
CombatSequences.EliteAdvance.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards",
		SpeedMultiplier = 1.5
	}
}

-- EliteBackOff --
CombatSequences.EliteBackOff = {}
CombatSequences.EliteBackOff.Priority = SequencePriorities.Movement
CombatSequences.EliteBackOff.Zones = {}
CombatSequences.EliteBackOff.Zones[CombatZones.Near] = true
CombatSequences.EliteBackOff.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards",
		SpeedMultiplier = 1.5
	}
}

-- HobbeEliteOrbSuckingResponse --
CombatSequences.HobbeEliteOrbSuckingResponse = {}
CombatSequences.HobbeEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeEliteOrbSuckingResponse.Zones = {}
CombatSequences.HobbeEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- HobbeLeaderCloseAttackCombo --
CombatSequences.HobbeLeaderCloseAttackCombo = {}
CombatSequences.HobbeLeaderCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderCloseAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderCloseAttackCombo.Zones = {}
CombatSequences.HobbeLeaderCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderCloseAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeLeaderAttackCombo --
CombatSequences.HobbeLeaderAttackCombo = {}
CombatSequences.HobbeLeaderAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderAttackCombo.Zones = {}
CombatSequences.HobbeLeaderAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeLeaderFarAttackCombo --
CombatSequences.HobbeLeaderFarAttackCombo = {}
CombatSequences.HobbeLeaderFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderFarAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderFarAttackCombo.Zones = {}
CombatSequences.HobbeLeaderFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeLeaderFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatRoar",
		FaceTarget = true,
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- HobbeLeaderFlourishLeft --
CombatSequences.HobbeLeaderFlourishLeft = {}
CombatSequences.HobbeLeaderFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderFlourishLeft.Zones = {}
CombatSequences.HobbeLeaderFlourishLeft.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderFlourishLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 0.8
	}
}

-- HobbeLeaderBlockBreaker --
CombatSequences.HobbeLeaderBlockBreaker = {}
CombatSequences.HobbeLeaderBlockBreaker.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderBlockBreaker.CounterAttack = true
CombatSequences.HobbeLeaderBlockBreaker.Zones = {}
CombatSequences.HobbeLeaderBlockBreaker.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderBlockBreaker.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderBlockBreaker.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderBlockBreaker.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderBlockBreaker.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderBlockBreaker.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatRoar",
		FaceTarget = true,
		SpeedMultiplier = 2.4,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 0.8
	}
}

-- HobbeLeaderOrbSuckingResponse --
CombatSequences.HobbeLeaderOrbSuckingResponse = {}
CombatSequences.HobbeLeaderOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeLeaderOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeLeaderOrbSuckingResponse.Zones = {}
CombatSequences.HobbeLeaderOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		IsComboBreak = true,
		SpeedMultiplier = 1
	}
}

-- HobbeLeaderEliteFlourishLeft --
CombatSequences.HobbeLeaderEliteFlourishLeft = {}
CombatSequences.HobbeLeaderEliteFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteFlourishLeft.Zones = {}
CombatSequences.HobbeLeaderEliteFlourishLeft.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteFlourishLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashShort",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 2.2
	}
}

-- HobbeLeaderEliteBerserk --
CombatSequences.HobbeLeaderEliteBerserk = {}
CombatSequences.HobbeLeaderEliteBerserk.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteBerserk.CounterAttack = true
CombatSequences.HobbeLeaderEliteBerserk.IsCombo = true
CombatSequences.HobbeLeaderEliteBerserk.Zones = {}
CombatSequences.HobbeLeaderEliteBerserk.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteBerserk.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteBerserk.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderEliteBerserk.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderEliteBerserk.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteBerserk.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteBerserk.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeLeaderEliteBerserk.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2.6,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- HobbeLeaderEliteCloseAttackCombo --
CombatSequences.HobbeLeaderEliteCloseAttackCombo = {}
CombatSequences.HobbeLeaderEliteCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteCloseAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderEliteCloseAttackCombo.Zones = {}
CombatSequences.HobbeLeaderEliteCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2.6,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- HobbeLeaderEliteAttackCombo --
CombatSequences.HobbeLeaderEliteAttackCombo = {}
CombatSequences.HobbeLeaderEliteAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderEliteAttackCombo.Zones = {}
CombatSequences.HobbeLeaderEliteAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderEliteAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2.6,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- HobbeLeaderEliteFarAttackCombo --
CombatSequences.HobbeLeaderEliteFarAttackCombo = {}
CombatSequences.HobbeLeaderEliteFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteFarAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderEliteFarAttackCombo.Zones = {}
CombatSequences.HobbeLeaderEliteFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderEliteFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeLeaderEliteFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	}
}

-- HobbeLeaderEliteOrbSuckingResponse --
CombatSequences.HobbeLeaderEliteOrbSuckingResponse = {}
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Zones = {}
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	}
}

-- HobbeCasterAntiSpamCounterAttackFar --
CombatSequences.HobbeCasterAntiSpamCounterAttackFar = {}
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(2)
	}
)
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.CounterAttack = true
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Zones = {}
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterAntiSpamCounterAttackFar.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterAntiSpamCounterAttackClose --
CombatSequences.HobbeCasterAntiSpamCounterAttackClose = {}
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsCloserThan(2)
	}
)
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.CounterAttack = true
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.Zones = {}
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterAntiSpamCounterAttackClose.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 0,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterRearAttack --
CombatSequences.HobbeCasterRearAttack = {}
CombatSequences.HobbeCasterRearAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterRearAttack.CounterAttack = true
CombatSequences.HobbeCasterRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterRearAttack.Zones = {}
CombatSequences.HobbeCasterRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.HobbeCasterRearAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 0,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterOrbSuckingResponse --
CombatSequences.HobbeCasterOrbSuckingResponse = {}
CombatSequences.HobbeCasterOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeCasterOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeCasterOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeCasterOrbSuckingResponse.Zones = {}
CombatSequences.HobbeCasterOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterOrbSuckingResponse.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 3.2,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterEliteAntiSpamCounterAttackFar --
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar = {}
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(2)
	}
)
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.CounterAttack = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Zones = {}
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackFar.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterEliteAntiSpamCounterAttackClose --
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose = {}
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsCloserThan(2)
	}
)
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.CounterAttack = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.Zones = {}
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterEliteAntiSpamCounterAttackClose.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterEliteRearAttack --
CombatSequences.HobbeCasterEliteRearAttack = {}
CombatSequences.HobbeCasterEliteRearAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterEliteRearAttack.CounterAttack = true
CombatSequences.HobbeCasterEliteRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeCasterEliteRearAttack.Zones = {}
CombatSequences.HobbeCasterEliteRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.HobbeCasterEliteRearAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 1.6,
		SpellType = ESpellType.SPELL_FIREBALL,
		SecondSpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	},
	{
		Type = EScriptableAction.OUTOF_AIM,
		SpeedMultiplier = 3
	}
}

-- HobbeCasterEliteOrbSuckingResponse --
CombatSequences.HobbeCasterEliteOrbSuckingResponse = {}
CombatSequences.HobbeCasterEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeCasterEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Zones = {}
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 3.2,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeSkeletonOrbSuckingResponse --
CombatSequences.HobbeSkeletonOrbSuckingResponse = {}
CombatSequences.HobbeSkeletonOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeSkeletonOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeSkeletonOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeSkeletonOrbSuckingResponse.Zones = {}
CombatSequences.HobbeSkeletonOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeSkeletonOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeSkeletonOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeSkeletonOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- HobbeSkeletonEliteOrbSuckingResponse --
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse = {}
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Zones = {}
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeSkeletonEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- HobbeCasterQO190AntiSpamCounterAttack --
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack = {}
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(1)
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.CounterAttack = true
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Zones = {}
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterQO190AntiSpamCounterAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 3.2,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeCasterQO190BlockBreaker --
CombatSequences.HobbeCasterQO190BlockBreaker = {}
CombatSequences.HobbeCasterQO190BlockBreaker.CounterAttack = true
CombatSequences.HobbeCasterQO190BlockBreaker.Priority = SequencePriorities.Attack
CombatSequences.HobbeCasterQO190BlockBreaker.Zones = {}
CombatSequences.HobbeCasterQO190BlockBreaker.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterQO190BlockBreaker.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterQO190BlockBreaker.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterQO190BlockBreaker.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterQO190BlockBreaker.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 3.2,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeCasterQO190InteruptSpell --
CombatSequences.HobbeCasterQO190InteruptSpell = {}
CombatSequences.HobbeCasterQO190InteruptSpell.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(2)
CombatSequences.HobbeCasterQO190InteruptSpell.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterQO190InteruptSpell.Zones = {}
CombatSequences.HobbeCasterQO190InteruptSpell.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterQO190InteruptSpell.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterQO190InteruptSpell.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterQO190InteruptSpell.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterQO190InteruptSpell.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 2.4,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		StopParticle = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeCasterQO190GettingShotResponse --
CombatSequences.HobbeCasterQO190GettingShotResponse = {}
CombatSequences.HobbeCasterQO190GettingShotResponse.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.HobbeCasterQO190GettingShotResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeCasterQO190GettingShotResponse.CounterAttack = true
CombatSequences.HobbeCasterQO190GettingShotResponse.Zones = {}
CombatSequences.HobbeCasterQO190GettingShotResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterQO190GettingShotResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterQO190GettingShotResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterQO190GettingShotResponse.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterQO190GettingShotResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 2.4,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		StopParticle = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeCasterQO190OrbSuckingResponse --
CombatSequences.HobbeCasterQO190OrbSuckingResponse = {}
CombatSequences.HobbeCasterQO190OrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeCasterQO190OrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Zones = {}
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeCasterQO190OrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "CasterCastFromHand",
		SpeedMultiplier = 2.4,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		StopParticle = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Dummy = "Character.Carry.Hand.Left"
	}
}

-- HobbeLeaderQO270FlourishLeft --
CombatSequences.HobbeLeaderQO270FlourishLeft = {}
CombatSequences.HobbeLeaderQO270FlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270FlourishLeft.Zones = {}
CombatSequences.HobbeLeaderQO270FlourishLeft.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270FlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270FlourishLeft.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatRoar",
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 1.25,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270Berserk --
CombatSequences.HobbeLeaderQO270Berserk = {}
CombatSequences.HobbeLeaderQO270Berserk.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270Berserk.CounterAttack = true
CombatSequences.HobbeLeaderQO270Berserk.IsCombo = true
CombatSequences.HobbeLeaderQO270Berserk.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeLeaderQO270Berserk.Zones = {}
CombatSequences.HobbeLeaderQO270Berserk.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270Berserk.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270Berserk.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270Berserk.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderQO270Berserk.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270Berserk.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270Berserk.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270Berserk.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.4,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.4,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.4,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.4,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270CloseAttackCombo --
CombatSequences.HobbeLeaderQO270CloseAttackCombo = {}
CombatSequences.HobbeLeaderQO270CloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270CloseAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderQO270CloseAttackCombo.Zones = {}
CombatSequences.HobbeLeaderQO270CloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270CloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270AttackCombo --
CombatSequences.HobbeLeaderQO270AttackCombo = {}
CombatSequences.HobbeLeaderQO270AttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270AttackCombo.IsCombo = true
CombatSequences.HobbeLeaderQO270AttackCombo.Zones = {}
CombatSequences.HobbeLeaderQO270AttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270AttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderQO270AttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270AttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270AttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "OverheadSmashLong",
		FaceTarget = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270FarAttackCombo --
CombatSequences.HobbeLeaderQO270FarAttackCombo = {}
CombatSequences.HobbeLeaderQO270FarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270FarAttackCombo.IsCombo = true
CombatSequences.HobbeLeaderQO270FarAttackCombo.Zones = {}
CombatSequences.HobbeLeaderQO270FarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270FarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeLeaderQO270FarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270FarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270FarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270FarAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		TurnPerMetre = 120,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.25,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270OrbSuckingResponse --
CombatSequences.HobbeLeaderQO270OrbSuckingResponse = {}
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.CounterAttack = true
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Zones = {}
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270OrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		TurnPerMetre = 120,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270InteruptSpell --
CombatSequences.HobbeLeaderQO270InteruptSpell = {}
CombatSequences.HobbeLeaderQO270InteruptSpell.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(2)
CombatSequences.HobbeLeaderQO270InteruptSpell.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeLeaderQO270InteruptSpell.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeLeaderQO270InteruptSpell.Zones = {}
CombatSequences.HobbeLeaderQO270InteruptSpell.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270InteruptSpell.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270InteruptSpell.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270InteruptSpell.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeLeaderQO270InteruptSpell.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		TurnPerMetre = 120,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270GettingShotTooMuch --
CombatSequences.HobbeLeaderQO270GettingShotTooMuch = {}
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.CounterAttack = true
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Zones = {}
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeLeaderQO270GettingShotTooMuch.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		TurnPerMetre = 120,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	}
}

-- HobbeLeaderQO270GettingMagicedTooMuch --
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch = {}
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Priority = SequencePriorities.PreferredAttack
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Zones = {}
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Zones[CombatZones.OuterRing] = true
CombatSequences.HobbeLeaderQO270GettingMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "CombatJumpForwardAttack",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		TurnPerMetre = 120,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		SpeedMultiplier = 1.3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingLeftAttack --
CombatSequences.HobbeKingLeftAttack = {}
CombatSequences.HobbeKingLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingLeftAttack.Zones = {}
CombatSequences.HobbeKingLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.HobbeKingLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 2.5,
		FaceTarget = false,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingRightAttack --
CombatSequences.HobbeKingRightAttack = {}
CombatSequences.HobbeKingRightAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingRightAttack.Zones = {}
CombatSequences.HobbeKingRightAttack.Zones[CombatZones.Right] = true
CombatSequences.HobbeKingRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2.5,
		FaceTarget = false,
		HitOutsideAttackArc = true,
		BlendInTime = 0.3
	}
}

-- HobbeKingRearAttack --
CombatSequences.HobbeKingRearAttack = {}
CombatSequences.HobbeKingRearAttack.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingRearAttack.Zones = {}
CombatSequences.HobbeKingRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.HobbeKingRearAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards",
		FaceTarget = false,
		AdditionalTurning = true,
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 3,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingRearAttackAlternate --
CombatSequences.HobbeKingRearAttackAlternate = {}
CombatSequences.HobbeKingRearAttackAlternate.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingRearAttackAlternate.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingRearAttackAlternate.Zones = {}
CombatSequences.HobbeKingRearAttackAlternate.Zones[CombatZones.Rear] = true
CombatSequences.HobbeKingRearAttackAlternate.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 3,
		AdditionalTurning = true,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingCloseAttackComboWithoutRoar --
CombatSequences.HobbeKingCloseAttackComboWithoutRoar = {}
CombatSequences.HobbeKingCloseAttackComboWithoutRoar.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingCloseAttackComboWithoutRoar.IsCombo = true
CombatSequences.HobbeKingCloseAttackComboWithoutRoar.Zones = {}
CombatSequences.HobbeKingCloseAttackComboWithoutRoar.Zones[CombatZones.Near] = true
CombatSequences.HobbeKingCloseAttackComboWithoutRoar.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2.5,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingAttackCombo --
CombatSequences.HobbeKingAttackCombo = {}
CombatSequences.HobbeKingAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingAttackCombo.IsCombo = true
CombatSequences.HobbeKingAttackCombo.Zones = {}
CombatSequences.HobbeKingAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeKingAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatRoar",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1.5,
		IsComboBreak = true,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2.5,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingAttackComboWithoutRoar --
CombatSequences.HobbeKingAttackComboWithoutRoar = {}
CombatSequences.HobbeKingAttackComboWithoutRoar.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingAttackComboWithoutRoar.IsCombo = true
CombatSequences.HobbeKingAttackComboWithoutRoar.Zones = {}
CombatSequences.HobbeKingAttackComboWithoutRoar.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackComboWithoutRoar.ZonesWhilePlaying = {}
CombatSequences.HobbeKingAttackComboWithoutRoar.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingAttackComboWithoutRoar.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackComboWithoutRoar.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1.5,
		IsComboBreak = true,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2.5,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingAttackSpinCombo --
CombatSequences.HobbeKingAttackSpinCombo = {}
CombatSequences.HobbeKingAttackSpinCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingAttackSpinCombo.IsCombo = true
CombatSequences.HobbeKingAttackSpinCombo.Zones = {}
CombatSequences.HobbeKingAttackSpinCombo.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackSpinCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeKingAttackSpinCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingAttackSpinCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingAttackSpinCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingAttackSpinCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		PushBackStrike = 1.5,
		SpeedMultiplier = 0.77
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 3,
		HitOutsideAttackArc = true
	}
}

-- HobbeKingCloseDistanceAndStrike --
CombatSequences.HobbeKingCloseDistanceAndStrike = {}
CombatSequences.HobbeKingCloseDistanceAndStrike.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingCloseDistanceAndStrike.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingCloseDistanceAndStrike.IsCombo = true
CombatSequences.HobbeKingCloseDistanceAndStrike.Zones = {}
CombatSequences.HobbeKingCloseDistanceAndStrike.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingCloseDistanceAndStrike.ZonesWhilePlaying = {}
CombatSequences.HobbeKingCloseDistanceAndStrike.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingCloseDistanceAndStrike.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingCloseDistanceAndStrike.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingCloseDistanceAndStrike.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpStrike",
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		PushBackStrike = 1.5
	}
}

-- HobbeKingCloseDistanceAndStrikeAlternate --
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate = {}
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.IsCombo = true
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.Zones = {}
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.ZonesWhilePlaying = {}
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingCloseDistanceAndStrikeAlternate.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpStrike",
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		PushBackStrike = 1.5,
		SpeedMultiplier = 0.77
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		PushBackStrike = 1.5
	}
}

-- HobbeKingRangedCounter --
CombatSequences.HobbeKingRangedCounter = {}
CombatSequences.HobbeKingRangedCounter.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(100, EAttackType.ATTACK_RANGED, 10)
CombatSequences.HobbeKingRangedCounter.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingRangedCounter.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingRangedCounter.IsCombo = true
CombatSequences.HobbeKingRangedCounter.Zones = {}
CombatSequences.HobbeKingRangedCounter.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingRangedCounter.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingRangedCounter.ZonesWhilePlaying = {}
CombatSequences.HobbeKingRangedCounter.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingRangedCounter.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingRangedCounter.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingRangedCounter.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpStrike",
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		PushBackStrike = 1.5
	}
}

-- HobbeKingSpellCounter --
CombatSequences.HobbeKingSpellCounter = {}
CombatSequences.HobbeKingRangedCounter.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(100, EAttackType.ATTACK_SPELL, 10)
CombatSequences.HobbeKingSpellCounter.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingSpellCounter.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingSpellCounter.IsCombo = true
CombatSequences.HobbeKingSpellCounter.Zones = {}
CombatSequences.HobbeKingSpellCounter.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingSpellCounter.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingSpellCounter.ZonesWhilePlaying = {}
CombatSequences.HobbeKingSpellCounter.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingSpellCounter.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingSpellCounter.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HobbeKingSpellCounter.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpStrike",
		FaceTargetAtStart = true,
		FaceTargetThroughout = true,
		PushBackStrike = 1.5
	}
}

-- HobbeKingBerserk --
CombatSequences.HobbeKingBerserk = {}
CombatSequences.HobbeKingBerserk.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.HobbeKingBerserk.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingBerserk.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HobbeKingBerserk.CounterAttack = true
CombatSequences.HobbeKingBerserk.Zones = {}
CombatSequences.HobbeKingBerserk.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingBerserk.Zones[CombatZones.Middle] = true
CombatSequences.HobbeKingBerserk.Zones[CombatZones.Near] = true
CombatSequences.HobbeKingBerserk.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 4
	}
}

-- HobbeKingCloseAttackCombo --
CombatSequences.HobbeKingCloseAttackCombo = {}
CombatSequences.HobbeKingCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingCloseAttackCombo.IsCombo = true
CombatSequences.HobbeKingCloseAttackCombo.Zones = {}
CombatSequences.HobbeKingCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HobbeKingCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatRoar",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2.5
	}
}

-- HobbeKingFarAttackCombo --
CombatSequences.HobbeKingFarAttackCombo = {}
CombatSequences.HobbeKingFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HobbeKingFarAttackCombo.IsCombo = true
CombatSequences.HobbeKingFarAttackCombo.Zones = {}
CombatSequences.HobbeKingFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HobbeKingFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HobbeKingFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HobbeKingFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HobbeKingFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "CombatRoar",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 2
	}
}



-- uncomment for debug
-- GUI.DisplayMessageBox("HobbeSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end