

-- Soldier --
CombatStyles.Soldier = {}
CombatStyles.Soldier.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.Soldier.CanStrafe = true
CombatStyles.Soldier.CanSheatheWeapon = true
CombatStyles.Soldier.StrafeActionSpeed = 1
CombatStyles.Soldier.Limits = {}
CombatStyles.Soldier.Limits[CombatZones.Near] = 1.5
CombatStyles.Soldier.Limits[CombatZones.Middle] = 2.5
CombatStyles.Soldier.Limits[CombatZones.Far] = 4.5
CombatStyles.Soldier.Limits[CombatZones.Left] = 2
CombatStyles.Soldier.Limits[CombatZones.Right] = 2
CombatStyles.Soldier.Limits[CombatZones.Rear] = 3
CombatStyles.Soldier.FleeAnim = "Flee"
CombatStyles.Soldier.FleeIntoAnim = "FleeInto"
CombatStyles.Soldier.FleeOutOfAnim = "FleeOutOf"
CombatStyles.Soldier.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.Soldier.Sequences = {}
CombatStyles.Soldier.Sequences[CombatSituations.Melee] = {
	"Idle"
}
CombatStyles.Soldier.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.Soldier.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting"
}
CombatStyles.Soldier.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.Soldier.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.Soldier.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.Soldier.MinSecondsBetweenRangedAttacks = 6
CombatStyles.Soldier.CanStandOffAndShoot = "Aggressive"
CombatStyles.Soldier.CanBlock = true
CombatStyles.Soldier.BlockData = {}
CombatStyles.Soldier.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.Soldier.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Soldier.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.Soldier.BlockData.MaxHitsToBlock = 5
CombatStyles.Soldier.BlockData.SecondsToBlockFor = 2
CombatStyles.Soldier.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.Soldier.CanEvadeShots = false
CombatStyles.Soldier.EvadeShotsData = {}
CombatStyles.Soldier.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.Soldier.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.Soldier.EvadeShotsData.HitsToStartEvading = 4
CombatStyles.Soldier.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.Soldier.AntiSpamData = {}
CombatStyles.Soldier.AntiSpamData.TimeToCheckFor = 5
CombatStyles.Soldier.AntiSpamData.ShotsToTrigger = 4
CombatStyles.Soldier.AntiSpamData.SpellsToTrigger = 4
CombatStyles.Soldier.AntiSpamData.TimeToAggroFor = 15
CombatStyles.Soldier.OuterRingPercentAsRanged = 0.75
CombatStyles.Soldier.ValidStates = {}
CombatStyles.Soldier.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Soldier.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.Soldier.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Soldier.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Soldier.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Soldier.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.Soldier.ShootingBalanceData = {}
CombatStyles.Soldier.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.Soldier.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.Soldier.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Soldier Turret --
CombatStyles.SoldierTurret = DeepCopyTable(CombatStyles.Soldier)
CombatStyles.SoldierTurret.CanStandOffAndShoot = "Turret"
CombatStyles.SoldierTurret.MinTimeToReturnToFiringPos = 20
CombatStyles.SoldierTurret.NonFormation = true
CombatStyles.SoldierTurret.TurretBalanceData = {}
CombatStyles.SoldierTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.SoldierTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.SoldierTurret.TurretBalanceData.NonTurretCombatStyle = "Soldier"
CombatStyles.SoldierTurret.Limits = {}
CombatStyles.SoldierTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.SoldierTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.SoldierTurret.Limits[CombatZones.Far] = 4.5
CombatStyles.SoldierTurret.Limits[CombatZones.Left] = 1
CombatStyles.SoldierTurret.Limits[CombatZones.Right] = 1
CombatStyles.SoldierTurret.Limits[CombatZones.Rear] = 1
CombatStyles.SoldierTurret.Sequences = {}
CombatStyles.SoldierTurret.Sequences[CombatSituations.Melee] = {
	"Advance",
	"GuardCloseAttack",
	"GuardAttack",
	"FastBackOff",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.SoldierTurret.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"Idle",
	"FarIdle"
}
CombatStyles.SoldierTurret.ValidStates = {}
CombatStyles.SoldierTurret.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"PlayCombatSequence",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.SoldierTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}


-- Soldier Turret NoWait --
CombatStyles.SoldierTurretNoWait = DeepCopyTable(CombatStyles.SoldierTurret)
CombatStyles.SoldierTurretNoWait.MoveToFiringPosNoWait = true


-- Soldier Town --
CombatStyles.TownSoldier = {}
CombatStyles.TownSoldier.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.TownSoldier.CanStrafe = true
CombatStyles.TownSoldier.CanSheatheWeapon = true
CombatStyles.TownSoldier.StrafeActionSpeed = 1
CombatStyles.TownSoldier.Limits = {}
CombatStyles.TownSoldier.Limits[CombatZones.Near] = 1.5
CombatStyles.TownSoldier.Limits[CombatZones.Middle] = 2.5
CombatStyles.TownSoldier.Limits[CombatZones.Far] = 4.5
CombatStyles.TownSoldier.Limits[CombatZones.Left] = 2
CombatStyles.TownSoldier.Limits[CombatZones.Right] = 2
CombatStyles.TownSoldier.Limits[CombatZones.Rear] = 3
CombatStyles.TownSoldier.FleeAnim = "Flee"
CombatStyles.TownSoldier.FleeIntoAnim = "FleeInto"
CombatStyles.TownSoldier.FleeOutOfAnim = "FleeOutOf"
CombatStyles.TownSoldier.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.TownSoldier.Sequences = {}
CombatStyles.TownSoldier.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.TownSoldier.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.TownSoldier.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack"
}
CombatStyles.TownSoldier.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.TownSoldier.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.TownSoldier.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.TownSoldier.MinSecondsBetweenRangedAttacks = 6
CombatStyles.TownSoldier.CanStandOffAndShoot = "Aggressive"
CombatStyles.TownSoldier.CanBlock = true
CombatStyles.TownSoldier.BlockData = {}
CombatStyles.TownSoldier.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.TownSoldier.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.TownSoldier.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.TownSoldier.BlockData.MaxHitsToBlock = 5
CombatStyles.TownSoldier.BlockData.SecondsToBlockFor = 2
CombatStyles.TownSoldier.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.TownSoldier.CanEvadeShots = false
CombatStyles.TownSoldier.EvadeShotsData = {}
CombatStyles.TownSoldier.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.TownSoldier.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.TownSoldier.EvadeShotsData.HitsToStartEvading = 4
CombatStyles.TownSoldier.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.TownSoldier.AntiSpamData = {}
CombatStyles.TownSoldier.AntiSpamData.TimeToCheckFor = 5
CombatStyles.TownSoldier.AntiSpamData.ShotsToTrigger = 4
CombatStyles.TownSoldier.AntiSpamData.SpellsToTrigger = 4
CombatStyles.TownSoldier.AntiSpamData.TimeToAggroFor = 15
CombatStyles.TownSoldier.OuterRingPercentAsRanged = 0.75
CombatStyles.TownSoldier.ValidStates = {}
CombatStyles.TownSoldier.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.TownSoldier.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.TownSoldier.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TownSoldier.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TownSoldier.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TownSoldier.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.TownSoldier.ShootingBalanceData = {}
CombatStyles.TownSoldier.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.TownSoldier.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.1
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.TownSoldier.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Soldier Elite --
CombatStyles.SoldierElite = {}
CombatStyles.SoldierElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.SoldierElite.CanStrafe = true
CombatStyles.SoldierElite.CanSheatheWeapon = true
CombatStyles.SoldierElite.StrafeActionSpeed = 1
CombatStyles.SoldierElite.Limits = {}
CombatStyles.SoldierElite.Limits[CombatZones.Near] = 1.5
CombatStyles.SoldierElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.SoldierElite.Limits[CombatZones.Far] = 4.5
CombatStyles.SoldierElite.Limits[CombatZones.Left] = 2
CombatStyles.SoldierElite.Limits[CombatZones.Right] = 2
CombatStyles.SoldierElite.Limits[CombatZones.Rear] = 3
CombatStyles.SoldierElite.FleeAnim = "Flee"
CombatStyles.SoldierElite.FleeIntoAnim = "FleeInto"
CombatStyles.SoldierElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.SoldierElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.SoldierElite.Sequences = {}
CombatStyles.SoldierElite.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditEliteFastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Idle"
}
CombatStyles.SoldierElite.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditLeaderInteruptSpellRanged",
	"FastBackOff",
	"RangedIdle"
}
CombatStyles.SoldierElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting"
}
CombatStyles.SoldierElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.SoldierElite.MinSecondsBetweenMeleeAttacks = 1.5
CombatStyles.SoldierElite.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.SoldierElite.MinSecondsBetweenRangedAttacks = 6
CombatStyles.SoldierElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.SoldierElite.CanBlock = true
CombatStyles.SoldierElite.BlockData = {}
CombatStyles.SoldierElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.SoldierElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.SoldierElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.SoldierElite.BlockData.SecondsToBlockFor = 2
CombatStyles.SoldierElite.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.SoldierElite.CanEvadeShots = false
CombatStyles.SoldierElite.EvadeShotsData = {}
CombatStyles.SoldierElite.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.SoldierElite.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.SoldierElite.EvadeShotsData.HitsToStartEvading = 2
CombatStyles.SoldierElite.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.SoldierElite.AntiSpamData = {}
CombatStyles.SoldierElite.AntiSpamData.TimeToCheckFor = 5
CombatStyles.SoldierElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.SoldierElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.SoldierElite.AntiSpamData.TimeToAggroFor = 15
CombatStyles.SoldierElite.OuterRingPercentAsRanged = 0.75
CombatStyles.SoldierElite.ValidStates = {}
CombatStyles.SoldierElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"LaughAtKnockdown",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.SoldierElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"RetreatFromSpellCharging",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.SoldierElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SoldierElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SoldierElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.SoldierElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.SoldierElite.ShootingBalanceData = {}
CombatStyles.SoldierElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.SoldierElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.12
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.SoldierElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Soldier Elite Turret --
CombatStyles.SoldierEliteTurret = DeepCopyTable(CombatStyles.SoldierElite)
CombatStyles.SoldierEliteTurret.CanStandOffAndShoot = "Turret"
CombatStyles.SoldierEliteTurret.MinTimeToReturnToFiringPos = 20
CombatStyles.SoldierEliteTurret.NonFormation = true
CombatStyles.SoldierEliteTurret.TurretBalanceData = {}
CombatStyles.SoldierEliteTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.SoldierEliteTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.SoldierEliteTurret.TurretBalanceData.NonTurretCombatStyle = "SoldierElite"
CombatStyles.SoldierEliteTurret.Limits = {}
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Far] = 4.5
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Left] = 1
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Right] = 1
CombatStyles.SoldierEliteTurret.Limits[CombatZones.Rear] = 1
CombatStyles.SoldierEliteTurret.Sequences = {}
CombatStyles.SoldierEliteTurret.Sequences[CombatSituations.Melee] = {
	"Advance",
	"GuardCloseAttack",
	"GuardAttack",
	"FastBackOff",
	"BanditOuterGoad",
	"Idle"
}
CombatStyles.SoldierEliteTurret.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"Idle",
	"FarIdle"
}
CombatStyles.SoldierEliteTurret.ValidStates = {}
CombatStyles.SoldierEliteTurret.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"PlayCombatSequence",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.SoldierEliteTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"TurretCheckTargetProximity",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}


-- Soldier Turret Elite NoWait --
CombatStyles.SoldierTurretEliteNoWait = DeepCopyTable(CombatStyles.SoldierEliteTurret)
CombatStyles.SoldierTurretEliteNoWait.MoveToFiringPosNoWait = true



-- uncomment for debug
-- GUI.DisplayMessageBox("soldiercombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end