
-- Shadow Balverine --
CombatStyles.ShadowBalverine = {}
CombatStyles.ShadowBalverine.CombatGroupType = CombatGroupTypes.BalverineLike
CombatStyles.ShadowBalverine.CanStrafe = true
CombatStyles.ShadowBalverine.CanFightUnarmed = true
CombatStyles.ShadowBalverine.PreferredRange = 1.7
CombatStyles.ShadowBalverine.StrafeActionTurnPerMetre = 60
CombatStyles.ShadowBalverine.EnterStrafeDist = 5
CombatStyles.ShadowBalverine.LeaveStrafeDelta = 2
CombatStyles.ShadowBalverine.BalverineJumpDist = 1.5
CombatStyles.ShadowBalverine.BalverineBoundAttackDistance = 7
CombatStyles.ShadowBalverine.BalverinePercentChanceOfJumpingBackToBoundDistance = 10
CombatStyles.ShadowBalverine.SecondsBetweenBounds = 4
CombatStyles.ShadowBalverine.SecondsBetweenJumps = 1
CombatStyles.ShadowBalverine.ActionModifiers = {}
CombatStyles.ShadowBalverine.ActionModifiers.MinDistToTarget = 1
CombatStyles.ShadowBalverine.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.ShadowBalverine.MinSecondsBetweenMeleeAttacks = 1.5
CombatStyles.ShadowBalverine.Limits = {}
CombatStyles.ShadowBalverine.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowBalverine.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowBalverine.Limits[CombatZones.Far] = 3
CombatStyles.ShadowBalverine.Limits[CombatZones.Left] = 2.5
CombatStyles.ShadowBalverine.Limits[CombatZones.Right] = 2.5
CombatStyles.ShadowBalverine.Limits[CombatZones.Rear] = 2.5
CombatStyles.ShadowBalverine.Sequences = {}
CombatStyles.ShadowBalverine.Sequences[CombatSituations.Melee] = {
	"BalverineBloodedHeroFlourishResponse",
	"BalverineBloodedShotCausedClaw",
	"BalverineBloodedMagicedCausedClaw",
	{"BalverineBloodedFrenzy", 4},
	{"BalverineBloodedFrenzyLowHealth", 3},
	"BalverineBloodedOrbSuckingResponse",
    "BalverineBloodedPostJumpCombo",
    "BalverineBloodedCloseCombo",
    "BalverineBloodedCombo",
	{"IdleStrafe", 3},
	{"IdleStrafeLeft", 3},
	{"IdleStrafeRight", 3},
	"BalverineLeftAttack",
	"BalverineRightAttack",
	"BalverineRearAttack",
	"BackOff"
}
CombatStyles.ShadowBalverine.Sequences[CombatSituations.Dodging] = {
	"BalverineBloodedAttackAfterDodge"
}
CombatStyles.ShadowBalverine.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowBalverine.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowBalverine.LaughAtKnockdownAnim = "Howl"
CombatStyles.ShadowBalverine.RunIntoAttack = "BoundAttack"
CombatStyles.ShadowBalverine.DoRunIntoStrafe = true
CombatStyles.ShadowBalverine.ValidStates = {}
CombatStyles.ShadowBalverine.ValidStates[CombatSituations.Melee] = {
	"LaughAtKnockdown",
	"BalverineCircle",
	"BalverineJump",
	"BalverineBoundAttack",
	"BalverineChase",
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"NonFormationSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowBalverine.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBalverine.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates

-- Shadow Dervish --
CombatStyles.ShadowDervish = {}
CombatStyles.ShadowDervish.CombatGroupType = CombatGroupTypes.HighwaymanLike
CombatStyles.ShadowDervish.CanStrafe = true
CombatStyles.ShadowDervish.CanSheatheWeapon = false
CombatStyles.ShadowDervish.NonFormation = true
CombatStyles.ShadowDervish.MovementTolerance = 0.45
CombatStyles.ShadowDervish.PreferredRange = 1.5
CombatStyles.ShadowDervish.Limits = {}
CombatStyles.ShadowDervish.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowDervish.Limits[CombatZones.Middle] = 2
CombatStyles.ShadowDervish.Limits[CombatZones.Far] = 3
CombatStyles.ShadowDervish.Limits[CombatZones.Left] = 2
CombatStyles.ShadowDervish.Limits[CombatZones.Right] = 2
CombatStyles.ShadowDervish.Limits[CombatZones.Rear] = 2.5
CombatStyles.ShadowDervish.StrafeActionSpeed = 1
CombatStyles.ShadowDervish.EnterStrafeDist = 5
CombatStyles.ShadowDervish.LeaveStrafeDelta = 2
CombatStyles.ShadowDervish.FleeAnim = "Flee"
CombatStyles.ShadowDervish.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowDervish.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowDervish.Sequences = {}
CombatStyles.ShadowDervish.Sequences[CombatSituations.Melee] = {
	"ShadowSpellChargeResponse",
	"HighwaymanAttackCombo",
	"HighwaymanCloseAttackCombo",
	"HighwaymanIdleStrafeLeft",
	"HighwaymanIdleStrafeRight",
	"HighwaymanLeftAttack",
	"HighwaymanRightAttack",
	"HighwaymanRearAttack",
	"Idle"
}
CombatStyles.ShadowDervish.Sequences[CombatSituations.Dodging] = {}
CombatStyles.ShadowDervish.Sequences[CombatSituations.GroupOrders] = {
	"HighwaymanAttackCombo",
	"HighwaymanStrikeThenRoll"
}
CombatStyles.ShadowDervish.RunIntoAttack = "RunIntoAttack"
CombatStyles.ShadowDervish.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowDervish.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowDervish.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.ShadowDervish.CanBlock = false
CombatStyles.ShadowDervish.ValidStates = {}
CombatStyles.ShadowDervish.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"NonFormationSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowDervish.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowDervish.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowDervish.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowDervish.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Shadow Hobbe --
CombatStyles.ShadowHobbe = {}
CombatStyles.ShadowHobbe.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.ShadowHobbe.CanStrafe = true
CombatStyles.ShadowHobbe.NonFormation = true
CombatStyles.ShadowHobbe.EnterStrafeDist = 7.5
CombatStyles.ShadowHobbe.PreferredRange = 1.5
CombatStyles.ShadowHobbe.ActionModifiers = {}
CombatStyles.ShadowHobbe.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.ShadowHobbe.CanSheatheWeapon = true
CombatStyles.ShadowHobbe.Limits = {}
CombatStyles.ShadowHobbe.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowHobbe.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowHobbe.Limits[CombatZones.Far] = 3
CombatStyles.ShadowHobbe.Limits[CombatZones.Left] = 1
CombatStyles.ShadowHobbe.Limits[CombatZones.Right] = 1
CombatStyles.ShadowHobbe.Limits[CombatZones.Rear] = 1
CombatStyles.ShadowHobbe.DoSpotTargetAnim = true
CombatStyles.ShadowHobbe.CanFlee = true
CombatStyles.ShadowHobbe.FleeAnim = "Flee"
CombatStyles.ShadowHobbe.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowHobbe.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.ShadowHobbe.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.ShadowHobbe.SecondsToWaitAfterTargetIsHit = 6
CombatStyles.ShadowHobbe.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowHobbe.Enrage = {}
CombatStyles.ShadowHobbe.Enrage.Anim = "CombatRoar"
CombatStyles.ShadowHobbe.Enrage.DamageMultiplier = 1.1
CombatStyles.ShadowHobbe.Enrage.SpeedMultiplier = 1.2
CombatStyles.ShadowHobbe.Enrage.Duration = 5
CombatStyles.ShadowHobbe.Sequences = {}
CombatStyles.ShadowHobbe.Sequences[CombatSituations.Melee] = {
	"HobbeAttackCombo",
	"HobbeCloseAttackCombo",
	"HobbeFarAttackCombo",
	"Idle",
	"IdleStrafe",
	"IdleLong",
	"Advance",
	"BackOff"
}
CombatStyles.ShadowHobbe.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.ShadowHobbe.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.ShadowHobbe.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Shadow Renegade --
CombatStyles.ShadowRenegade = {}
CombatStyles.ShadowRenegade.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowRenegade.CanStrafe = true
CombatStyles.ShadowRenegade.NonFormation = true
CombatStyles.ShadowRenegade.DesiredRange = 1.5
CombatStyles.ShadowRenegade.StrafeActionSpeed = 1
CombatStyles.ShadowRenegade.EnterRangedStrafeDist = 10
CombatStyles.ShadowRenegade.CanSheatheWeapon = true
CombatStyles.ShadowRenegade.Limits = {}
CombatStyles.ShadowRenegade.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowRenegade.Limits[CombatZones.Middle] = 2
CombatStyles.ShadowRenegade.Limits[CombatZones.Far] = 3
CombatStyles.ShadowRenegade.Limits[CombatZones.Left] = 2
CombatStyles.ShadowRenegade.Limits[CombatZones.Right] = 2
CombatStyles.ShadowRenegade.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowRenegade.CanFlee = false
CombatStyles.ShadowRenegade.FleeAnim = "Flee"
CombatStyles.ShadowRenegade.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowRenegade.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowRenegade.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.ShadowRenegade.Sequences = {}
CombatStyles.ShadowRenegade.Sequences[CombatSituations.Melee] = {
	"ShadowSpellChargeResponse",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"Idle",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.ShadowRenegade.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.ShadowRenegade.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.ShadowRenegade.MinSecondsBetweenRangedAttacks = 7
CombatStyles.ShadowRenegade.ValidStates = {}
CombatStyles.ShadowRenegade.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"NonFormationSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowRenegade.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowRenegade.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowRenegade.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowRenegade.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Shadow Wolf --
CombatStyles.ShadowWolf = {}
CombatStyles.ShadowWolf.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.ShadowWolf.SecondsToWaitAfterTargetIsHit = 7
CombatStyles.ShadowWolf.SecondsToWaitAfterTargetIsAttacked = 3
CombatStyles.ShadowWolf.CanStrafe = false
CombatStyles.ShadowWolf.NonFormation = true
CombatStyles.ShadowWolf.CanFightUnarmed = true
CombatStyles.ShadowWolf.IsWolf = true
CombatStyles.ShadowWolf.WolfPreferredRange = 2.5
CombatStyles.ShadowWolf.WolfMaxCircleRange = 6
CombatStyles.ShadowWolf.PreferredRange = 0
CombatStyles.ShadowWolf.TurnToFaceTolerance = 180
CombatStyles.ShadowWolf.Limits = {}
CombatStyles.ShadowWolf.Limits[CombatZones.Near] = 2
CombatStyles.ShadowWolf.Limits[CombatZones.Middle] = 3
CombatStyles.ShadowWolf.Limits[CombatZones.Far] = 5
CombatStyles.ShadowWolf.Limits[CombatZones.Left] = 4
CombatStyles.ShadowWolf.Limits[CombatZones.Right] = 4
CombatStyles.ShadowWolf.Limits[CombatZones.Rear] = 1
CombatStyles.ShadowWolf.Sequences = {}
CombatStyles.ShadowWolf.Sequences[CombatSituations.Melee] = {}
CombatStyles.ShadowWolf.ValidStates = {}
CombatStyles.ShadowWolf.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"WolfAttack",
	"WolfCircle"
}


-- Shadow Beetle Melee
CombatStyles.ShadowBeetleMelee = {}
CombatStyles.ShadowBeetleMelee.CombatGroupType = CombatGroupTypes.BeetleLike
CombatStyles.ShadowBeetleMelee.NonFormation = true
CombatStyles.ShadowBeetleMelee.PreferredRange = 2.3
CombatStyles.ShadowBeetleMelee.CanFightUnarmed = true
CombatStyles.ShadowBeetleMelee.Limits = {}
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Near] = 1.8
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Middle] = 2.7
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Far] = 5
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Left] = 1
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Right] = 1
CombatStyles.ShadowBeetleMelee.Limits[CombatZones.Rear] = 1
CombatStyles.ShadowBeetleMelee.Sequences = {}
CombatStyles.ShadowBeetleMelee.Sequences[CombatSituations.Melee] = {
	"IdleLong",
	"BeetleAttack",
	"BeetleCloseAttack",
	"BeetleTakeOffAtFar",
	"BeetleLandWhenOutOfRange"
}
CombatStyles.ShadowBeetleMelee.MinSecondsBetweenMeleeAttacks = 6
CombatStyles.ShadowBeetleMelee.ValidStates = {}
CombatStyles.ShadowBeetleMelee.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"BeetleAdjustAltitude",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}


-- Shadow Beetle Hugger --
CombatStyles.ShadowBeetleHugger = {}
CombatStyles.ShadowBeetleHugger.CombatGroupType = CombatGroupTypes.BeetleLike
CombatStyles.ShadowBeetleHugger.NonFormation = true
CombatStyles.ShadowBeetleHugger.CanFightUnarmed = true
CombatStyles.ShadowBeetleHugger.Limits = {}
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Near] = 1.1
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Middle] = 1.75
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Far] = 8
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Left] = 1
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Right] = 1
CombatStyles.ShadowBeetleHugger.Limits[CombatZones.Rear] = 1
CombatStyles.ShadowBeetleHugger.Sequences = {}
CombatStyles.ShadowBeetleHugger.Sequences[CombatSituations.Melee] = {
	"IdleLong",
	"BeetleAttack",
	"BeetleCloseAttack",
	"BeetleTakeOffAtFar",
	"BeetleLandWhenOutOfRange"
}
CombatStyles.ShadowBeetleHugger.MinSecondsBetweenMeleeAttacks = 3.5
CombatStyles.ShadowBeetleHugger.MinSecondsBetweenRangedAttacks = 5
CombatStyles.ShadowBeetleHugger.ValidStates = {}
CombatStyles.ShadowBeetleHugger.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"BeetleAdjustAltitude",
	"BeetleHug",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowBeetleHugger.HugBalancing = {}
CombatStyles.ShadowBeetleHugger.HugBalancing.DamagePerSecondWhileHugging = -3
CombatStyles.ShadowBeetleHugger.HugBalancing.TimeBetweenBeetleHugs = 5.5
CombatStyles.ShadowBeetleHugger.HugBalancing.TimeSpentHugging = 2.8
CombatStyles.ShadowBeetleHugger.HugBalancing.HugTimeReductionWhenButtonBashing = 1.8


-- Shadow Beetle Spitter --
CombatStyles.ShadowBeetleSpitter = {}
CombatStyles.ShadowBeetleSpitter.CombatGroupType = CombatGroupTypes.BeetleLike
CombatStyles.ShadowBeetleSpitter.NonFormation = true
CombatStyles.ShadowBeetleSpitter.TurnToFaceTolerance = 20
CombatStyles.ShadowBeetleSpitter.CanFightUnarmed = true
CombatStyles.ShadowBeetleSpitter.Limits = {}
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Middle] = 2
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Far] = 8
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Left] = 1
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Right] = 1
CombatStyles.ShadowBeetleSpitter.Limits[CombatZones.Rear] = 1
CombatStyles.ShadowBeetleSpitter.Sequences = {}
CombatStyles.ShadowBeetleSpitter.Sequences[CombatSituations.Melee] = {
	"IdleLong",
	"BeetleAttack",
	"BeetleCloseAttack",
	"BeetleTakeOffOnlyWhenClose",
	"BeetleLandAtFar"
}
CombatStyles.ShadowBeetleSpitter.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.ShadowBeetleSpitter.MinSecondsBetweenRangedAttacks = 7
CombatStyles.ShadowBeetleSpitter.ValidStates = {}
CombatStyles.ShadowBeetleSpitter.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"BeetleAdjustAltitude",
	"BeetleSpit",
	"PlayCombatSequence",
	"NonFormationKeepDistanceMovement",
	"FaceTarget"
}
CombatStyles.ShadowBeetleSpitter.SpitDamage = 5


-- Shadow Bandit Easy --
CombatStyles.ShadowBanditEasy = {}
CombatStyles.ShadowBanditEasy.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowBanditEasy.CanStrafe = true
CombatStyles.ShadowBanditEasy.DoRunIntoStrafe = true
CombatStyles.ShadowBanditEasy.DesiredRange = 4
CombatStyles.ShadowBanditEasy.StrafeActionSpeed = 1
CombatStyles.ShadowBanditEasy.EnterRangedStrafeDist = 10
CombatStyles.ShadowBanditEasy.CanSheatheWeapon = true
CombatStyles.ShadowBanditEasy.Limits = {}
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Left] = 2
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Right] = 2
CombatStyles.ShadowBanditEasy.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowBanditEasy.CanFlee = true
CombatStyles.ShadowBanditEasy.FleeAnim = "Flee"
CombatStyles.ShadowBanditEasy.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowBanditEasy.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowBanditEasy.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.ShadowBanditEasy.Sequences = {}
CombatStyles.ShadowBanditEasy.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditFastBackOff",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.ShadowBanditEasy.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.ShadowBanditEasy.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.ShadowBanditEasy.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.ShadowBanditEasy.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowBanditEasy.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowBanditEasy.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowBanditEasy.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowBanditEasy.CanBlock = true
CombatStyles.ShadowBanditEasy.BlockData = {}
CombatStyles.ShadowBanditEasy.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowBanditEasy.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowBanditEasy.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowBanditEasy.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowBanditEasy.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowBanditEasy.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowBanditEasy.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowBanditEasy.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowBanditEasy.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowBanditEasy.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowBanditEasy.TimeToBlockFor = 1.5
CombatStyles.ShadowBanditEasy.OuterRingPercentAsRanged = 0.5
CombatStyles.ShadowBanditEasy.ValidStates = {}
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBanditEasy.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowBanditEasy.ShootingBalanceData = {}
CombatStyles.ShadowBanditEasy.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowBanditEasy.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowBanditEasy.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Shadow Bandit --
CombatStyles.ShadowBandit = {}
CombatStyles.ShadowBandit.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowBandit.CanStrafe = true
CombatStyles.ShadowBandit.DoRunIntoStrafe = true
CombatStyles.ShadowBandit.DesiredRange = 4
CombatStyles.ShadowBandit.StrafeActionSpeed = 1
CombatStyles.ShadowBandit.EnterRangedStrafeDist = 10
CombatStyles.ShadowBandit.CanSheatheWeapon = true
CombatStyles.ShadowBandit.Limits = {}
CombatStyles.ShadowBandit.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowBandit.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowBandit.Limits[CombatZones.Far] = 4.5
CombatStyles.ShadowBandit.Limits[CombatZones.Left] = 2
CombatStyles.ShadowBandit.Limits[CombatZones.Right] = 2
CombatStyles.ShadowBandit.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowBandit.CanFlee = true
CombatStyles.ShadowBandit.FleeAnim = "Flee"
CombatStyles.ShadowBandit.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowBandit.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowBandit.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.ShadowBandit.Sequences = {}
CombatStyles.ShadowBandit.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditFastBackOff",
	"BanditHeroFlourishResponse",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.ShadowBandit.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.ShadowBandit.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.ShadowBandit.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
    "SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.ShadowBandit.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowBandit.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowBandit.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowBandit.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowBandit.CanBlock = true
CombatStyles.ShadowBandit.BlockData = {}
CombatStyles.ShadowBandit.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowBandit.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowBandit.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.ShadowBandit.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowBandit.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowBandit.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowBandit.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowBandit.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowBandit.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowBandit.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowBandit.TimeToBlockFor = 1.5
CombatStyles.ShadowBandit.AntiSpamData = {}
CombatStyles.ShadowBandit.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowBandit.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowBandit.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowBandit.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowBandit.OuterRingPercentAsRanged = 0.5
CombatStyles.ShadowBandit.ValidStates = {}
CombatStyles.ShadowBandit.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowBandit.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.ShadowBandit.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBandit.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBandit.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowBandit.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowBandit.ShootingBalanceData = {}
CombatStyles.ShadowBandit.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowBandit.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowBandit.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05



-- Shadow Highwayman --
CombatStyles.ShadowHighwayman = {}
CombatStyles.ShadowHighwayman.CombatGroupType = CombatGroupTypes.HighwaymanLike
CombatStyles.ShadowHighwayman.CanStrafe = true
CombatStyles.ShadowHighwayman.CanSheatheWeapon = false
CombatStyles.ShadowHighwayman.MovementTolerance = 0.45
CombatStyles.ShadowHighwayman.Limits = {}
CombatStyles.ShadowHighwayman.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowHighwayman.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowHighwayman.Limits[CombatZones.Far] = 5
CombatStyles.ShadowHighwayman.Limits[CombatZones.Left] = 2
CombatStyles.ShadowHighwayman.Limits[CombatZones.Right] = 2
CombatStyles.ShadowHighwayman.Limits[CombatZones.Rear] = 2.5
CombatStyles.ShadowHighwayman.StrafeActionSpeed = 1
CombatStyles.ShadowHighwayman.EnterStrafeDist = 5
CombatStyles.ShadowHighwayman.LeaveStrafeDelta = 2
CombatStyles.ShadowHighwayman.FleeAnim = "Flee"
CombatStyles.ShadowHighwayman.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowHighwayman.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowHighwayman.Sequences = {}
CombatStyles.ShadowHighwayman.Sequences[CombatSituations.Melee] = {
	"HighwaymanGetRidOfPistol",
	"HighwaymanShotTooMuch",
	"HighwaymanOrbSuckingResponse",
	"HighwaymanFarAttackCombo",
	"HighwaymanAttackCombo",
	"HighwaymanCloseAttackCombo",
	"HighwaymanRollBack",
	"HighwaymanGoad",
	"HighwaymanIdleStrafeLeft",
	"HighwaymanIdleStrafeRight",
	"HighwaymanLeftAttack",
	"HighwaymanRightAttack",
	"HighwaymanRearAttack",
	"Idle"
}
CombatStyles.ShadowHighwayman.Sequences[CombatSituations.Dodging] = {
	"HighwaymanRollBackShooting"
}
CombatStyles.ShadowHighwayman.Sequences[CombatSituations.GroupOrders] = {
	"HighwaymanGroupShooting",
	"HighwaymanAttackCombo",
	"HighwaymanStrikeThenRoll"
}
CombatStyles.ShadowHighwayman.RunIntoAttack = "RunIntoAttack"
CombatStyles.ShadowHighwayman.MinSecondsBetweenMeleeAttacks = 2.5
CombatStyles.ShadowHighwayman.SecondsToWaitAfterTargetIsHit = 3.5
CombatStyles.ShadowHighwayman.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowHighwayman.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.ShadowHighwayman.CanBlock = true
CombatStyles.ShadowHighwayman.BlockData = {}
CombatStyles.ShadowHighwayman.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowHighwayman.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowHighwayman.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowHighwayman.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowHighwayman.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowHighwayman.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.ShadowHighwayman.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowHighwayman.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowHighwayman.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowHighwayman.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowHighwayman.DodgeAnimations = {
	"RollLeft",
    "RollRight"
}
CombatStyles.ShadowHighwayman.TimeToBlockFor = 3
CombatStyles.ShadowHighwayman.CanEvadeShots = false
CombatStyles.ShadowHighwayman.AntiSpamData = {}
CombatStyles.ShadowHighwayman.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowHighwayman.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowHighwayman.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowHighwayman.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowHighwayman.ValidStates = {}
CombatStyles.ShadowHighwayman.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"HighwaymanFireRangedWeapon",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowHighwayman.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwayman.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwayman.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwayman.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowHighwayman.ShootingBalanceData = {}
CombatStyles.ShadowHighwayman.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowHighwayman.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowHighwayman.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05



-- Shadow Highwayman Cornelius --
CombatStyles.ShadowHighwaymanCornelius = {}
CombatStyles.ShadowHighwaymanCornelius.CombatGroupType = CombatGroupTypes.HighwaymanLike
CombatStyles.ShadowHighwaymanCornelius.CanStrafe = true
CombatStyles.ShadowHighwaymanCornelius.CanSheatheWeapon = false
CombatStyles.ShadowHighwaymanCornelius.MovementTolerance = 0.45
CombatStyles.ShadowHighwaymanCornelius.Limits = {}
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Far] = 5
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Left] = 2
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Right] = 2
CombatStyles.ShadowHighwaymanCornelius.Limits[CombatZones.Rear] = 2.5
CombatStyles.ShadowHighwaymanCornelius.StrafeActionSpeed = 1
CombatStyles.ShadowHighwaymanCornelius.EnterStrafeDist = 5
CombatStyles.ShadowHighwaymanCornelius.LeaveStrafeDelta = 2
CombatStyles.ShadowHighwaymanCornelius.FleeAnim = "Flee"
CombatStyles.ShadowHighwaymanCornelius.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowHighwaymanCornelius.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowHighwaymanCornelius.Sequences = {}
CombatStyles.ShadowHighwaymanCornelius.Sequences[CombatSituations.Melee] = {
	"HighwaymanCorneliusShotTooMuch",
	"HighwaymanCorneliusMagicedTooMuch",
	{"HighwaymanCorneliusCastSwordsTargeted", 15},
	"HighwaymanCorneliusOrbSuckingResponse",
	"HighwaymanCorneliusFarAttackCombo",
	"HighwaymanCorneliusAttackCombo",
	"HighwaymanCorneliusCloseAttackCombo",
	"HighwaymanRollBack",
	"HighwaymanGoad",
	"HighwaymanIdleStrafeLeft",
	"HighwaymanIdleStrafeRight",
	"HighwaymanLeftAttack",
	"HighwaymanRightAttack",
	"HighwaymanRearAttack",
	"Idle"
}
CombatStyles.ShadowHighwaymanCornelius.Sequences[CombatSituations.Dodging] = {
	"HighwaymanCorneliusRollBackCastSwords"
}
CombatStyles.ShadowHighwaymanCornelius.Sequences[CombatSituations.GroupOrders] = {
	"HighwaymanAttackCombo",
	"HighwaymanStrikeThenRoll"
}
CombatStyles.ShadowHighwaymanCornelius.RunIntoAttack = "RunIntoAttack"
CombatStyles.ShadowHighwaymanCornelius.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.ShadowHighwaymanCornelius.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.ShadowHighwaymanCornelius.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowHighwaymanCornelius.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.ShadowHighwaymanCornelius.CanBlock = true
CombatStyles.ShadowHighwaymanCornelius.BlockData = {}
CombatStyles.ShadowHighwaymanCornelius.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowHighwaymanCornelius.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowHighwaymanCornelius.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowHighwaymanCornelius.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.ShadowHighwaymanCornelius.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowHighwaymanCornelius.BlockData.NumberOfHitsToForceSecondaryBlock = 1
CombatStyles.ShadowHighwaymanCornelius.DodgeAnimations = {
	"RollLeft",
    "RollRight"
}
CombatStyles.ShadowHighwaymanCornelius.TimeToBlockFor = 3
CombatStyles.ShadowHighwaymanCornelius.CanEvadeShots = false
CombatStyles.ShadowHighwaymanCornelius.AntiSpamData = {}
CombatStyles.ShadowHighwaymanCornelius.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowHighwaymanCornelius.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowHighwaymanCornelius.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowHighwaymanCornelius.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowHighwaymanCornelius.ValidStates = {}
CombatStyles.ShadowHighwaymanCornelius.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowHighwaymanCornelius.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwaymanCornelius.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwaymanCornelius.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowHighwaymanCornelius.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData = {}
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowHighwaymanCornelius.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Shadow Summoner Easy --
CombatStyles.ShadowSummonerEasy = {}
CombatStyles.ShadowSummonerEasy.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowSummonerEasy.CanStrafe = true
CombatStyles.ShadowSummonerEasy.DoRunIntoStrafe = true
CombatStyles.ShadowSummonerEasy.DesiredRange = 4
CombatStyles.ShadowSummonerEasy.StrafeActionSpeed = 1
CombatStyles.ShadowSummonerEasy.EnterRangedStrafeDist = 10
CombatStyles.ShadowSummonerEasy.CanSheatheWeapon = true
CombatStyles.ShadowSummonerEasy.Limits = {}
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Left] = 2
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Right] = 2
CombatStyles.ShadowSummonerEasy.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowSummonerEasy.SummonInfo = {}
CombatStyles.ShadowSummonerEasy.SummonInfo.CreatureType = "CreatureShadowBanditEasy"
CombatStyles.ShadowSummonerEasy.SummonInfo.NumberToSummon = 3
CombatStyles.ShadowSummonerEasy.SummonInfo.SpawnRadius = 5
CombatStyles.ShadowSummonerEasy.CanFlee = true
CombatStyles.ShadowSummonerEasy.FleeAnim = "Flee"
CombatStyles.ShadowSummonerEasy.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowSummonerEasy.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowSummonerEasy.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.ShadowSummonerEasy.Sequences = {}
CombatStyles.ShadowSummonerEasy.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditFastBackOff",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.ShadowSummonerEasy.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.ShadowSummonerEasy.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.ShadowSummonerEasy.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.ShadowSummonerEasy.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowSummonerEasy.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowSummonerEasy.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowSummonerEasy.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowSummonerEasy.CanBlock = true
CombatStyles.ShadowSummonerEasy.BlockData = {}
CombatStyles.ShadowSummonerEasy.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowSummonerEasy.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowSummonerEasy.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowSummonerEasy.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowSummonerEasy.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowSummonerEasy.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowSummonerEasy.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowSummonerEasy.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowSummonerEasy.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowSummonerEasy.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowSummonerEasy.TimeToBlockFor = 1.5
CombatStyles.ShadowSummonerEasy.AntiSpamData = {}
CombatStyles.ShadowSummonerEasy.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowSummonerEasy.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowSummonerEasy.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowSummonerEasy.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowSummonerEasy.OuterRingPercentAsRanged = 0.5
CombatStyles.ShadowSummonerEasy.ValidStates = {}
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"ShadowSummonerSummon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerEasy.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowSummonerEasy.ShootingBalanceData = {}
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowSummonerEasy.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Shadow Summoner Normal --
CombatStyles.ShadowSummonerNormal = {}
CombatStyles.ShadowSummonerNormal.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowSummonerNormal.CanStrafe = true
CombatStyles.ShadowSummonerNormal.DoRunIntoStrafe = true
CombatStyles.ShadowSummonerNormal.DesiredRange = 4
CombatStyles.ShadowSummonerNormal.StrafeActionSpeed = 1
CombatStyles.ShadowSummonerNormal.EnterRangedStrafeDist = 10
CombatStyles.ShadowSummonerNormal.CanSheatheWeapon = true
CombatStyles.ShadowSummonerNormal.Limits = {}
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Far] = 4.5
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Left] = 2
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Right] = 2
CombatStyles.ShadowSummonerNormal.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowSummonerNormal.SummonInfo = {}
CombatStyles.ShadowSummonerNormal.SummonInfo.CreatureType = "CreatureShadowBandit"
CombatStyles.ShadowSummonerNormal.SummonInfo.NumberToSummon = 3
CombatStyles.ShadowSummonerNormal.SummonInfo.SpawnRadius = 5
CombatStyles.ShadowSummonerNormal.CanFlee = true
CombatStyles.ShadowSummonerNormal.FleeAnim = "Flee"
CombatStyles.ShadowSummonerNormal.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowSummonerNormal.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowSummonerNormal.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.ShadowSummonerNormal.Sequences = {}
CombatStyles.ShadowSummonerNormal.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditFastBackOff",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.ShadowSummonerNormal.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.ShadowSummonerNormal.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.ShadowSummonerNormal.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.ShadowSummonerNormal.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowSummonerNormal.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowSummonerNormal.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowSummonerNormal.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowSummonerNormal.CanBlock = true
CombatStyles.ShadowSummonerNormal.BlockData = {}
CombatStyles.ShadowSummonerNormal.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowSummonerNormal.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowSummonerNormal.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowSummonerNormal.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowSummonerNormal.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowSummonerNormal.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowSummonerNormal.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowSummonerNormal.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowSummonerNormal.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowSummonerNormal.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowSummonerNormal.TimeToBlockFor = 1.5
CombatStyles.ShadowSummonerNormal.AntiSpamData = {}
CombatStyles.ShadowSummonerNormal.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowSummonerNormal.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowSummonerNormal.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowSummonerNormal.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowSummonerNormal.OuterRingPercentAsRanged = 0.5
CombatStyles.ShadowSummonerNormal.ValidStates = {}
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"ShadowSummonerSummon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerNormal.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowSummonerNormal.ShootingBalanceData = {}
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowSummonerNormal.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Shadow Summoner Hard --
CombatStyles.ShadowSummonerHard = {}
CombatStyles.ShadowSummonerHard.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.ShadowSummonerHard.CanStrafe = true
CombatStyles.ShadowSummonerHard.DoRunIntoStrafe = true
CombatStyles.ShadowSummonerHard.DesiredRange = 4
CombatStyles.ShadowSummonerHard.StrafeActionSpeed = 1
CombatStyles.ShadowSummonerHard.EnterRangedStrafeDist = 10
CombatStyles.ShadowSummonerHard.CanSheatheWeapon = true
CombatStyles.ShadowSummonerHard.Limits = {}
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Near] = 1.5
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Middle] = 2.5
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Far] = 4.5
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Left] = 2
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Right] = 2
CombatStyles.ShadowSummonerHard.Limits[CombatZones.Rear] = 3
CombatStyles.ShadowSummonerHard.SummonInfo = {}
CombatStyles.ShadowSummonerHard.SummonInfo.CreatureType = "CreatureShadowHighwayman"
CombatStyles.ShadowSummonerHard.SummonInfo.NumberToSummon = 3
CombatStyles.ShadowSummonerHard.SummonInfo.SpawnRadius = 5
CombatStyles.ShadowSummonerHard.CanFlee = true
CombatStyles.ShadowSummonerHard.FleeAnim = "Flee"
CombatStyles.ShadowSummonerHard.FleeIntoAnim = "FleeInto"
CombatStyles.ShadowSummonerHard.FleeOutOfAnim = "FleeOutOf"
CombatStyles.ShadowSummonerHard.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.ShadowSummonerHard.Sequences = {}
CombatStyles.ShadowSummonerHard.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditFastBackOff",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.ShadowSummonerHard.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.ShadowSummonerHard.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.ShadowSummonerHard.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.ShadowSummonerHard.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.ShadowSummonerHard.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.ShadowSummonerHard.MinSecondsBetweenRangedAttacks = 4
CombatStyles.ShadowSummonerHard.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowSummonerHard.CanBlock = true
CombatStyles.ShadowSummonerHard.BlockData = {}
CombatStyles.ShadowSummonerHard.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.ShadowSummonerHard.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.ShadowSummonerHard.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowSummonerHard.BlockData.PercentChanceToPrimaryBlockInitialHit = 0
CombatStyles.ShadowSummonerHard.BlockData.PercentIncreaseToPrimaryBlockPerHit = 0
CombatStyles.ShadowSummonerHard.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowSummonerHard.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.ShadowSummonerHard.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.ShadowSummonerHard.BlockData.PercentChanceToSecondaryBlockInitialHit = 0
CombatStyles.ShadowSummonerHard.BlockData.PercentIncreaseToSecondaryBlockPerHit = 0
CombatStyles.ShadowSummonerHard.TimeToBlockFor = 1.5
CombatStyles.ShadowSummonerHard.AntiSpamData = {}
CombatStyles.ShadowSummonerHard.AntiSpamData.TimeToCheckFor = 5
CombatStyles.ShadowSummonerHard.AntiSpamData.ShotsToTrigger = 3
CombatStyles.ShadowSummonerHard.AntiSpamData.SpellsToTrigger = 2
CombatStyles.ShadowSummonerHard.AntiSpamData.TimeToAggroFor = 15
CombatStyles.ShadowSummonerHard.OuterRingPercentAsRanged = 0.5
CombatStyles.ShadowSummonerHard.ValidStates = {}
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"ShadowSummonerSummon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowSummonerHard.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowSummonerHard.ShootingBalanceData = {}
CombatStyles.ShadowSummonerHard.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.ShadowSummonerHard.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.ShadowSummonerHard.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05



-- uncomment for debug
-- GUI.DisplayMessageBox("shadowcombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end