


-- Villager --
CombatStyles.Villager = {}
CombatStyles.Villager.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.Villager.CanStrafe = true
CombatStyles.Villager.CanSheatheWeapon = true
CombatStyles.Villager.StrafeActionSpeed = 1
CombatStyles.Villager.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.Villager.PreferRanged = true
CombatStyles.Villager.VigilanteWeapon = "NPC_F3_Master_Turret_Pistol"
CombatStyles.Villager.Limits = {}
CombatStyles.Villager.Limits[CombatZones.Near] = 1.5
CombatStyles.Villager.Limits[CombatZones.Middle] = 2.5
CombatStyles.Villager.Limits[CombatZones.Far] = 4.5
CombatStyles.Villager.Limits[CombatZones.Left] = 1
CombatStyles.Villager.Limits[CombatZones.Right] = 1
CombatStyles.Villager.Limits[CombatZones.Rear] = 1
CombatStyles.Villager.Sequences = {}
CombatStyles.Villager.Sequences[CombatSituations.Melee] = {
	"Idle",
	"BackOff"
}
CombatStyles.Villager.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.Villager.ValidStates = {}
CombatStyles.Villager.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Villager.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.Villager.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Villager.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Villager.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Villager.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.Villager.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.Villager.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.Villager.MinSecondsBetweenRangedAttacks = 5
CombatStyles.Villager.ShootingBalanceData = {}
CombatStyles.Villager.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.Villager.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.Villager.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9



-- Villager Melee --
CombatStyles.VillagerMelee = {}
CombatStyles.VillagerMelee.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.VillagerMelee.CanStrafe = true
CombatStyles.VillagerMelee.CanSheatheWeapon = true
CombatStyles.VillagerMelee.ForceWeaponType = WeaponTypes.Melee
CombatStyles.VillagerMelee.StrafeActionSpeed = 1
CombatStyles.VillagerMelee.Limits = {}
CombatStyles.VillagerMelee.Limits[CombatZones.Near] = 1.5
CombatStyles.VillagerMelee.Limits[CombatZones.Middle] = 2.5
CombatStyles.VillagerMelee.Limits[CombatZones.Far] = 5
CombatStyles.VillagerMelee.Limits[CombatZones.Left] = 1
CombatStyles.VillagerMelee.Limits[CombatZones.Right] = 1
CombatStyles.VillagerMelee.Limits[CombatZones.Rear] = 1
CombatStyles.VillagerMelee.Sequences = {}
CombatStyles.VillagerMelee.Sequences[CombatSituations.Melee] = {
	"CloseAttackLeftRight",
	"AttackComboLeftRightNoStep",
	"Idle",
	"BackOff"
}
CombatStyles.VillagerMelee.ValidStates = {}
CombatStyles.VillagerMelee.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.VillagerMelee.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.VillagerMelee.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.VillagerMelee.MinSecondsBetweenRangedAttacks = 5
CombatStyles.VillagerMelee.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.VillagerMelee.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.VillagerMelee.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.VillagerMelee.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.VillagerMelee.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.VillagerMelee.ShootingBalanceData = {}
CombatStyles.VillagerMelee.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.VillagerMelee.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 28
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.VillagerMelee.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9


-- Dog --
CombatStyles.Dog = {}
CombatStyles.Dog.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.Dog.SecondsToWaitAfterTargetIsHit = 0
CombatStyles.Dog.SecondsToWaitAfterTargetIsAttacked = 0
CombatStyles.Dog.CanStrafe = false
CombatStyles.Dog.NonFormation = true
CombatStyles.Dog.CanOnlyEngageOneOnOne = true
CombatStyles.Dog.CanFightUnarmed = true
CombatStyles.Dog.Limits = {}
CombatStyles.Dog.Limits[CombatZones.Near] = 2
CombatStyles.Dog.Limits[CombatZones.Middle] = 1
CombatStyles.Dog.Limits[CombatZones.Far] = 1
CombatStyles.Dog.Limits[CombatZones.Left] = 1
CombatStyles.Dog.Limits[CombatZones.Right] = 1
CombatStyles.Dog.Limits[CombatZones.Rear] = 1
CombatStyles.Dog.Sequences = {}
CombatStyles.Dog.Sequences[CombatSituations.Melee] = {
	"DogLowAttack",
	"DogHighAttack",
	"DogIdle"
}
CombatStyles.Dog.ValidStates = {}
CombatStyles.Dog.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}
CombatStyles.Dog.ValidStates.NonAttackableCreatureTypes = {
	ECreatureType.CREATURE_TROLL,
	ECreatureType.CREATURE_BALVERINE,
	ECreatureType.CREATURE_SHARD,
	ECreatureType.CREATURE_BANSHEE
}
CombatStyles.Dog.TargetScoringFunction = function(attacker_info, target)

	local multiplier = 1.0
	local master = Dog.GetMaster(attacker_info.Combatant)
	
	if master:IsAlive() then
		local master_ranged = Carrying.IsCarryingRangedWeapon(master)
		local target_ranged = false
		
		if Carrying.IsAvailable(target) then
			target_ranged = Carrying.IsCarryingRangedWeapon(target)
		end
		
		if master_ranged ~= target_ranged then
			multiplier = multiplier * 5
		end
	end
	
	if GUI.IsEntityOnScreen(target) then
		multiplier = multiplier * 3
	end
	
	return multiplier
end


-- Bodyguard --
CombatStyles.Bodyguard = DeepCopyTable(CombatStyles.Bandit)
CombatStyles.Bodyguard.CanSheatheWeapon = true


-- Reaver --
CombatStyles.Reaver = {}
CombatStyles.Reaver.IsReaver = true
CombatStyles.Reaver.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.Reaver.AttachNonForcedWeaponType = true
CombatStyles.Reaver.PreferRanged = true
CombatStyles.Reaver.CanSheatheWeapon = true
CombatStyles.Reaver.RegroupWithHero = true
CombatStyles.Reaver.RegroupWithHeroChaseRange = 70
CombatStyles.Reaver.RegroupWithHeroPatrolRange = 10
CombatStyles.Reaver.CanStrafe = false
CombatStyles.Reaver.DoRunIntoStrafe = true
CombatStyles.Reaver.NonFormation = true
CombatStyles.Reaver.UseExtendedZones = true
CombatStyles.Reaver.Limits = {}
CombatStyles.Reaver.Limits[CombatZones.Near] = 1.5
CombatStyles.Reaver.Limits[CombatZones.Middle] = 4
CombatStyles.Reaver.Limits[CombatZones.Far] = 10
CombatStyles.Reaver.Limits[CombatZones.Left] = 2
CombatStyles.Reaver.Limits[CombatZones.Right] = 2
CombatStyles.Reaver.Limits[CombatZones.Rear] = 2
CombatStyles.Reaver.Limits[CombatZones.LeftFar] = 7
CombatStyles.Reaver.Limits[CombatZones.RightFar] = 7
CombatStyles.Reaver.Limits[CombatZones.RearFar] = 7
CombatStyles.Reaver.Angles = {}
CombatStyles.Reaver.Angles[AngleToleranceZones.LeftFar_Min] = 45
CombatStyles.Reaver.Angles[AngleToleranceZones.LeftFar_Max] = 140
CombatStyles.Reaver.Angles[AngleToleranceZones.RightFar_Min] = 45
CombatStyles.Reaver.Angles[AngleToleranceZones.RightFar_Max] = 145
CombatStyles.Reaver.Angles[AngleToleranceZones.RearFar_Min] = 90
CombatStyles.Reaver.Angles[AngleToleranceZones.RearFar_Max] = 180
CombatStyles.Reaver.Sequences = {}
CombatStyles.Reaver.Sequences[CombatSituations.Ranged] = {
	"FarIdle",
	"RangedIdle"
}
CombatStyles.Reaver.Sequences[CombatSituations.Dodging] = {
	"ReaverSnapFire"
}
CombatStyles.Reaver.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.Reaver.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.Reaver.MinSecondsBetweenRangedAttacks = 2
CombatStyles.Reaver.MinSecondsBetweenSpecialRangedAttacks = 8
CombatStyles.Reaver.ValidStates = {}
CombatStyles.Reaver.ValidStates[CombatSituations.Ranged] = {
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"ReaverMeleeAttack",
	"ReaverSpecialMultiShot",
	"ReaverSpecialRangedAttacks",
	"ReaverFireRangedWeapon",
	"PlayBanterCombatComment",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.Reaver.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"UpdateWeapon"
}
CombatStyles.Reaver.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Reaver.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Reaver.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Reaver.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.Reaver.CanBlock = true
CombatStyles.Reaver.BlockData = {}
CombatStyles.Reaver.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.Reaver.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Reaver.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.Reaver.BlockData.SecondsToBlockFor = 3
CombatStyles.Reaver.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}


-- DoNothing --
CombatStyles.DoNothing = {}
CombatStyles.DoNothing.CanStrafe = true
CombatStyles.DoNothing.CanSheatheWeapon = true
CombatStyles.DoNothing.Limits = {}
CombatStyles.DoNothing.Limits[CombatZones.Near] = 1
CombatStyles.DoNothing.Limits[CombatZones.Middle] = 2.5
CombatStyles.DoNothing.Limits[CombatZones.Far] = 5
CombatStyles.DoNothing.Limits[CombatZones.Left] = 1
CombatStyles.DoNothing.Limits[CombatZones.Right] = 1
CombatStyles.DoNothing.Limits[CombatZones.Rear] = 1
CombatStyles.DoNothing.Sequences = {}
CombatStyles.DoNothing.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.DoNothing.ValidStates = CombatStyles.StandardCombatStates


-- Prisoner --
CombatStyles.Prisoner = DeepCopyTable(CombatStyles.Bandit)
CombatStyles.Prisoner.ForceWeaponType = WeaponTypes.Melee
CombatStyles.Prisoner.CanSheatheWeapon = false


-- Duelist A --
CombatStyles.Duelist_A = {}
CombatStyles.Duelist_A.ForceWeaponType = WeaponTypes.Melee
CombatStyles.Duelist_A.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.Duelist_A.CanStrafe = true
CombatStyles.Duelist_A.DoRunIntoStrafe = true
CombatStyles.Duelist_A.DesiredRange = 4
CombatStyles.Duelist_A.StrafeActionSpeed = 1
CombatStyles.Duelist_A.EnterRangedStrafeDist = 10
CombatStyles.Duelist_A.CanSheatheWeapon = true
CombatStyles.Duelist_A.Limits = {}
CombatStyles.Duelist_A.Limits[CombatZones.Near] = 1.5
CombatStyles.Duelist_A.Limits[CombatZones.Middle] = 2.5
CombatStyles.Duelist_A.Limits[CombatZones.Far] = 4.5
CombatStyles.Duelist_A.Limits[CombatZones.Left] = 2
CombatStyles.Duelist_A.Limits[CombatZones.Right] = 2
CombatStyles.Duelist_A.Limits[CombatZones.Rear] = 3
CombatStyles.Duelist_A.CanFlee = false
CombatStyles.Duelist_A.FleeAnim = "Flee"
CombatStyles.Duelist_A.FleeIntoAnim = "FleeInto"
CombatStyles.Duelist_A.FleeOutOfAnim = "FleeOutOf"
CombatStyles.Duelist_A.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.Duelist_A.Sequences = {}
CombatStyles.Duelist_A.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.Duelist_A.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.Duelist_A.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.Duelist_A.SecondsToWaitAfterTargetIsHit = 2.5
CombatStyles.Duelist_A.CanBlock = true
CombatStyles.Duelist_A.BlockData = {}
CombatStyles.Duelist_A.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.Duelist_A.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Duelist_A.BlockData.NumberOfHitsToForcePrimaryBlock = 0
CombatStyles.Duelist_A.BlockData.SecondsToBlockFor = 1.8
CombatStyles.Duelist_A.ValidStates = {}
CombatStyles.Duelist_A.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Duelist_A.ValidStates[CombatSituations.Ranged] = {
	"IdleWithRangedWeapon"
}
CombatStyles.Duelist_A.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_A.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_A.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_A.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates



-- Duelist B --
CombatStyles.Duelist_B = {}
CombatStyles.Duelist_B.ForceWeaponType = WeaponTypes.Melee
CombatStyles.Duelist_B.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.Duelist_B.CanStrafe = true
CombatStyles.Duelist_B.DoRunIntoStrafe = true
CombatStyles.Duelist_B.DesiredRange = 4
CombatStyles.Duelist_B.StrafeActionSpeed = 1
CombatStyles.Duelist_B.EnterRangedStrafeDist = 10
CombatStyles.Duelist_B.CanSheatheWeapon = true
CombatStyles.Duelist_B.Limits = {}
CombatStyles.Duelist_B.Limits[CombatZones.Near] = 1.5
CombatStyles.Duelist_B.Limits[CombatZones.Middle] = 2.5
CombatStyles.Duelist_B.Limits[CombatZones.Far] = 4.5
CombatStyles.Duelist_B.Limits[CombatZones.Left] = 2
CombatStyles.Duelist_B.Limits[CombatZones.Right] = 2
CombatStyles.Duelist_B.Limits[CombatZones.Rear] = 3
CombatStyles.Duelist_B.CanFlee = false
CombatStyles.Duelist_B.FleeAnim = "Flee"
CombatStyles.Duelist_B.FleeIntoAnim = "FleeInto"
CombatStyles.Duelist_B.FleeOutOfAnim = "FleeOutOf"
CombatStyles.Duelist_B.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.Duelist_B.Sequences = {}
CombatStyles.Duelist_B.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.Duelist_B.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.Duelist_B.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.Duelist_B.SecondsToWaitAfterTargetIsHit = 2.5
CombatStyles.Duelist_B.CanBlock = true
CombatStyles.Duelist_B.BlockData = {}
CombatStyles.Duelist_B.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.Duelist_B.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Duelist_B.BlockData.NumberOfHitsToForcePrimaryBlock = 0
CombatStyles.Duelist_B.BlockData.SecondsToBlockFor = 1.8
CombatStyles.Duelist_B.ValidStates = {}
CombatStyles.Duelist_B.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Duelist_B.ValidStates[CombatSituations.Ranged] = {
	"IdleWithRangedWeapon"
}
CombatStyles.Duelist_B.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_B.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_B.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Duelist_B.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- WalterBeck --
CombatStyles.WalterBeck = {}
CombatStyles.WalterBeck.ForceWeaponType = WeaponTypes.Melee
CombatStyles.WalterBeck.AttachNonForcedWeaponType = true
CombatStyles.WalterBeck.TargetFilter = CombatStates.WalterBeckTargetFilter
CombatStyles.WalterBeck.DualWielding = true
CombatStyles.WalterBeck.ShootsInMelee = true
CombatStyles.WalterBeck.NonFormation = true
CombatStyles.WalterBeck.CanStrafe = true
CombatStyles.WalterBeck.StrafeActionSpeed = 1
CombatStyles.WalterBeck.EnterRangedStrafeDist = 10
CombatStyles.WalterBeck.CanSheatheWeapon = true
CombatStyles.WalterBeck.ActionModifiers = {}
CombatStyles.WalterBeck.ActionModifiers.BlockBreaker = true
CombatStyles.WalterBeck.RegroupWithHero = true
CombatStyles.WalterBeck.RegroupWithHeroChaseRange = 10
CombatStyles.WalterBeck.RegroupWithHeroPatrolRange = 10
CombatStyles.WalterBeck.Limits = {}
CombatStyles.WalterBeck.Limits[CombatZones.Near] = 1.5
CombatStyles.WalterBeck.Limits[CombatZones.Middle] = 3
CombatStyles.WalterBeck.Limits[CombatZones.Far] = 4
CombatStyles.WalterBeck.Limits[CombatZones.Left] = 2
CombatStyles.WalterBeck.Limits[CombatZones.Right] = 2
CombatStyles.WalterBeck.Limits[CombatZones.Rear] = 2
CombatStyles.WalterBeck.CanFlee = false
CombatStyles.WalterBeck.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.WalterBeck.Sequences = {}
CombatStyles.WalterBeck.Sequences[CombatSituations.Melee] = {
	"BeckSpinAndShoot",
	"BeckSpecialAttackShoulderCharge",
	"BeckPunchAndShot",
	"BeckAttackLeftRightSpin",
	"BeckGoad",
	"BeckAttackLeftRightCombo",
	"BeckAttackLeftRightShotCombo",
	"BeckStabNear",
	"BeckSpin",
	"BeckSpinAndQuickShot",
	"BeckLowStabMid",
	"BeckStabMid",
	"BeckLowStabMidAndShot",
	"BeckStabMidAndShot",
	{"BeckSpecialAttackSpinAround", 10},
	"BeckAttackLeftRightTwiceCombo",
	{"BeckFlourishLeftBackToIdle", 5},
	"BeckPunch",
	{"BeckDoubleShot", 15},
	"Idle"
}
CombatStyles.WalterBeck.Sequences[CombatSituations.HardBlocking] = {
	"WalterBeckAttackOutOfBlock"
}
CombatStyles.WalterBeck.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.WalterBeck.SecondsToWaitAfterTargetIsHit = 0.1
CombatStyles.WalterBeck.MinSecondsBetweenRangedAttacks = 8
CombatStyles.WalterBeck.CanStandOffAndShoot = "Aggressive"
CombatStyles.WalterBeck.CanBlock = true
CombatStyles.WalterBeck.BlockData = {}
CombatStyles.WalterBeck.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.WalterBeck.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 4
CombatStyles.WalterBeck.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.WalterBeck.BlockData.PercentChanceToBlockInitialHit = 50
CombatStyles.WalterBeck.BlockData.SecondsToBlockFor = 2
CombatStyles.WalterBeck.ValidStates = {}
CombatStyles.WalterBeck.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"WalterBeckStabOnGround",
	"WalterBeckReload",
	"PlayCombatSequence",
	"WalterBeckRangedAttack",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.WalterBeck.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.WalterBeck.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeck.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeck.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeck.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- WalterBeck Turret --
CombatStyles.WalterBeckTurret = {}
CombatStyles.WalterBeckTurret.ForceWeaponType = WeaponTypes.Melee
CombatStyles.WalterBeckTurret.AttachNonForcedWeaponType = true
CombatStyles.WalterBeckTurret.DualWielding = true
CombatStyles.WalterBeckTurret.ShootsInMelee = true
CombatStyles.WalterBeckTurret.NonFormation = true
CombatStyles.WalterBeckTurret.MoveToFiringPosNoWait = true
CombatStyles.WalterBeckTurret.CanStrafe = true
CombatStyles.WalterBeckTurret.StrafeActionSpeed = 1
CombatStyles.WalterBeckTurret.EnterRangedStrafeDist = 10
CombatStyles.WalterBeckTurret.CanSheatheWeapon = true
CombatStyles.WalterBeckTurret.ActionModifiers = {}
CombatStyles.WalterBeckTurret.ActionModifiers.BlockBreaker = true
CombatStyles.WalterBeckTurret.TurretBalanceData = {}
CombatStyles.WalterBeckTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.WalterBeckTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.WalterBeckTurret.TurretBalanceData.NonTurretCombatStyle = "WalterBeck"
CombatStyles.WalterBeckTurret.Limits = {}
CombatStyles.WalterBeckTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.WalterBeckTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.WalterBeckTurret.Limits[CombatZones.Far] = 5.5
CombatStyles.WalterBeckTurret.Limits[CombatZones.Left] = 2
CombatStyles.WalterBeckTurret.Limits[CombatZones.Right] = 2
CombatStyles.WalterBeckTurret.Limits[CombatZones.Rear] = 2
CombatStyles.WalterBeckTurret.CanFlee = false
CombatStyles.WalterBeckTurret.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.WalterBeckTurret.Sequences = {}
CombatStyles.WalterBeckTurret.Sequences[CombatSituations.Melee] = {
	"BeckSpin",
	"BeckGoad",
	"Idle",
	"FarIdle"
}
CombatStyles.WalterBeckTurret.Sequences[CombatSituations.HardBlocking] = {
	"WalterBeckAttackOutOfBlock"
}
CombatStyles.WalterBeckTurret.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.WalterBeckTurret.SecondsToWaitAfterTargetIsHit = 0.1
CombatStyles.WalterBeckTurret.MinSecondsBetweenRangedAttacks = 3
CombatStyles.WalterBeckTurret.CanStandOffAndShoot = "Turret"
CombatStyles.WalterBeckTurret.CanBlock = true
CombatStyles.WalterBeckTurret.BlockData = {}
CombatStyles.WalterBeckTurret.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.WalterBeckTurret.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 4
CombatStyles.WalterBeckTurret.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.WalterBeckTurret.BlockData.PercentChanceToBlockInitialHit = 50
CombatStyles.WalterBeckTurret.BlockData.SecondsToBlockFor = 2
CombatStyles.WalterBeckTurret.ValidStates = {}
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"WalterBeckReload",
	"WalterBeckRangedAttack",
	"PlayCombatSequence",
	"FaceTarget"
}
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTurret.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- WalterBeck Opening --
CombatStyles.WalterBeckOpening = {}
CombatStyles.WalterBeckOpening.ForceWeaponType = WeaponTypes.Melee
CombatStyles.WalterBeckOpening.AttachNonForcedWeaponType = true
CombatStyles.WalterBeckOpening.DualWielding = false
CombatStyles.WalterBeckOpening.ShootsInMelee = false
CombatStyles.WalterBeckOpening.NonFormation = true
CombatStyles.WalterBeckOpening.CanStrafe = true
CombatStyles.WalterBeckOpening.StrafeActionSpeed = 1
CombatStyles.WalterBeckOpening.EnterRangedStrafeDist = 10
CombatStyles.WalterBeckOpening.CanSheatheWeapon = true
CombatStyles.WalterBeckOpening.RegroupWithHero = true
CombatStyles.WalterBeckOpening.RegroupWithHeroChaseRange = 10
CombatStyles.WalterBeckOpening.RegroupWithHeroPatrolRange = 10
CombatStyles.WalterBeckOpening.Limits = {}
CombatStyles.WalterBeckOpening.Limits[CombatZones.Near] = 1.5
CombatStyles.WalterBeckOpening.Limits[CombatZones.Middle] = 3
CombatStyles.WalterBeckOpening.Limits[CombatZones.Far] = 4
CombatStyles.WalterBeckOpening.Limits[CombatZones.Left] = 2
CombatStyles.WalterBeckOpening.Limits[CombatZones.Right] = 2
CombatStyles.WalterBeckOpening.Limits[CombatZones.Rear] = 2
CombatStyles.WalterBeckOpening.CanFlee = false
CombatStyles.WalterBeckOpening.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.WalterBeckOpening.Sequences = {}
CombatStyles.WalterBeckOpening.Sequences[CombatSituations.Melee] = {
	"BeckOpeningAttackLeftRightSpin",
	"BeckOpeningAttackLeftRightCombo",
	"BeckOpeningStabNear",
	"BeckOpeningSpin",
	"BeckOpeningStabMid",
	"BeckOpeningAttackLeftRightTwiceCombo",
	{"BeckOpeningFlourishLeftBackToIdle", 5},
	{"BeckStrafeRight", 5},
	{"BeckStrafeForwards", 6},
	{"BeckStrafeBackwards", 6},
	"Idle"
}
CombatStyles.WalterBeckOpening.Sequences[CombatSituations.HardBlocking] = {

}
CombatStyles.WalterBeckOpening.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.WalterBeckOpening.SecondsToWaitAfterTargetIsHit = 0.1
CombatStyles.WalterBeckOpening.MinSecondsBetweenRangedAttacks = 8
CombatStyles.WalterBeckOpening.CanStandOffAndShoot = "Aggressive"
CombatStyles.WalterBeckOpening.CanBlock = true
CombatStyles.WalterBeckOpening.BlockData = {}
CombatStyles.WalterBeckOpening.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.WalterBeckOpening.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 10
CombatStyles.WalterBeckOpening.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.WalterBeckOpening.BlockData.MaxHitsToBlock = 8
CombatStyles.WalterBeckOpening.BlockData.SecondsToBlockFor = 2
CombatStyles.WalterBeckOpening.ValidStates = {}
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpening.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- WalterBeck Opening BlockingOnly --
CombatStyles.WalterBeckOpeningBlockingOnly = {}
CombatStyles.WalterBeckOpeningBlockingOnly.ForceWeaponType = WeaponTypes.Melee
CombatStyles.WalterBeckOpeningBlockingOnly.AttachNonForcedWeaponType = true
CombatStyles.WalterBeckOpeningBlockingOnly.DualWielding = false
CombatStyles.WalterBeckOpeningBlockingOnly.ShootsInMelee = false
CombatStyles.WalterBeckOpeningBlockingOnly.NonFormation = true
CombatStyles.WalterBeckOpeningBlockingOnly.CanStrafe = true
CombatStyles.WalterBeckOpeningBlockingOnly.StrafeActionSpeed = 1
CombatStyles.WalterBeckOpeningBlockingOnly.EnterRangedStrafeDist = 10
CombatStyles.WalterBeckOpeningBlockingOnly.CanSheatheWeapon = true
CombatStyles.WalterBeckOpeningBlockingOnly.ActionModifiers = {}
CombatStyles.WalterBeckOpeningBlockingOnly.ActionModifiers.BlockBreaker = true
CombatStyles.WalterBeckOpeningBlockingOnly.RegroupWithHero = true
CombatStyles.WalterBeckOpeningBlockingOnly.RegroupWithHeroChaseRange = 10
CombatStyles.WalterBeckOpeningBlockingOnly.RegroupWithHeroPatrolRange = 10
CombatStyles.WalterBeckOpeningBlockingOnly.Limits = {}
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Near] = 1.5
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Middle] = 3
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Far] = 4
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Left] = 2
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Right] = 2
CombatStyles.WalterBeckOpeningBlockingOnly.Limits[CombatZones.Rear] = 2
CombatStyles.WalterBeckOpeningBlockingOnly.CanFlee = false
CombatStyles.WalterBeckOpeningBlockingOnly.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.WalterBeckOpeningBlockingOnly.Sequences = {}
CombatStyles.WalterBeckOpeningBlockingOnly.Sequences[CombatSituations.Melee] = {
	{"BeckStrafeRight", 5},
	{"BeckStrafeForwards", 6},
	{"BeckStrafeBackwards", 6},
	"Idle"
}
CombatStyles.WalterBeckOpeningBlockingOnly.Sequences[CombatSituations.HardBlocking] = {

}
CombatStyles.WalterBeckOpeningBlockingOnly.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.WalterBeckOpeningBlockingOnly.SecondsToWaitAfterTargetIsHit = 0.1
CombatStyles.WalterBeckOpeningBlockingOnly.MinSecondsBetweenRangedAttacks = 8
CombatStyles.WalterBeckOpeningBlockingOnly.CanStandOffAndShoot = "Aggressive"
CombatStyles.WalterBeckOpeningBlockingOnly.CanBlock = true
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData = {}
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 10
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.PercentChanceToBlockInitialHit = 100
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.MaxHitsToBlock = 4
CombatStyles.WalterBeckOpeningBlockingOnly.BlockData.SecondsToBlockFor = 2
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates = {}
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckOpeningBlockingOnly.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- WalterBeck Shadow FirstStage --
CombatStyles.ShadowWalterBeckFirstStage = {}
CombatStyles.ShadowWalterBeckFirstStage.ForceWeaponType = WeaponTypes.Melee
CombatStyles.ShadowWalterBeckFirstStage.AttachNonForcedWeaponType = true
CombatStyles.ShadowWalterBeckFirstStage.DualWielding = true
CombatStyles.ShadowWalterBeckFirstStage.ShootsInMelee = true
CombatStyles.ShadowWalterBeckFirstStage.NonFormation = true
CombatStyles.ShadowWalterBeckFirstStage.StrafeActionSpeed = 1
CombatStyles.ShadowWalterBeckFirstStage.EnterRangedStrafeDist = 1
CombatStyles.ShadowWalterBeckFirstStage.DesiredRange = 1
CombatStyles.ShadowWalterBeckFirstStage.CanSheatheWeapon = true
CombatStyles.ShadowWalterBeckFirstStage.Limits = {}
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Near] = 2
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Middle] = 3
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Far] = 16
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Left] = 2
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Right] = 2
CombatStyles.ShadowWalterBeckFirstStage.Limits[CombatZones.Rear] = 2
CombatStyles.ShadowWalterBeckFirstStage.CanFlee = false
CombatStyles.ShadowWalterBeckFirstStage.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.ShadowWalterBeckFirstStage.Sequences = {}
CombatStyles.ShadowWalterBeckFirstStage.Sequences[CombatSituations.Melee] = {
	{"ShadowWalterShotTooMuch", 10},
	"ShadowBeckSpecialAttackShoulderCharge",
	"ShadowBeckAttackLeftRightSpin",
	"ShadowBeckSpin",
	"ShadowBeckStabNear",
	"ShadowBeckStabMid",
	{"ShadowBeckSpecialAttackSpinAround", 10},
	"ShadowBeckAttackLeftRightTwiceCombo",
	"Idle"
}
CombatStyles.ShadowWalterBeckFirstStage.Sequences[CombatSituations.HardBlocking] = {
	"ShadowWalterBeckAttackOutOfBlock"
}
CombatStyles.ShadowWalterBeckFirstStage.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.ShadowWalterBeckFirstStage.SecondsToWaitAfterTargetIsHit = 1.25
CombatStyles.ShadowWalterBeckFirstStage.MinSecondsBetweenRangedAttacks = 4.5
CombatStyles.ShadowWalterBeckFirstStage.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowWalterBeckFirstStage.CanBlock = true
CombatStyles.ShadowWalterBeckFirstStage.BlockData = {}
CombatStyles.ShadowWalterBeckFirstStage.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowWalterBeckFirstStage.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 5
CombatStyles.ShadowWalterBeckFirstStage.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.ShadowWalterBeckFirstStage.BlockData.SecondsToBlockFor = 1.5
CombatStyles.ShadowWalterBeckFirstStage.ValidStates = {}
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckFirstStage.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData = {}
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData.AOERangedAttackEntity = "ShadowSirWalterRangedAttackExplosion"
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData.AOEWeaponEffectName = "fxcre_shadow_walter_sword_ground_strike"
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData.SecondsBetweenAOEAttacks = 15
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData.LinearRangedAttackEntity = "ShadowSirWalterLinearAttackLarge"
CombatStyles.ShadowWalterBeckFirstStage.SentinelBalanceData.SecondsBetweenLinearAttacks = 10


-- WalterBeck Shadow SecondStage --
CombatStyles.ShadowWalterBeckSecondStage = {}
CombatStyles.ShadowWalterBeckSecondStage.ForceWeaponType = WeaponTypes.Melee
CombatStyles.ShadowWalterBeckSecondStage.AttachNonForcedWeaponType = true
CombatStyles.ShadowWalterBeckSecondStage.DualWielding = true
CombatStyles.ShadowWalterBeckSecondStage.ShootsInMelee = true
CombatStyles.ShadowWalterBeckSecondStage.NonFormation = true
CombatStyles.ShadowWalterBeckSecondStage.StrafeActionSpeed = 1
CombatStyles.ShadowWalterBeckSecondStage.EnterRangedStrafeDist = 2
CombatStyles.ShadowWalterBeckSecondStage.DesiredRange = 2
CombatStyles.ShadowWalterBeckSecondStage.CanSheatheWeapon = true
CombatStyles.ShadowWalterBeckSecondStage.Limits = {}
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Near] = 1
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Middle] = 2
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Far] = 16
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Left] = 2
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Right] = 2
CombatStyles.ShadowWalterBeckSecondStage.Limits[CombatZones.Rear] = 2
CombatStyles.ShadowWalterBeckSecondStage.CanFlee = false
CombatStyles.ShadowWalterBeckSecondStage.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.ShadowWalterBeckSecondStage.Sequences = {}
CombatStyles.ShadowWalterBeckSecondStage.Sequences[CombatSituations.Melee] = {
	{"ShadowWalterShotTooMuch", 5},
	{"ShadowWalterAntiSpamClearanceAttack", 15},
	{"ShadowWalterAntiSpamCloseStabAttack", 15},
	{"ShadowWalterAntiSpamQuickShotTeleport", 5},
	"ShadowBeckSpecialAttackShoulderCharge",
	"ShadowBeckAttackLeftRightSpin",
	"ShadowBeckSpin",
	"ShadowBeckStabNear",
	"ShadowBeckStabMid",
	{"ShadowBeckSpecialAttackSpinAround", 10},
	"ShadowBeckAttackLeftRightTwiceCombo",
	"Idle"
}
CombatStyles.ShadowWalterBeckSecondStage.Sequences[CombatSituations.HardBlocking] = {
	"ShadowWalterBeckAttackOutOfBlock"
}
CombatStyles.ShadowWalterBeckSecondStage.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.ShadowWalterBeckSecondStage.SecondsToWaitAfterTargetIsHit = 1.25
CombatStyles.ShadowWalterBeckSecondStage.MinSecondsBetweenRangedAttacks = 4.5
CombatStyles.ShadowWalterBeckSecondStage.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowWalterBeckSecondStage.CanBlock = true
CombatStyles.ShadowWalterBeckSecondStage.BlockData = {}
CombatStyles.ShadowWalterBeckSecondStage.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowWalterBeckSecondStage.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 5
CombatStyles.ShadowWalterBeckSecondStage.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.ShadowWalterBeckSecondStage.BlockData.SecondsToBlockFor = 1.5
CombatStyles.ShadowWalterBeckSecondStage.ValidStates = {}
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"ShadowWalterBeckRapidDistanceClosing",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeckSecondStage.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData = {}
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData.AOERangedAttackEntity = "ShadowSirWalterRangedAttackExplosion"
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData.AOEWeaponEffectName = "fxcre_shadow_walter_sword_ground_strike"
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData.SecondsBetweenAOEAttacks = 15
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData.LinearRangedAttackEntity = "ShadowSirWalterLinearAttackLarge"
CombatStyles.ShadowWalterBeckSecondStage.SentinelBalanceData.SecondsBetweenLinearAttacks = 10


-- WalterBeck Shadow --
CombatStyles.ShadowWalterBeck = {}
CombatStyles.ShadowWalterBeck.ForceWeaponType = WeaponTypes.Melee
CombatStyles.ShadowWalterBeck.AttachNonForcedWeaponType = true
CombatStyles.ShadowWalterBeck.DualWielding = true
CombatStyles.ShadowWalterBeck.ShootsInMelee = true
CombatStyles.ShadowWalterBeck.NonFormation = true
CombatStyles.ShadowWalterBeck.StrafeActionSpeed = 1
CombatStyles.ShadowWalterBeck.EnterRangedStrafeDist = 2
CombatStyles.ShadowWalterBeck.DesiredRange = 2
CombatStyles.ShadowWalterBeck.CanSheatheWeapon = true
CombatStyles.ShadowWalterBeck.Limits = {}
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Near] = 1
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Middle] = 2
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Far] = 16
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Left] = 2
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Right] = 2
CombatStyles.ShadowWalterBeck.Limits[CombatZones.Rear] = 2
CombatStyles.ShadowWalterBeck.CanFlee = false
CombatStyles.ShadowWalterBeck.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.ShadowWalterBeck.Sequences = {}
CombatStyles.ShadowWalterBeck.Sequences[CombatSituations.Melee] = {
	{"ShadowWalterShotTooMuch", 10},
	{"ShadowWalterAntiSpamClearanceAttack", 10},
	{"ShadowWalterAntiSpamCloseStabAttack", 10},
	{"ShadowWalterAntiSpamQuickShotTeleport", 5},
	"ShadowBeckSpecialAttackShoulderCharge",
	"ShadowBeckAttackLeftRightSpin",
	"ShadowBeckSpin",
	"ShadowBeckStabNear",
	"ShadowBeckStabMid",
	{"ShadowBeckSpecialAttackSpinAround", 10},
	"ShadowBeckAttackLeftRightTwiceCombo",
	"Idle"
}
CombatStyles.ShadowWalterBeck.Sequences[CombatSituations.HardBlocking] = {
	"ShadowWalterBeckAttackOutOfBlock"
}
CombatStyles.ShadowWalterBeck.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.ShadowWalterBeck.SecondsToWaitAfterTargetIsHit = 1.25
CombatStyles.ShadowWalterBeck.MinSecondsBetweenRangedAttacks = 4.5
CombatStyles.ShadowWalterBeck.CanStandOffAndShoot = "Aggressive"
CombatStyles.ShadowWalterBeck.CanBlock = true
CombatStyles.ShadowWalterBeck.BlockData = {}
CombatStyles.ShadowWalterBeck.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.ShadowWalterBeck.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 5
CombatStyles.ShadowWalterBeck.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.ShadowWalterBeck.BlockData.SecondsToBlockFor = 1.5
CombatStyles.ShadowWalterBeck.ValidStates = {}
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"UpdateWeaponWalterBeck",
	"CheckForBetterTarget",
	"ShadowWalterBeckRapidDistanceClosing",
	"PlayCombatSequence",
	"SentinelLinearRangedAttack",
	"SentinelAOERangedAttack",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.ShadowWalterBeck.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.ShadowWalterBeck.SentinelBalanceData = {}
CombatStyles.ShadowWalterBeck.SentinelBalanceData.AOERangedAttackEntity = "ShadowSirWalterRangedAttackExplosion"
CombatStyles.ShadowWalterBeck.SentinelBalanceData.AOEWeaponEffectName = "fxcre_shadow_walter_sword_ground_strike"
CombatStyles.ShadowWalterBeck.SentinelBalanceData.SecondsBetweenAOEAttacks = 10
CombatStyles.ShadowWalterBeck.SentinelBalanceData.LinearRangedAttackEntity = "ShadowSirWalterLinearAttackLarge"
CombatStyles.ShadowWalterBeck.SentinelBalanceData.SecondsBetweenLinearAttacks = 7.5


-- WalterBeck Torch --
CombatStyles.WalterBeckTorch = {}
CombatStyles.WalterBeckTorch.ForceWeaponType = WeaponTypes.Melee
CombatStyles.WalterBeckTorch.AttachNonForcedWeaponType = true
CombatStyles.WalterBeckTorch.NonFormation = true
CombatStyles.WalterBeckTorch.CanStrafe = false
CombatStyles.WalterBeckTorch.DualWielding = false
CombatStyles.WalterBeckTorch.ShootsInMelee = false
CombatStyles.WalterBeckTorch.RegroupWithHero = false
CombatStyles.WalterBeckTorch.CanSheatheWeapon = false
CombatStyles.WalterBeckTorch.SheatheInitialWeapons = true
CombatStyles.WalterBeckTorch.ActionModifiers = {}
CombatStyles.WalterBeckTorch.ActionModifiers.BlockBreaker = true
CombatStyles.WalterBeckTorch.Limits = {}
CombatStyles.WalterBeckTorch.Limits[CombatZones.Near] = 1.5
CombatStyles.WalterBeckTorch.Limits[CombatZones.Middle] = 2.5
CombatStyles.WalterBeckTorch.Limits[CombatZones.Far] = 3.5
CombatStyles.WalterBeckTorch.Limits[CombatZones.Left] = 2
CombatStyles.WalterBeckTorch.Limits[CombatZones.Right] = 2
CombatStyles.WalterBeckTorch.Limits[CombatZones.Rear] = 2
CombatStyles.WalterBeckTorch.CanFlee = false
CombatStyles.WalterBeckTorch.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.WalterBeckTorch.Sequences = {}
CombatStyles.WalterBeckTorch.Sequences[CombatSituations.Melee] = {
	"BeckAttackWithTorch"
}
CombatStyles.WalterBeckTorch.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.WalterBeckTorch.SecondsToWaitAfterTargetIsHit = 0.1
CombatStyles.WalterBeckTorch.MinSecondsBetweenRangedAttacks = 8
CombatStyles.WalterBeckTorch.CanStandOffAndShoot = "Aggressive"
CombatStyles.WalterBeckTorch.CanBlock = false
CombatStyles.WalterBeckTorch.ValidStates = {}
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"PlayCombatSequence",
	"FaceTarget"
}
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.Ranged] = CombatStyles.StandardRangedCombatStates
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.WalterBeckTorch.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- BennFinn --
CombatStyles.BennFinn = {}
CombatStyles.BennFinn.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BennFinn.TargetFilter = CombatStates.WalterBeckTargetFilter
CombatStyles.BennFinn.DesiredRange = 4
CombatStyles.BennFinn.NonFormation = true
CombatStyles.BennFinn.StrafeActionSpeed = 1
CombatStyles.BennFinn.CanSheatheWeapon = true
CombatStyles.BennFinn.RegroupWithHero = true
CombatStyles.BennFinn.RegroupWithHeroChaseRange = 15
CombatStyles.BennFinn.RegroupWithHeroPatrolRange = 10
CombatStyles.BennFinn.Limits = {}
CombatStyles.BennFinn.Limits[CombatZones.Near] = 1.5
CombatStyles.BennFinn.Limits[CombatZones.Middle] = 2.5
CombatStyles.BennFinn.Limits[CombatZones.Far] = 4.5
CombatStyles.BennFinn.Limits[CombatZones.Left] = 2
CombatStyles.BennFinn.Limits[CombatZones.Right] = 2
CombatStyles.BennFinn.Limits[CombatZones.Rear] = 3
CombatStyles.BennFinn.CanFlee = false
CombatStyles.BennFinn.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BennFinn.Sequences = {}
CombatStyles.BennFinn.Sequences[CombatSituations.Melee] = {
	{"FinnSpecial", 10},
	"FinnBackAttack",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditEliteFastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Finn4AttackCombo",
	"Idle"
}
CombatStyles.BennFinn.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"RangedIdle"
}
CombatStyles.BennFinn.Sequences[CombatSituations.HardBlocking] = {
	"FinnAttackOutOfBlock"
}
CombatStyles.BennFinn.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.BennFinn.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.BennFinn.SecondsToWaitAfterTargetIsHit = 0.5
CombatStyles.BennFinn.MinSecondsBetweenRangedAttacks = 1.5
CombatStyles.BennFinn.CanBlock = true
CombatStyles.BennFinn.BlockData = {}
CombatStyles.BennFinn.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.BennFinn.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BennFinn.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.BennFinn.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.BennFinn.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.BennFinn.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.BennFinn.BlockData.SecondsToBlockFor = 3
CombatStyles.BennFinn.CanEvadeShots = false
CombatStyles.BennFinn.OuterRingPercentAsRanged = 1
CombatStyles.BennFinn.ValidStates = {}
CombatStyles.BennFinn.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BennFinn.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BennFinn.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BennFinn.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BennFinn.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BennFinn.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BennFinn.CanStandOffAndShoot = "Defensive"
CombatStyles.BennFinn.ShootingBalanceData = {}
CombatStyles.BennFinn.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.95
CombatStyles.BennFinn.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.95
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.1
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 24
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.1
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.BennFinn.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 1


-- Kalin --
CombatStyles.KalinStyle = {}
CombatStyles.KalinStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.KalinStyle.CanStrafe = true
CombatStyles.KalinStyle.DesiredRange = 4
CombatStyles.KalinStyle.StrafeActionSpeed = 1
CombatStyles.KalinStyle.EnterRangedStrafeDist = 10
CombatStyles.KalinStyle.CanSheatheWeapon = true
CombatStyles.KalinStyle.RegroupWithHero = true
CombatStyles.KalinStyle.RegroupWithHeroChaseRange = 10
CombatStyles.KalinStyle.RegroupWithHeroPatrolRange = 10
CombatStyles.KalinStyle.Limits = {}
CombatStyles.KalinStyle.Limits[CombatZones.Near] = 1.5
CombatStyles.KalinStyle.Limits[CombatZones.Middle] = 2.5
CombatStyles.KalinStyle.Limits[CombatZones.Far] = 4.5
CombatStyles.KalinStyle.Limits[CombatZones.Left] = 2
CombatStyles.KalinStyle.Limits[CombatZones.Right] = 2
CombatStyles.KalinStyle.Limits[CombatZones.Rear] = 3
CombatStyles.KalinStyle.CanFlee = false
CombatStyles.KalinStyle.FleeAnim = "Flee"
CombatStyles.KalinStyle.FleeIntoAnim = "FleeInto"
CombatStyles.KalinStyle.FleeOutOfAnim = "FleeOutOf"
CombatStyles.KalinStyle.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.KalinStyle.Sequences = {}
CombatStyles.KalinStyle.Sequences[CombatSituations.Melee] = {
	{"FinnSpecial", 10},
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditEliteFastBackOff",
	"BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.KalinStyle.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditLeaderInteruptSpellRanged",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.KalinStyle.Sequences[CombatSituations.HardBlocking] = {
	"FinnAttackOutOfBlock"
}
CombatStyles.KalinStyle.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.KalinStyle.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.KalinStyle.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.KalinStyle.MinSecondsBetweenRangedAttacks = 4
CombatStyles.KalinStyle.CanStandOffAndShoot = "Aggressive"
CombatStyles.KalinStyle.CanBlock = true
CombatStyles.KalinStyle.BlockData = {}
CombatStyles.KalinStyle.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.KalinStyle.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.KalinStyle.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.KalinStyle.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.KalinStyle.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.KalinStyle.BlockData.NumberOfHitsToForceSecondaryBlock = 1
CombatStyles.KalinStyle.BlockData.SecondsToBlockFor = 2
CombatStyles.KalinStyle.CanEvadeShots = false
CombatStyles.KalinStyle.EvadeShotsData = {}
CombatStyles.KalinStyle.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.KalinStyle.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.KalinStyle.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.KalinStyle.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.KalinStyle.AntiSpamData = {}
CombatStyles.KalinStyle.AntiSpamData.TimeToCheckFor = 4
CombatStyles.KalinStyle.AntiSpamData.ShotsToTrigger = 4
CombatStyles.KalinStyle.AntiSpamData.SpellsToTrigger = 4
CombatStyles.KalinStyle.AntiSpamData.TimeToAggroFor = 8
CombatStyles.KalinStyle.OuterRingPercentAsRanged = 0.5
CombatStyles.KalinStyle.ValidStates = {}
CombatStyles.KalinStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.KalinStyle.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.KalinStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.KalinStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.KalinStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.KalinStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.KalinStyle.ShootingBalanceData = {}
CombatStyles.KalinStyle.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.KalinStyle.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.KalinStyle.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 1


-- Page --
CombatStyles.PageStyle = {}
CombatStyles.PageStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.PageStyle.CanStrafe = true
CombatStyles.PageStyle.DesiredRange = 4
CombatStyles.PageStyle.StrafeActionSpeed = 1
CombatStyles.PageStyle.EnterRangedStrafeDist = 10
CombatStyles.PageStyle.CanSheatheWeapon = true
CombatStyles.PageStyle.RegroupWithHero = true
CombatStyles.PageStyle.RegroupWithHeroChaseRange = 10
CombatStyles.PageStyle.RegroupWithHeroPatrolRange = 10
CombatStyles.PageStyle.Limits = {}
CombatStyles.PageStyle.Limits[CombatZones.Near] = 1.5
CombatStyles.PageStyle.Limits[CombatZones.Middle] = 2.5
CombatStyles.PageStyle.Limits[CombatZones.Far] = 4.5
CombatStyles.PageStyle.Limits[CombatZones.Left] = 2
CombatStyles.PageStyle.Limits[CombatZones.Right] = 2
CombatStyles.PageStyle.Limits[CombatZones.Rear] = 3
CombatStyles.PageStyle.CanFlee = false
CombatStyles.PageStyle.FleeAnim = "Flee"
CombatStyles.PageStyle.FleeIntoAnim = "FleeInto"
CombatStyles.PageStyle.FleeOutOfAnim = "FleeOutOf"
CombatStyles.PageStyle.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.PageStyle.Sequences = {}
CombatStyles.PageStyle.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditEliteFastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.PageStyle.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle",
	"BanditFastBackOff"
}
CombatStyles.PageStyle.Sequences[CombatSituations.HardBlocking] = {
	"FinnAttackOutOfBlock"
}
CombatStyles.PageStyle.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.PageStyle.MinSecondsBetweenMeleeAttacks = 0.25
CombatStyles.PageStyle.SecondsToWaitAfterTargetIsHit = 0.75
CombatStyles.PageStyle.MinSecondsBetweenRangedAttacks = 1.25
CombatStyles.PageStyle.CanStandOffAndShoot = "Aggressive"
CombatStyles.PageStyle.CanBlock = true
CombatStyles.PageStyle.BlockData = {}
CombatStyles.PageStyle.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.PageStyle.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.PageStyle.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.PageStyle.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.PageStyle.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.PageStyle.BlockData.NumberOfHitsToForceSecondaryBlock = 1
CombatStyles.PageStyle.BlockData.SecondsToBlockFor = 2
CombatStyles.PageStyle.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.PageStyle.CanEvadeShots = false
CombatStyles.PageStyle.EvadeShotsData = {}
CombatStyles.PageStyle.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.PageStyle.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.PageStyle.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.PageStyle.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.PageStyle.AntiSpamData = {}
CombatStyles.PageStyle.AntiSpamData.TimeToCheckFor = 4
CombatStyles.PageStyle.AntiSpamData.ShotsToTrigger = 4
CombatStyles.PageStyle.AntiSpamData.SpellsToTrigger = 4
CombatStyles.PageStyle.AntiSpamData.TimeToAggroFor = 8
CombatStyles.PageStyle.OuterRingPercentAsRanged = 0.5
CombatStyles.PageStyle.ValidStates = {}
CombatStyles.PageStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.PageStyle.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.PageStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.PageStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.PageStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.PageStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.PageStyle.ShootingBalanceData = {}
CombatStyles.PageStyle.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.95
CombatStyles.PageStyle.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.95
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.05
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.1
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.PageStyle.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 1


-- HollowMan Simmons --
CombatStyles.UndeadSimmons = {}
CombatStyles.UndeadSimmons.CombatGroupType = CombatGroupTypes.HollowManLike
CombatStyles.UndeadSimmons.CanSheatheWeapon = false
CombatStyles.UndeadSimmons.DualWieldMeleeSlot = DummyObjects.HAND_LEFT
CombatStyles.UndeadSimmons.NonFormation = true
CombatStyles.UndeadSimmons.TurnToFaceTolerance = 15
CombatStyles.UndeadSimmons.PreferredRange = 2.5
CombatStyles.UndeadSimmons.CanFightUnarmed = true
CombatStyles.UndeadSimmons.NoWispMove = true
CombatStyles.UndeadSimmons.Limits = {}
CombatStyles.UndeadSimmons.Limits[CombatZones.Near] = 1.5
CombatStyles.UndeadSimmons.Limits[CombatZones.Middle] = 4
CombatStyles.UndeadSimmons.Limits[CombatZones.Far] = 6
CombatStyles.UndeadSimmons.Limits[CombatZones.Left] = 1
CombatStyles.UndeadSimmons.Limits[CombatZones.Right] = 1
CombatStyles.UndeadSimmons.Limits[CombatZones.Rear] = 3
CombatStyles.UndeadSimmons.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.UndeadSimmons.SecondsToWaitAfterTargetIsHit = 0
CombatStyles.UndeadSimmons.SecondsToWaitAfterTargetIsAttacked = 0
CombatStyles.UndeadSimmons.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.UndeadSimmons.HollowManParams = {}
CombatStyles.UndeadSimmons.HollowManParams.WispSpeed = 1
CombatStyles.UndeadSimmons.HollowManParams.MinimumSpawnDist = 1.75
CombatStyles.UndeadSimmons.HollowManParams.SpawnDistRandom = 1.25
CombatStyles.UndeadSimmons.HollowManParams.TargetSpeedToDistMultiplier = 1.2
CombatStyles.UndeadSimmons.HollowManParams.DistForMove = 6
CombatStyles.UndeadSimmons.HollowManParams.ReturnUndergroundDist = 6
CombatStyles.UndeadSimmons.HollowManParams.RiseAttackPercentageChance = 100
CombatStyles.UndeadSimmons.HollowManParams.RunPercentageChance = 100
CombatStyles.UndeadSimmons.HollowManParams.RunPercentageChanceAgainstRanged = 100
CombatStyles.UndeadSimmons.HollowManParams.RunAttackPercentageChance = 100
CombatStyles.UndeadSimmons.Sequences = {}
CombatStyles.UndeadSimmons.Sequences[CombatSituations.Melee] = {
	"SimmonsRangedCounter",
	{"SimmonsSpellCast", 15},
	{"SimmonsBackAttack", 5},
	"HollowmanSummonerFarAttackCombo",
	"HollowmanSummonerCloseAttackCombo",
	"HollowmanSummonerAttackCombo",
	"IdleStrafeLeft",
	"IdleStrafeRight",
	"BackOff",
	"HollowManAdvance"
}
CombatStyles.UndeadSimmons.Sequences[CombatSituations.HardBlocking] = {
	"SimmonsAttackOutOfBlock"
}
CombatStyles.UndeadSimmons.ValidStates = {}
CombatStyles.UndeadSimmons.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"HollowManBuggerOffAndDie",
	"CheckForBetterTarget",
	"HollowManSummonAllies",
	"PlayCombatSequence",
	"HollowManCharge",
	"HollowManMove",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.UndeadSimmons.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.UndeadSimmons.SummonerData = {
	"CreatureHollowMan",
	"CreatureHollowManRanged",
	"CreatureHollowMan",
	"CreatureHollowManRanged",
	"CreatureHollowMan",
	"CreatureHollowManRanged",
	"CreatureHollowMan",
	"CreatureHollowManRanged"
}
CombatStyles.UndeadSimmons.CanBlock = true
CombatStyles.UndeadSimmons.BlockData = {}
CombatStyles.UndeadSimmons.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.UndeadSimmons.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.UndeadSimmons.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.UndeadSimmons.BlockData.SecondsToBlockFor = 1
CombatStyles.UndeadSimmons.CanEvadeShots = false


-- Balverine Disguised --
CombatStyles.DisguisedBalverine = {}
CombatStyles.DisguisedBalverine.TransformTarget = "CreatureBalverine"
CombatStyles.DisguisedBalverine.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DisguisedBalverine.CanStrafe = true
CombatStyles.DisguisedBalverine.DesiredRange = 4
CombatStyles.DisguisedBalverine.StrafeActionSpeed = 1
CombatStyles.DisguisedBalverine.EnterRangedStrafeDist = 10
CombatStyles.DisguisedBalverine.CanSheatheWeapon = true
CombatStyles.DisguisedBalverine.Limits = {}
CombatStyles.DisguisedBalverine.Limits[CombatZones.Near] = 1.5
CombatStyles.DisguisedBalverine.Limits[CombatZones.Middle] = 2.5
CombatStyles.DisguisedBalverine.Limits[CombatZones.Far] = 4.5
CombatStyles.DisguisedBalverine.Limits[CombatZones.Left] = 2
CombatStyles.DisguisedBalverine.Limits[CombatZones.Right] = 2
CombatStyles.DisguisedBalverine.Limits[CombatZones.Rear] = 3
CombatStyles.DisguisedBalverine.CanFlee = false
CombatStyles.DisguisedBalverine.FleeAnim = "Flee"
CombatStyles.DisguisedBalverine.FleeIntoAnim = "FleeInto"
CombatStyles.DisguisedBalverine.FleeOutOfAnim = "FleeOutOf"
CombatStyles.DisguisedBalverine.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.DisguisedBalverine.Sequences = {}
CombatStyles.DisguisedBalverine.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
    "BanditCloseAttackCombo",
    "BanditAttackCombo",
    "BanditGoad",
    "BanditOuterGoad",
	"Idle",
	"BanditHeroFlourishResponse",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.DisguisedBalverine.Sequences[CombatSituations.Ranged] = {
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.DisguisedBalverine.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.DisguisedBalverine.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.DisguisedBalverine.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.DisguisedBalverine.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.DisguisedBalverine.MinSecondsBetweenRangedAttacks = 7
CombatStyles.DisguisedBalverine.CanStandOffAndShoot = "Aggressive"
CombatStyles.DisguisedBalverine.CanBlock = true
CombatStyles.DisguisedBalverine.BlockData = {}
CombatStyles.DisguisedBalverine.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.DisguisedBalverine.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DisguisedBalverine.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.DisguisedBalverine.BlockData.SecondsToBlockFor = 1.3
CombatStyles.DisguisedBalverine.OuterRingPercentAsRanged = 0.5
CombatStyles.DisguisedBalverine.AntiSpamData = {}
CombatStyles.DisguisedBalverine.AntiSpamData.TimeToCheckFor = 4
CombatStyles.DisguisedBalverine.AntiSpamData.ShotsToTrigger = 4
CombatStyles.DisguisedBalverine.AntiSpamData.SpellsToTrigger = 4
CombatStyles.DisguisedBalverine.AntiSpamData.TimeToAggroFor = 8
CombatStyles.DisguisedBalverine.ValidStates = {}
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverine.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DisguisedBalverine.ShootingBalanceData = {}
CombatStyles.DisguisedBalverine.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.DisguisedBalverine.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.3
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.DisguisedBalverine.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Balverine Disguised Elite --
CombatStyles.DisguisedBalverineElite = {}
CombatStyles.DisguisedBalverineElite.TransformTarget = "CreatureBalverineSire"
CombatStyles.DisguisedBalverineElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DisguisedBalverineElite.CanStrafe = true
CombatStyles.DisguisedBalverineElite.DesiredRange = 4
CombatStyles.DisguisedBalverineElite.StrafeActionSpeed = 1
CombatStyles.DisguisedBalverineElite.EnterRangedStrafeDist = 10
CombatStyles.DisguisedBalverineElite.CanSheatheWeapon = true
CombatStyles.DisguisedBalverineElite.Limits = {}
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Near] = 1.5
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Far] = 4.5
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Left] = 2
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Right] = 2
CombatStyles.DisguisedBalverineElite.Limits[CombatZones.Rear] = 3
CombatStyles.DisguisedBalverineElite.CanFlee = false
CombatStyles.DisguisedBalverineElite.FleeAnim = "Flee"
CombatStyles.DisguisedBalverineElite.FleeIntoAnim = "FleeInto"
CombatStyles.DisguisedBalverineElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.DisguisedBalverineElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.DisguisedBalverineElite.Sequences = {}
CombatStyles.DisguisedBalverineElite.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
    "BanditOuterGoad",
    "Idle",
    "BanditEliteFarAttackCombo",
    "BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.DisguisedBalverineElite.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.DisguisedBalverineElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.DisguisedBalverineElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.DisguisedBalverineElite.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.DisguisedBalverineElite.SecondsToWaitAfterTargetIsHit = 2.5
CombatStyles.DisguisedBalverineElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.DisguisedBalverineElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.DisguisedBalverineElite.CanBlock = true
CombatStyles.DisguisedBalverineElite.BlockData = {}
CombatStyles.DisguisedBalverineElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.DisguisedBalverineElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DisguisedBalverineElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.DisguisedBalverineElite.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DisguisedBalverineElite.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.DisguisedBalverineElite.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.DisguisedBalverineElite.BlockData.SecondsToBlockFor = 1.8
CombatStyles.DisguisedBalverineElite.CanEvadeShots = false
CombatStyles.DisguisedBalverineElite.EvadeShotsData = {}
CombatStyles.DisguisedBalverineElite.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.DisguisedBalverineElite.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.DisguisedBalverineElite.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.DisguisedBalverineElite.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.DisguisedBalverineElite.AntiSpamData = {}
CombatStyles.DisguisedBalverineElite.AntiSpamData.TimeToCheckFor = 4
CombatStyles.DisguisedBalverineElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.DisguisedBalverineElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.DisguisedBalverineElite.AntiSpamData.TimeToAggroFor = 8
CombatStyles.DisguisedBalverineElite.OuterRingPercentAsRanged = 0.5
CombatStyles.DisguisedBalverineElite.ValidStates = {}
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DisguisedBalverineElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DisguisedBalverineElite.ShootingBalanceData = {}
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.5
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.DisguisedBalverineElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Inventor Phase1 DLC2 --
CombatStyles.DLC2InventorStylePhase1 = {}
CombatStyles.DLC2InventorStylePhase1.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2InventorStylePhase1.CanStrafe = false
CombatStyles.DLC2InventorStylePhase1.NonFormation = true
CombatStyles.DLC2InventorStylePhase1.DesiredRange = 1.5
CombatStyles.DLC2InventorStylePhase1.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.DLC2InventorStylePhase1.EnterStrafeDistcs = 0.0001
CombatStyles.DLC2InventorStylePhase1.InventorJumpDist = 5
CombatStyles.DLC2InventorStylePhase1.BalverineBoundAttackDistance = 16
CombatStyles.DLC2InventorStylePhase1.InventorPercentChanceOfJumpingBackToBoundDistance = 100
CombatStyles.DLC2InventorStylePhase1.SecondsBetweenBounds = 4
CombatStyles.DLC2InventorStylePhase1.SecondsBetweenJumps = 1
CombatStyles.DLC2InventorStylePhase1.CanSheatheWeapon = false
CombatStyles.DLC2InventorStylePhase1.Limits = {}
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Far] = 4
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Left] = 2
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Right] = 2
CombatStyles.DLC2InventorStylePhase1.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2InventorStylePhase1.CanFlee = false
CombatStyles.DLC2InventorStylePhase1.Sequences = {}
CombatStyles.DLC2InventorStylePhase1.Sequences[CombatSituations.Melee] = {
	"DLC2InventorRightLeftCombo",
	"DLC2InventorLeftAttack",
    "DLC2InventorRightAttack",
    "DLC2InventorJumpAttack",
    "DLC2InventorBackAttack",
    "Idle"
}
CombatStyles.DLC2InventorStylePhase1.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.DLC2InventorStylePhase1.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.DLC2InventorStylePhase1.MinSecondsBetweenRangedAttacks = 6
CombatStyles.DLC2InventorStylePhase1.CanBlock = true
CombatStyles.DLC2InventorStylePhase1.BlockData = {}
CombatStyles.DLC2InventorStylePhase1.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DLC2InventorStylePhase1.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2InventorStylePhase1.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.DLC2InventorStylePhase1.BlockData.SecondsToBlockFor = 1.2
CombatStyles.DLC2InventorStylePhase1.ValidStates = {}
CombatStyles.DLC2InventorStylePhase1.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"InventorSpamResponse",
	"InventorCloseDistance",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2InventorStylePhase1.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase1.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase1.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase1.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates



-- Inventor Phase2 DLC2 --
CombatStyles.DLC2InventorStylePhase2 = {}
CombatStyles.DLC2InventorStylePhase2.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2InventorStylePhase2.CanStrafe = false
CombatStyles.DLC2InventorStylePhase2.NonFormation = true
CombatStyles.DLC2InventorStylePhase2.DoRunIntoStrafe = true
CombatStyles.DLC2InventorStylePhase2.DesiredRange = 10
CombatStyles.DLC2InventorStylePhase2.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.DLC2InventorStylePhase2.EnterStrafeDistcs = 0.0001
CombatStyles.DLC2InventorStylePhase2.InventorJumpDist = 5
CombatStyles.DLC2InventorStylePhase2.BalverineBoundAttackDistance = 16
CombatStyles.DLC2InventorStylePhase2.InventorPercentChanceOfJumpingBackToBoundDistance = 100
CombatStyles.DLC2InventorStylePhase2.SecondsBetweenBounds = 4
CombatStyles.DLC2InventorStylePhase2.SecondsBetweenJumps = 1
CombatStyles.DLC2InventorStylePhase2.CanSheatheWeapon = false
CombatStyles.DLC2InventorStylePhase2.Limits = {}
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Far] = 16
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Left] = 2
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Right] = 2
CombatStyles.DLC2InventorStylePhase2.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2InventorStylePhase2.CanFlee = false
CombatStyles.DLC2InventorStylePhase2.Sequences = {}
CombatStyles.DLC2InventorStylePhase2.Sequences[CombatSituations.Melee] = {
	"DLC2InventorSpellFireballLightningJumpResponse",
	{"DLC2InventorSpellLightningAttack", 10},
	{"DLC2InventorSpellFireballAttack", 10},
	{"DLC2InventorSpellFireballLightningResponse", 5},
    "DLC2InventorJumpAttack",
    "DLC2InventorBackAttack",
    "Idle"
}
CombatStyles.DLC2InventorStylePhase2.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.DLC2InventorStylePhase2.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.DLC2InventorStylePhase2.MinSecondsBetweenRangedAttacks = 6
CombatStyles.DLC2InventorStylePhase2.ValidStates = {}
CombatStyles.DLC2InventorStylePhase2.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"InventorEscape",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2InventorStylePhase2.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase2.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase2.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase2.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Inventor Phase3 DLC2 --
CombatStyles.DLC2InventorStylePhase3 = {}
CombatStyles.DLC2InventorStylePhase3.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2InventorStylePhase3.CanStrafe = false
CombatStyles.DLC2InventorStylePhase3.NonFormation = true
CombatStyles.DLC2InventorStylePhase3.DesiredRange = 1.5
CombatStyles.DLC2InventorStylePhase3.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.DLC2InventorStylePhase3.EnterStrafeDistcs = 0.0001
CombatStyles.DLC2InventorStylePhase3.InventorJumpDist = 5
CombatStyles.DLC2InventorStylePhase3.BalverineBoundAttackDistance = 16
CombatStyles.DLC2InventorStylePhase3.InventorPercentChanceOfJumpingBackToBoundDistance = 100
CombatStyles.DLC2InventorStylePhase3.SecondsBetweenBounds = 4
CombatStyles.DLC2InventorStylePhase3.SecondsBetweenJumps = 1
CombatStyles.DLC2InventorStylePhase3.CanSheatheWeapon = false
CombatStyles.DLC2InventorStylePhase3.Limits = {}
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Far] = 16
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Left] = 2
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Right] = 2
CombatStyles.DLC2InventorStylePhase3.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2InventorStylePhase3.CanFlee = false
CombatStyles.DLC2InventorStylePhase3.Sequences = {}
CombatStyles.DLC2InventorStylePhase3.Sequences[CombatSituations.Melee] = {
	"DLC2InventorRightLeftCombo",
	{"DLC2InventorSpellLightningAttack", 10},
	{"DLC2InventorSpellFireballAttack", 10},
    "DLC2InventorLeftAttack",
    "DLC2InventorRightAttack",
    "DLC2InventorJumpAttack",
    "DLC2InventorBackAttack",
    "Idle"
}
CombatStyles.DLC2InventorStylePhase3.Sequences[CombatSituations.HardBlocking] = {
	"DLC2InventorOutOfBlock"
}
CombatStyles.DLC2InventorStylePhase3.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.DLC2InventorStylePhase3.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.DLC2InventorStylePhase3.MinSecondsBetweenRangedAttacks = 6
CombatStyles.DLC2InventorStylePhase3.CanBlock = true
CombatStyles.DLC2InventorStylePhase3.BlockData = {}
CombatStyles.DLC2InventorStylePhase3.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DLC2InventorStylePhase3.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2InventorStylePhase3.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.DLC2InventorStylePhase3.BlockData.SecondsToBlockFor = 1.2
CombatStyles.DLC2InventorStylePhase3.ValidStates = {}
CombatStyles.DLC2InventorStylePhase3.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"InventorSpamResponsePhase3",
	"InventorOutOfMeleePhase3",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2InventorStylePhase3.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase3.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase3.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStylePhase3.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Inventor DLC2 --
CombatStyles.DLC2InventorStyle = {}
CombatStyles.DLC2InventorStyle.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2InventorStyle.CanStrafe = false
CombatStyles.DLC2InventorStyle.NonFormation = true
CombatStyles.DLC2InventorStyle.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.DLC2InventorStyle.EnterStrafeDistcs = 0.0001
CombatStyles.DLC2InventorStyle.InventorJumpDist = 5
CombatStyles.DLC2InventorStyle.BalverineBoundAttackDistance = 16
CombatStyles.DLC2InventorStyle.InventorPercentChanceOfJumpingBackToBoundDistance = 100
CombatStyles.DLC2InventorStyle.SecondsBetweenBounds = 4
CombatStyles.DLC2InventorStyle.SecondsBetweenJumps = 1
CombatStyles.DLC2InventorStyle.CanSheatheWeapon = false
CombatStyles.DLC2InventorStyle.Limits = {}
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Far] = 16
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Left] = 2
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Right] = 2
CombatStyles.DLC2InventorStyle.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2InventorStyle.CanFlee = false
CombatStyles.DLC2InventorStyle.Sequences = {}
CombatStyles.DLC2InventorStyle.Sequences[CombatSituations.Melee] = {
	{"DLC2InventorSpellLightningAttack", 10},
	{"DLC2InventorSpellFireballAttack", 10},
	{"DLC2InventorSpellFireballLightningResponse", 5},
    "DLC2InventorJumpAttack",
    "DLC2InventorBackAttack",
    "Idle"
}
CombatStyles.DLC2InventorStyle.MinSecondsBetweenMeleeAttacks = 0.1
CombatStyles.DLC2InventorStyle.SecondsToWaitAfterTargetIsHit = 0.4
CombatStyles.DLC2InventorStyle.MinSecondsBetweenRangedAttacks = 6
CombatStyles.DLC2InventorStyle.ValidStates = {}
CombatStyles.DLC2InventorStyle.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"InventorEscape",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2InventorStyle.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStyle.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStyle.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2InventorStyle.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- DLC2FinalBoss --
CombatStyles.DLC2FinalBoss = {}
CombatStyles.DLC2FinalBoss.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2FinalBoss.CanStrafe = true
CombatStyles.DLC2FinalBoss.CanSheatheWeapon = false
CombatStyles.DLC2FinalBoss.MovementTolerance = 0.45
CombatStyles.DLC2FinalBoss.ActionModifiers = {}
CombatStyles.DLC2FinalBoss.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.DLC2FinalBoss.Limits = {}
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Middle] = 4.5
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Far] = 6
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Left] = 3
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Right] = 3
CombatStyles.DLC2FinalBoss.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2FinalBoss.StrafeActionSpeed = 1
CombatStyles.DLC2FinalBoss.EnterStrafeDist = 5
CombatStyles.DLC2FinalBoss.LeaveStrafeDelta = 2
CombatStyles.DLC2FinalBoss.FleeAnim = "Flee"
CombatStyles.DLC2FinalBoss.FleeIntoAnim = "FleeInto"
CombatStyles.DLC2FinalBoss.FleeOutOfAnim = "FleeOutOf"
CombatStyles.DLC2FinalBoss.Sequences = {}
CombatStyles.DLC2FinalBoss.Sequences[CombatSituations.Melee] = {
	"HighwaymanGetRidOfPistol",
	"DLC2BossCloseCombo",
	{"DLC2BossCloseSpellCast", 5},
	"DLC2BossCombo",
	"DLC2BossStrikeRightRollCombo",
	"DLC2BossStrikeLeftRollCombo",
	{"DLC2BossSpellCast", 5},
	"DLC2BossCloseInCombo",
	"DLC2BossBackSpellCast",
	"DLC2BossBackSpellCastTargeted",
    "DLC2BossLeftSpellCastTargeted",
    "DLC2BossRightSpellCastTargeted",
    "Idle"
}
CombatStyles.DLC2FinalBoss.Sequences[CombatSituations.Dodging] = {
	"DLC2BossFlourishOutOfBlock",
	"DLC2BossFlourishOutOfBlockRF",
	"DLC2BossSpellCastOutOfBlock",
	"DLC2BossSpellCastOutOfBlockRF",
	"DLC2BossAoESpellOutOfBlock"
}
CombatStyles.DLC2FinalBoss.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.DLC2FinalBoss.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.DLC2FinalBoss.MinSecondsBetweenRangedAttacks = 10
CombatStyles.DLC2FinalBoss.MinSecondsBetweenFlourishes = 1.5
CombatStyles.DLC2FinalBoss.MinSecondsBetweenLongSpellcast = 1
CombatStyles.DLC2FinalBoss.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.DLC2FinalBoss.CanBlock = true
CombatStyles.DLC2FinalBoss.BlockData = {}
CombatStyles.DLC2FinalBoss.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.DLC2FinalBoss.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2FinalBoss.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.DLC2FinalBoss.BlockData.SecondsToBlockFor = 2
CombatStyles.DLC2FinalBoss.DodgeAnimations = {
	"RollLeft",
    "RollRight"
}
CombatStyles.DLC2FinalBoss.CanEvadeShots = false
CombatStyles.DLC2FinalBoss.EvadeShotsData = {}
CombatStyles.DLC2FinalBoss.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.DLC2FinalBoss.EvadeShotsData.TimeToEvadeFor = 5
CombatStyles.DLC2FinalBoss.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.DLC2FinalBoss.EvadeAnimations = {
	"DodgeBackLeft",
	"DodgeBackRight"
}
CombatStyles.DLC2FinalBoss.ValidStates = {}
CombatStyles.DLC2FinalBoss.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"DLC2FinalBossSpamResponse",
	"RetreatFromFlourish",
	"DLC2FinalBossWings",
	"DLC2FinalBossFireRangedWeapon",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2FinalBoss.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBoss.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBoss.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBoss.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DLC2FinalBoss.ShootingBalanceData = {}
CombatStyles.DLC2FinalBoss.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.8
CombatStyles.DLC2FinalBoss.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.9
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0
CombatStyles.DLC2FinalBoss.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0



-- DLC2FinalBoss Phase1 --
CombatStyles.DLC2FinalBossPhase1 = {}
CombatStyles.DLC2FinalBossPhase1.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2FinalBossPhase1.CanStrafe = true
CombatStyles.DLC2FinalBossPhase1.CanSheatheWeapon = false
CombatStyles.DLC2FinalBossPhase1.MovementTolerance = 0.45
CombatStyles.DLC2FinalBossPhase1.ActionModifiers = {}
CombatStyles.DLC2FinalBossPhase1.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.DLC2FinalBossPhase1.Limits = {}
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Near] = 2
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Middle] = 4.5
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Far] = 6
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Left] = 3
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Right] = 3
CombatStyles.DLC2FinalBossPhase1.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2FinalBossPhase1.StrafeActionSpeed = 1
CombatStyles.DLC2FinalBossPhase1.EnterStrafeDist = 5
CombatStyles.DLC2FinalBossPhase1.LeaveStrafeDelta = 2
CombatStyles.DLC2FinalBossPhase1.FleeAnim = "Flee"
CombatStyles.DLC2FinalBossPhase1.FleeIntoAnim = "FleeInto"
CombatStyles.DLC2FinalBossPhase1.FleeOutOfAnim = "FleeOutOf"
CombatStyles.DLC2FinalBossPhase1.Sequences = {}
CombatStyles.DLC2FinalBossPhase1.Sequences[CombatSituations.Melee] = {
	"HighwaymanGetRidOfPistol",
	"DLC2BossCloseCombo",
	"DLC2BossCombo",
	"DLC2BossCloseInComboNoMagic",
	"DLC2BossBackSwordAttack",
	"Idle"
}
CombatStyles.DLC2FinalBossPhase1.Sequences[CombatSituations.Dodging] = {
	"DLC2BossFlourishOutOfBlock"
}
CombatStyles.DLC2FinalBossPhase1.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.DLC2FinalBossPhase1.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.DLC2FinalBossPhase1.MinSecondsBetweenRangedAttacks = 10
CombatStyles.DLC2FinalBossPhase1.MinSecondsBetweenFlourishes = 1.5
CombatStyles.DLC2FinalBossPhase1.MinSecondsBetweenLongSpellcast = 1
CombatStyles.DLC2FinalBossPhase1.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.DLC2FinalBossPhase1.CanBlock = true
CombatStyles.DLC2FinalBossPhase1.BlockData = {}
CombatStyles.DLC2FinalBossPhase1.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.DLC2FinalBossPhase1.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2FinalBossPhase1.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.DLC2FinalBossPhase1.BlockData.SecondsToBlockFor = 2
CombatStyles.DLC2FinalBossPhase1.DodgeAnimations = {
	"RollLeft",
    "RollRight"
}
CombatStyles.DLC2FinalBossPhase1.CanEvadeShots = false
CombatStyles.DLC2FinalBossPhase1.EvadeShotsData = {}
CombatStyles.DLC2FinalBossPhase1.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.DLC2FinalBossPhase1.EvadeShotsData.TimeToEvadeFor = 5
CombatStyles.DLC2FinalBossPhase1.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.DLC2FinalBossPhase1.EvadeAnimations = {
	"DodgeBackLeft",
	"DodgeBackRight"
}
CombatStyles.DLC2FinalBossPhase1.ValidStates = {}
CombatStyles.DLC2FinalBossPhase1.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"DLC2FinalBossSpamResponseNoMagic",
	"RetreatFromFlourish",
	"DLC2FinalBossWings",
	"DLC2FinalBossFireRangedWeapon",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2FinalBossPhase1.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase1.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase1.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase1.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData = {}
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.8
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.9
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0
CombatStyles.DLC2FinalBossPhase1.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0


-- DLC2FinalBoss Phase2 --
CombatStyles.DLC2FinalBossPhase2 = {}
CombatStyles.DLC2FinalBossPhase2.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2FinalBossPhase2.CanStrafe = true
CombatStyles.DLC2FinalBossPhase2.CanSheatheWeapon = false
CombatStyles.DLC2FinalBossPhase2.MovementTolerance = 0.45
CombatStyles.DLC2FinalBossPhase2.ActionModifiers = {}
CombatStyles.DLC2FinalBossPhase2.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.DLC2FinalBossPhase2.Limits = {}
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Near] = 2
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Middle] = 4.5
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Far] = 6
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Left] = 3
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Right] = 3
CombatStyles.DLC2FinalBossPhase2.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2FinalBossPhase2.StrafeActionSpeed = 1
CombatStyles.DLC2FinalBossPhase2.EnterStrafeDist = 5
CombatStyles.DLC2FinalBossPhase2.LeaveStrafeDelta = 2
CombatStyles.DLC2FinalBossPhase2.FleeAnim = "Flee"
CombatStyles.DLC2FinalBossPhase2.FleeIntoAnim = "FleeInto"
CombatStyles.DLC2FinalBossPhase2.FleeOutOfAnim = "FleeOutOf"
CombatStyles.DLC2FinalBossPhase2.Sequences = {}
CombatStyles.DLC2FinalBossPhase2.Sequences[CombatSituations.Melee] = {
	"HighwaymanGetRidOfPistol",
	"DLC2BossCloseCombo",
	"DLC2BossCombo",
	"DLC2BossStrikeRightRollCombo",
	"DLC2BossStrikeLeftRollCombo",
	"DLC2BossCloseInComboNoMagic",
	"DLC2BossBackSwordAttack",
	"Idle"
}
CombatStyles.DLC2FinalBossPhase2.Sequences[CombatSituations.Dodging] = {
	"DLC2BossFlourishOutOfBlock",
	"DLC2BossFlourishOutOfBlockRF"
}
CombatStyles.DLC2FinalBossPhase2.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.DLC2FinalBossPhase2.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.DLC2FinalBossPhase2.MinSecondsBetweenRangedAttacks = 10
CombatStyles.DLC2FinalBossPhase2.MinSecondsBetweenFlourishes = 1.5
CombatStyles.DLC2FinalBossPhase2.MinSecondsBetweenLongSpellcast = 1
CombatStyles.DLC2FinalBossPhase2.TimeAfterBeingStruckWithinWhichWeCanShoot = 6
CombatStyles.DLC2FinalBossPhase2.CanBlock = true
CombatStyles.DLC2FinalBossPhase2.BlockData = {}
CombatStyles.DLC2FinalBossPhase2.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.DLC2FinalBossPhase2.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2FinalBossPhase2.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.DLC2FinalBossPhase2.BlockData.SecondsToBlockFor = 2
CombatStyles.DLC2FinalBossPhase2.DodgeAnimations = {
	"RollLeft",
    "RollRight"
}
CombatStyles.DLC2FinalBossPhase2.CanEvadeShots = false
CombatStyles.DLC2FinalBossPhase2.EvadeShotsData = {}
CombatStyles.DLC2FinalBossPhase2.EvadeShotsData.TimeToCheckFor = 6
CombatStyles.DLC2FinalBossPhase2.EvadeShotsData.TimeToEvadeFor = 5
CombatStyles.DLC2FinalBossPhase2.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.DLC2FinalBossPhase2.EvadeAnimations = {
	"DodgeBackLeft",
	"DodgeBackRight"
}
CombatStyles.DLC2FinalBossPhase2.ValidStates = {}
CombatStyles.DLC2FinalBossPhase2.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"DLC2FinalBossSpamResponseNoMagic",
	"RetreatFromFlourish",
	"DLC2FinalBossWings",
	"DLC2FinalBossFireRangedWeapon",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2FinalBossPhase2.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase2.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase2.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2FinalBossPhase2.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData = {}
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.8
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.9
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0
CombatStyles.DLC2FinalBossPhase2.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0


-- DLC2Captain --
CombatStyles.DLC2Captain = {}
CombatStyles.DLC2Captain.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.DLC2Captain.TargetFilter = CombatStates.WalterBeckTargetFilter
CombatStyles.DLC2Captain.DesiredRange = 4
CombatStyles.DLC2Captain.NonFormation = true
CombatStyles.DLC2Captain.StrafeActionSpeed = 1
CombatStyles.DLC2Captain.CanSheatheWeapon = true
CombatStyles.DLC2Captain.RegroupWithHero = true
CombatStyles.DLC2Captain.RegroupWithHeroChaseRange = 15
CombatStyles.DLC2Captain.RegroupWithHeroPatrolRange = 10
CombatStyles.DLC2Captain.Limits = {}
CombatStyles.DLC2Captain.Limits[CombatZones.Near] = 1.5
CombatStyles.DLC2Captain.Limits[CombatZones.Middle] = 2.5
CombatStyles.DLC2Captain.Limits[CombatZones.Far] = 4.5
CombatStyles.DLC2Captain.Limits[CombatZones.Left] = 2
CombatStyles.DLC2Captain.Limits[CombatZones.Right] = 2
CombatStyles.DLC2Captain.Limits[CombatZones.Rear] = 3
CombatStyles.DLC2Captain.CanFlee = false
CombatStyles.DLC2Captain.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.DLC2Captain.Sequences = {}
CombatStyles.DLC2Captain.Sequences[CombatSituations.Melee] = {
	{"DLC2CaptainSpecial", 10},
	"FinnBackAttack",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
	"BanditEliteFastBackOff",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack",
	"Finn4AttackCombo",
    "Idle"
}
CombatStyles.DLC2Captain.Sequences[CombatSituations.Ranged] = {
	"NearRifleStrikeOne",
	"NearRifleStrikeTwo",
	"MidRifleStrikeOne",
	"MidRifleStrikeTwo",
	"RangedIdle"
}
CombatStyles.DLC2Captain.Sequences[CombatSituations.HardBlocking] = {
	"FinnAttackOutOfBlock"
}
CombatStyles.DLC2Captain.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheathePistol",
	"SheathePistolThenUnsheatheOneHandedWeapon"
}
CombatStyles.DLC2Captain.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.DLC2Captain.SecondsToWaitAfterTargetIsHit = 0.5
CombatStyles.DLC2Captain.MinSecondsBetweenRangedAttacks = 1.5
CombatStyles.DLC2Captain.CanBlock = true
CombatStyles.DLC2Captain.BlockData = {}
CombatStyles.DLC2Captain.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.DLC2Captain.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.DLC2Captain.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.DLC2Captain.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.DLC2Captain.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.DLC2Captain.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.DLC2Captain.BlockData.SecondsToBlockFor = 3
CombatStyles.DLC2Captain.OuterRingPercentAsRanged = 1
CombatStyles.DLC2Captain.ValidStates = {}
CombatStyles.DLC2Captain.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.DLC2Captain.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.DLC2Captain.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Captain.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Captain.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.DLC2Captain.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.DLC2Captain.CanStandOffAndShoot = "Defensive"
CombatStyles.DLC2Captain.ShootingBalanceData = {}
CombatStyles.DLC2Captain.ShootingBalanceData.StartingChanceToHitWithFirearm = 0.95
CombatStyles.DLC2Captain.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.95
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.1
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 24
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.1
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.DLC2Captain.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 1



-- uncomment for debug
-- GUI.DisplayMessageBox("uniquecombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end