
-- MinionAttackOne --
CombatSequences.MinionAttackOne = {}
CombatSequences.MinionAttackOne.Priority = SequencePriorities.Attack
CombatSequences.MinionAttackOne.Zones = {}
CombatSequences.MinionAttackOne.Zones[CombatZones.Near] = true
CombatSequences.MinionAttackOne.Zones[CombatZones.Middle] = true
CombatSequences.MinionAttackOne.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = -1
	}
}

-- MinionAttackTwo --
CombatSequences.MinionAttackTwo = {}
CombatSequences.MinionAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.MinionAttackTwo.Zones = {}
CombatSequences.MinionAttackTwo.Zones[CombatZones.Near] = true
CombatSequences.MinionAttackTwo.Zones[CombatZones.Middle] = true
CombatSequences.MinionAttackTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = -1
	}
}

-- MinionStepAttackTwo --
CombatSequences.MinionStepAttackTwo = {}
CombatSequences.MinionStepAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.MinionStepAttackTwo.Zones = {}
CombatSequences.MinionStepAttackTwo.Zones[CombatZones.Middle] = true
CombatSequences.MinionStepAttackTwo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = -1
	}
}

-- MinionNearAttackTwo --
CombatSequences.MinionNearAttackTwo = {}
CombatSequences.MinionNearAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.MinionNearAttackTwo.Zones = {}
CombatSequences.MinionNearAttackTwo.Zones[CombatZones.Near] = true
CombatSequences.MinionNearAttackTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = -1
	}
}

-- MinionLeftAttack --
CombatSequences.MinionLeftAttack = {}
CombatSequences.MinionLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.MinionLeftAttack.Zones = {}
CombatSequences.MinionLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.MinionLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = -1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- MinionRightAttack --
CombatSequences.MinionRightAttack = {}
CombatSequences.MinionRightAttack.Priority = SequencePriorities.Attack
CombatSequences.MinionRightAttack.Zones = {}
CombatSequences.MinionRightAttack.Zones[CombatZones.Right] = true
CombatSequences.MinionRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = -1,
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- MinionComboOne --
CombatSequences.MinionComboOne = {}
CombatSequences.MinionComboOne.Priority = SequencePriorities.Attack
CombatSequences.MinionComboOne.Zones = {}
CombatSequences.MinionComboOne.Zones[CombatZones.Near] = true
CombatSequences.MinionComboOne.Zones[CombatZones.Middle] = true
CombatSequences.MinionComboOne.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ComboOne",
		PushBackStrike = -1,
		DamageMultiplier = 0.45
	}
}

-- MinionComboTwo --
CombatSequences.MinionComboTwo = {}
CombatSequences.MinionComboTwo.Priority = SequencePriorities.Attack
CombatSequences.MinionComboTwo.Zones = {}
CombatSequences.MinionComboTwo.Zones[CombatZones.Near] = true
CombatSequences.MinionComboTwo.Zones[CombatZones.Middle] = true
CombatSequences.MinionComboTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ComboTwo",
		PushBackStrike = -1,
		DamageMultiplier = 0.27
	}
}

-- MinionPinningComboTwo --
CombatSequences.MinionPinningComboTwo = {}
CombatSequences.MinionPinningComboTwo.Priority = SequencePriorities.Attack
CombatSequences.MinionPinningComboTwo.Zones = {}
CombatSequences.MinionPinningComboTwo.Zones[CombatZones.Near] = true
CombatSequences.MinionPinningComboTwo.Zones[CombatZones.Middle] = true
CombatSequences.MinionPinningComboTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ComboTwo",
		PushBackStrike = 0.35,
		DamageMultiplier = 0.27
	}
}

-- MinionRearFlourish --
CombatSequences.MinionRearFlourish = {}
CombatSequences.MinionRearFlourish.Priority = SequencePriorities.Attack
CombatSequences.MinionRearFlourish.Zones = {}
CombatSequences.MinionRearFlourish.Zones[CombatZones.Rear] = true
CombatSequences.MinionRearFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		PushBackStrike = 0.4,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendInTime = 0.3,
		DamageMultiplier = 0.2
	}
}

-- MinionFlourish --
CombatSequences.MinionFlourish = {}
CombatSequences.MinionFlourish.Priority = SequencePriorities.Attack
CombatSequences.MinionFlourish.IsCombo = true
CombatSequences.MinionFlourish.Zones = {}
CombatSequences.MinionFlourish.Zones[CombatZones.Middle] = true
CombatSequences.MinionFlourish.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		PushBackStrike = 0.4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 0.2
	}
}

-- MinionSurrounded --
CombatSequences.MinionSurrounded = {}
CombatSequences.MinionSurrounded.IsValid = Predicate.IsSurrounded
CombatSequences.MinionSurrounded.Priority = SequencePriorities.Attack
CombatSequences.MinionSurrounded.Zones = {}
CombatSequences.MinionSurrounded.Zones[CombatZones.Middle] = true
CombatSequences.MinionSurrounded.Zones[CombatZones.Near] = true
CombatSequences.MinionSurrounded.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		PushBackStrike = 0.4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 0.2
	}
}

-- MinionAttackOutOfBlock --
CombatSequences.MinionAttackOutOfBlock = {}
CombatSequences.MinionAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.MinionAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.MinionAttackOutOfBlock.CounterAttack = true
CombatSequences.MinionAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.MinionAttackOutOfBlock.Zones = {}
CombatSequences.MinionAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.MinionAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.MinionAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		Unblockable = true,
		PushBackStrike = 1.6,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 0.2
	}
}

-- MinionHeroFlourishResponse --
CombatSequences.MinionHeroFlourishResponse = {}
CombatSequences.MinionHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.MinionHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.MinionHeroFlourishResponse.CounterAttack = true
CombatSequences.MinionHeroFlourishResponse.Zones = {}
CombatSequences.MinionHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.MinionHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.MinionHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	}
}

-- RoboMinionAttackOne --
CombatSequences.RoboMinionAttackOne = {}
CombatSequences.RoboMinionAttackOne.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionAttackOne.Zones = {}
CombatSequences.RoboMinionAttackOne.Zones[CombatZones.Near] = true
CombatSequences.RoboMinionAttackOne.Zones[CombatZones.Middle] = true
CombatSequences.RoboMinionAttackOne.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.8,
		PushBackStrike = -1
	}
}

-- RoboMinionStepAttackTwo --
CombatSequences.RoboMinionStepAttackTwo = {}
CombatSequences.RoboMinionStepAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionStepAttackTwo.Zones = {}
CombatSequences.RoboMinionStepAttackTwo.Zones[CombatZones.Middle] = true
CombatSequences.RoboMinionStepAttackTwo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "Walk",
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 0.8,
		PushBackStrike = -1
	}
}

-- RoboMinionNearAttackTwo --
CombatSequences.RoboMinionNearAttackTwo = {}
CombatSequences.RoboMinionNearAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionNearAttackTwo.Zones = {}
CombatSequences.RoboMinionNearAttackTwo.Zones[CombatZones.Near] = true
CombatSequences.RoboMinionNearAttackTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 0.8,
		PushBackStrike = -1
	}
}

-- RoboMinionFlourish --
CombatSequences.RoboMinionFlourish = {}
CombatSequences.RoboMinionFlourish.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionFlourish.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RoboMinionFlourish.IsCombo = true
CombatSequences.RoboMinionFlourish.Zones = {}
CombatSequences.RoboMinionFlourish.Zones[CombatZones.Near] = true
CombatSequences.RoboMinionFlourish.Zones[CombatZones.Middle] = true
CombatSequences.RoboMinionFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishWithSpellA",
		SpeedMultiplier = 0.8,
		PushBackStrike = 0.4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 1
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishWithSpellB",
		SpeedMultiplier = 0.8,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		Dummy = "Character.Focal.Chest",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- RoboMinionRearFlourish --
CombatSequences.RoboMinionRearFlourish = {}
CombatSequences.RoboMinionRearFlourish.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionRearFlourish.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RoboMinionRearFlourish.IsCombo = true
CombatSequences.RoboMinionRearFlourish.Zones = {}
CombatSequences.RoboMinionRearFlourish.Zones[CombatZones.Rear] = true
CombatSequences.RoboMinionRearFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishWithSpellA",
		SpeedMultiplier = 0.8,
		PushBackStrike = 0.4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendInTime = 0.3,
		DamageMultiplier = 1
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishWithSpellB",
		SpeedMultiplier = 0.8,
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		Dummy = "Character.Focal.Chest",
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- RoboMinionAttackOutOfBlock --
CombatSequences.RoboMinionAttackOutOfBlock = {}
CombatSequences.RoboMinionAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.RoboMinionAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.RoboMinionAttackOutOfBlock.CounterAttack = true
CombatSequences.RoboMinionAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RoboMinionAttackOutOfBlock.Zones = {}
CombatSequences.RoboMinionAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.RoboMinionAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.RoboMinionAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		Unblockable = true,
		SpeedMultiplier = 0.8,
		PushBackStrike = 0.4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 1
	}
}

-- ClockworkSoldierAttackTwo --
CombatSequences.ClockworkSoldierAttackTwo = {}
CombatSequences.ClockworkSoldierAttackTwo.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierAttackTwo.Zones = {}
CombatSequences.ClockworkSoldierAttackTwo.Zones[CombatZones.Near] = true
CombatSequences.ClockworkSoldierAttackTwo.Zones[CombatZones.Middle] = true
CombatSequences.ClockworkSoldierAttackTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		PushBackStrike = -1,
		HitOutsideAttackArc = true
	}
}

-- ClockworkSoldierAttackOneTwo --
CombatSequences.ClockworkSoldierAttackOneTwo = {}
CombatSequences.ClockworkSoldierAttackOneTwo.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierAttackOneTwo.Zones = {}
CombatSequences.ClockworkSoldierAttackOneTwo.Zones[CombatZones.Near] = true
CombatSequences.ClockworkSoldierAttackOneTwo.Zones[CombatZones.Middle] = true
CombatSequences.ClockworkSoldierAttackOneTwo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		PushBackStrike = -1,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		PushBackStrike = -1,
		HitOutsideAttackArc = true
	}
}

-- ClockworkSoldierAttackCombo --
CombatSequences.ClockworkSoldierAttackCombo = {}
CombatSequences.ClockworkSoldierAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierAttackCombo.Zones = {}
CombatSequences.ClockworkSoldierAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.ClockworkSoldierAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.ClockworkSoldierAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		PushBackStrike = -1,
		HitOutsideAttackArc = true
	}
}

-- ClockworkSoldierFlourish --
CombatSequences.ClockworkSoldierFlourish = {}
CombatSequences.ClockworkSoldierFlourish.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierFlourish.Zones = {}
CombatSequences.ClockworkSoldierFlourish.Zones[CombatZones.Near] = true
CombatSequences.ClockworkSoldierFlourish.Zones[CombatZones.Middle] = true
CombatSequences.ClockworkSoldierFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		SpeedMultiplier = 1,
		PushBackStrike = -1
	}
}

-- ClockworkSoldierRearFlourish --
CombatSequences.ClockworkSoldierRearFlourish = {}
CombatSequences.ClockworkSoldierRearFlourish.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierRearFlourish.IsCombo = true
CombatSequences.ClockworkSoldierRearFlourish.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ClockworkSoldierRearFlourish.Zones = {}
CombatSequences.ClockworkSoldierRearFlourish.Zones[CombatZones.Rear] = true
CombatSequences.ClockworkSoldierRearFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Flourish",
		SpeedMultiplier = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		FaceTargetThroughout = true
	}
}

-- ClockworkSoldierAttackOutOfBlock --
CombatSequences.ClockworkSoldierAttackOutOfBlock = {}
CombatSequences.ClockworkSoldierAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.ClockworkSoldierAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.ClockworkSoldierAttackOutOfBlock.CounterAttack = true
CombatSequences.ClockworkSoldierAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.ClockworkSoldierAttackOutOfBlock.Zones = {}
CombatSequences.ClockworkSoldierAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.ClockworkSoldierAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.ClockworkSoldierAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeHeadButt",
		SpeedMultiplier = 1.2,
		PushBackStrike = 3.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 1.5
	}
}


-- uncomment for debug
-- GUI.DisplayMessageBox("MinionSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end